/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.comm;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.mode.control.SampleControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.core.comm.ICommunicateManager;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelDataInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelsTransportInfo;
import com.owon.uppersoft.vds.core.wf.rt.LoadMedia;
import java.nio.ByteBuffer;
import java.util.Iterator;

public abstract class AbsGetDataRunner {
    public static final String UPDATE_FPS = "UPDATE_FPS";
    protected ICommunicateManager ism;
    protected DataHouse dh;
    protected ControlManager cm;
    private int framesCount;
    private long tbeg;

    public AbsGetDataRunner(DataHouse dataHouse, ICommunicateManager iCommunicateManager) {
        this.dh = dataHouse;
        this.ism = iCommunicateManager;
        this.cm = dataHouse.controlManager;
    }

    public ChannelsTransportInfo getDataT() {
        long l = System.currentTimeMillis();
        ChannelsTransportInfo channelsTransportInfo = this.getData();
        long l2 = System.currentTimeMillis();
        this.dbgln("getDataT: " + (l2 - l) + " ms");
        return channelsTransportInfo;
    }

    protected void updateFrame(int n) {
        this.computeFramesPerSec(n);
    }

    private void dbgln(String string) {
    }

    public abstract ChannelsTransportInfo getData();

    protected final void handleGroundNInverse(ChannelsTransportInfo channelsTransportInfo) {
        WaveFormManager waveFormManager = this.dh.getWaveFormManager();
        Iterator<? extends ChannelDataInfo> iterator = channelsTransportInfo.iterator_ChannelDataInfo();
        while (iterator.hasNext()) {
            ChannelDataInfo channelDataInfo = iterator.next();
            WaveFormInfo waveFormInfo = waveFormManager.getWaveForm((int)channelDataInfo.chl).wfi;
            ChannelInfo channelInfo = waveFormInfo.ci;
            if (channelInfo.isGround()) {
                channelDataInfo.forceGround(channelInfo.getPos0());
                continue;
            }
            channelDataInfo.handleADCBoundNInverse(channelInfo.getPos0(), channelInfo.isInverse());
        }
    }

    protected void handleAverage(ChannelsTransportInfo channelsTransportInfo) {
        WaveFormManager waveFormManager = this.dh.getWaveFormManager();
        SampleControl sampleControl = this.dh.controlManager.getSampleControl();
        boolean bl = sampleControl.avgon;
        int n = sampleControl.getAvgTimes();
        Iterator<? extends ChannelDataInfo> iterator = channelsTransportInfo.iterator_ChannelDataInfo();
        while (iterator.hasNext()) {
            ChannelDataInfo channelDataInfo = iterator.next();
            WaveFormInfo waveFormInfo = waveFormManager.getWaveForm((int)channelDataInfo.chl).wfi;
            ByteBuffer byteBuffer = channelDataInfo.getUniqueAdcbuf();
            waveFormInfo.ac.updateAverage(byteBuffer, n, bl);
        }
    }

    protected void handleFilter(ChannelsTransportInfo channelsTransportInfo, boolean bl) {
        WaveFormManager waveFormManager = this.dh.getWaveFormManager();
        Iterator<? extends ChannelDataInfo> iterator = channelsTransportInfo.iterator_ChannelDataInfo();
        while (iterator.hasNext()) {
            ChannelDataInfo channelDataInfo = iterator.next();
            WaveFormInfo waveFormInfo = waveFormManager.getWaveForm((int)channelDataInfo.chl).wfi;
            double d = waveFormInfo.ci.getFilter();
            channelDataInfo.applyFilter(d, bl);
        }
    }

    public void resetCumulateFrames() {
        this.framesCount = 0;
    }

    protected void computeFramesPerSec(int n) {
        if (this.framesCount == 0) {
            this.tbeg = System.currentTimeMillis();
        }
        this.framesCount += n;
        long l = System.currentTimeMillis() - this.tbeg;
        if (l > 1000L) {
            float f = (float)this.framesCount / (float)l;
            float f2 = f * 1000.0f;
            this.cm.pcs.firePropertyChange(UPDATE_FPS, (Object)-1, Float.valueOf(f2));
            this.resetCumulateFrames();
        }
    }

    protected void checkTrgEdgeMiddle() {
        this.dh.getWaveFormManager().setTrgEdgeMiddle();
    }

    public void release() {
        this.getChannelsTransportInfo().release();
    }

    public LoadMedia getLoadMedia() {
        return this.getChannelsTransportInfo();
    }

    public abstract ChannelsTransportInfo getChannelsTransportInfo();

    public void prepareToRun() {
        ChannelsTransportInfo channelsTransportInfo = this.getChannelsTransportInfo();
        channelsTransportInfo.frameAllNum = 0;
        channelsTransportInfo.resetStatusArr();
        this.resetCumulateFrames();
    }
}

