/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.ref;

import com.owon.uppersoft.dso.function.SoftwareControl;
import com.owon.uppersoft.dso.function.ref.IReferenceWaveForm;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WFTimeScopeControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.ref.IRefSource;
import com.owon.uppersoft.dso.util.ui.LineUtil;
import com.owon.uppersoft.vds.core.aspect.IView;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.core.control.MathControl;
import com.owon.uppersoft.vds.core.data.CByteArrayInputStream;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.core.rt.WFDrawRTUtil;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.util.format.UnitConversionUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.IntBuffer;

public abstract class RefWaveForm
implements IView,
IReferenceWaveForm {
    public static final int REFPROTOCOL_VDS_INVERSE = 1;
    public static final int REFPROTOCOL_VDS_PK_EXTEND = 2;
    public static final int REFPROTOCOL_VDS_DM = 3;
    public static final int REFPROTOCOL_VDS_PROBE = 4;
    public static final int REFPROTOCOL_VDS_CURRENT = 4;
    private byte statusType;
    private int offset;
    private int pos0;
    private int probeMultiIdx;
    private double gap;
    private int objIdx;
    private int waveType;
    protected int tbIdx;
    private int vbIdx;
    private int dataNums;
    protected int DMlen;
    private IntBuffer adcbuf;
    private IntBuffer pixbuf;
    protected int drawMode;
    protected boolean pk_detect = false;
    protected int pk_detect_type = -1;
    private int refFileVer = 4;

    @Override
    public int getTbIdx() {
        return this.tbIdx;
    }

    protected RefWaveForm() {
    }

    public void setAdcbuf(IntBuffer intBuffer) {
        this.adcbuf = intBuffer;
        this.pixbuf = IntBuffer.allocate(intBuffer.remaining());
    }

    public IntBuffer getAdcbuf() {
        return this.adcbuf;
    }

    @Override
    public int getObjIndex() {
        return this.objIdx;
    }

    @Override
    public int getVBIndex() {
        return this.vbIdx;
    }

    @Override
    public void setObjIndex(int n) {
        this.objIdx = n;
    }

    @Override
    public String getIntVoltageLabel_mV(VoltageProvider voltageProvider, MathControl mathControl) {
        if (this.waveType == 1) {
            return mathControl.MathVolt[this.vbIdx] + "V";
        }
        return UnitConversionUtil.getIntVoltageLabel_mV(voltageProvider.getVoltage(this.probeMultiIdx, this.vbIdx));
    }

    public void setPos0(int n) {
        this.pos0 = n;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public void setDrawMode(int n) {
        this.drawMode = WFDrawRTUtil.getDrawModeFromLength(n);
    }

    public void setDrawMode2(int n) {
        this.drawMode = n;
    }

    protected abstract void setPK_detect_typeByDrawMode(boolean var1, MachineType var2);

    @Override
    public void resetRTIntBuf(int n, boolean bl) {
        IntBuffer intBuffer = this.adcbuf;
        int n2 = intBuffer.position();
        int n3 = intBuffer.limit();
        int[] nArray = intBuffer.array();
        int[] nArray2 = this.pixbuf.array();
        int n4 = 0;
        if (bl) {
            for (int i = n2; i < n3; ++i) {
                nArray2[n4] = n - nArray[i];
                ++n4;
            }
        } else {
            for (int i = n2; i < n3; ++i) {
                nArray2[n4] = n - (nArray[i] << 1);
                ++n4;
            }
        }
        this.pixbuf.limit(n4);
        this.pixbuf.position(0);
    }

    @Override
    public void adjustView(ScreenContext screenContext, Rectangle rectangle) {
        int n = screenContext.getHcenter();
        this.resetRTIntBuf(n, screenContext.isScreenMode_3());
    }

    @Override
    public void paintView(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        int n = this.offset + rectangle.x;
        boolean bl = Platform.getDataHouse().isLineLink();
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(rectangle);
        Platform.getControlManager().getMachine().getPaintOne().paintRef(graphics2D, this.drawMode, n, bl, rectangle.y, rectangle.height, this.pk_detect, this.pixbuf, this.pk_detect_type, this.statusType, this.gap);
        graphics2D.setClip(shape);
    }

    public int getPos0onChart(ScreenContext screenContext) {
        int n = screenContext.getHcenter();
        if (screenContext.isScreenMode_3()) {
            return n - this.pos0;
        }
        return n - (this.pos0 << 1);
    }

    public Character getLetter() {
        return Character.valueOf((char)(this.objIdx + 97));
    }

    @Override
    public void paintItem(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle, boolean bl) {
        int n = this.getPos0onChart(screenContext);
        int n2 = rectangle.y;
        int n3 = rectangle.y + rectangle.height;
        LineUtil.paintChannelLabel(n, n2, n3, graphics2D, String.valueOf(this.getLetter()), 2, bl);
    }

    protected RefWaveForm loadFromFile(File file, ControlManager controlManager) {
        int n;
        int n2;
        CByteArrayInputStream cByteArrayInputStream = new CByteArrayInputStream(file);
        byte[] byArray = new byte[10];
        cByteArrayInputStream.get(byArray, 0, 10);
        String string = "";
        try {
            string = new String(byArray, 0, 10, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (!string.startsWith("SPBVDS")) {
            return null;
        }
        int n3 = cByteArrayInputStream.nextInt();
        int n4 = cByteArrayInputStream.nextInt();
        if (n4 >= 2 && (n2 = (n = cByteArrayInputStream.nextInt()) >>> 24) != 4) {
            return null;
        }
        this.DMlen = -1;
        if (n4 >= 3) {
            this.DMlen = cByteArrayInputStream.nextInt();
        }
        n = cByteArrayInputStream.nextInt();
        n2 = cByteArrayInputStream.nextByte();
        int n5 = cByteArrayInputStream.nextInt();
        cByteArrayInputStream.skip(n5);
        byte by = cByteArrayInputStream.nextByte();
        int n6 = cByteArrayInputStream.nextInt();
        this.statusType = cByteArrayInputStream.nextByte();
        this.waveType = cByteArrayInputStream.nextInt();
        this.pk_detect = cByteArrayInputStream.nextBoolean();
        this.pos0 = cByteArrayInputStream.nextInt();
        this.tbIdx = cByteArrayInputStream.nextInt();
        this.vbIdx = cByteArrayInputStream.nextInt();
        if (n4 >= 4) {
            this.probeMultiIdx = cByteArrayInputStream.nextInt();
        }
        this.dataNums = cByteArrayInputStream.nextInt();
        this.offset = cByteArrayInputStream.nextInt();
        this.gap = cByteArrayInputStream.nextDouble();
        if (this.statusType == 84) {
            this.setDrawMode((int)this.gap);
        }
        this.setPK_detect_typeByDrawMode(this.pk_detect, controlManager.getMachine());
        int n7 = cByteArrayInputStream.nextInt();
        cByteArrayInputStream.reset(n7);
        IntBuffer intBuffer = IntBuffer.allocate(this.dataNums);
        this.setAdcbuf(intBuffer);
        int[] nArray = intBuffer.array();
        cByteArrayInputStream.getIntArray(nArray, 0, this.dataNums);
        intBuffer.position(0);
        intBuffer.limit(this.dataNums);
        cByteArrayInputStream.dispose();
        return this;
    }

    protected RefWaveForm createFromWF(ControlManager controlManager, IRefSource iRefSource, WaveFormManager waveFormManager) {
        IntBuffer intBuffer = iRefSource.save2RefIntBuffer();
        this.setAdcbuf(intBuffer);
        int n = intBuffer.position();
        int n2 = intBuffer.limit();
        this.dataNums = n2 - n;
        this.tbIdx = controlManager.getTimeControl().getTimebaseIdx();
        this.waveType = iRefSource.getWaveType();
        this.pos0 = iRefSource.getPos0();
        this.vbIdx = iRefSource.getVoltbaseIndex();
        this.probeMultiIdx = iRefSource.getProbeMultiIdx();
        DataHouse dataHouse = Platform.getDataHouse();
        WFTimeScopeControl wFTimeScopeControl = waveFormManager.getWFTimeScopeControl();
        this.pk_detect = wFTimeScopeControl.isPK_Detect();
        boolean bl = dataHouse.isDMLoad();
        if (bl) {
            WaveFormInfo waveFormInfo = controlManager.getWaveFormInfoControl().getWaveFormInfoForDM();
            this.statusType = (byte)77;
            this.offset = waveFormInfo.getXOffset_DM();
            this.gap = waveFormInfo.getDMGap();
        } else {
            this.statusType = (byte)84;
            this.offset = wFTimeScopeControl.getSlowMoveOffset(wFTimeScopeControl.getDrawMode());
        }
        this.setDrawMode2(wFTimeScopeControl.getDrawMode());
        this.DMlen = controlManager.getDeepMemoryControl().getDeepDataLen();
        this.setPK_detect_typeByDrawMode(this.pk_detect, controlManager.getMachine());
        return this;
    }

    @Override
    public void persistRefFile(ControlManager controlManager, File file, int n) {
        try {
            long l;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            SoftwareControl softwareControl = controlManager.getSoftwareControl();
            byte[] byArray = softwareControl.getMachineHeader().getBytes("ASCII");
            randomAccessFile.write(byArray);
            randomAccessFile.writeInt(controlManager.getMachineTypeForSave());
            randomAccessFile.writeInt(this.refFileVer);
            randomAccessFile.writeByte(4);
            randomAccessFile.writeByte(0);
            randomAccessFile.writeByte(0);
            randomAccessFile.writeByte(0);
            randomAccessFile.writeInt(controlManager.getDeepMemoryControl().getDeepDataLen());
            long l2 = randomAccessFile.getFilePointer();
            randomAccessFile.writeInt(0);
            randomAccessFile.writeByte(0);
            long l3 = randomAccessFile.getFilePointer();
            randomAccessFile.writeInt(0);
            long l4 = l = randomAccessFile.getFilePointer();
            int[] nArray = this.adcbuf.array();
            int n2 = this.adcbuf.position();
            int n3 = this.adcbuf.limit();
            for (int i = n2; i < n3; ++i) {
                randomAccessFile.writeInt(nArray[i]);
            }
            int n4 = n3 - n2;
            long l5 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l3);
            randomAccessFile.writeInt((int)(l5 - l4));
            randomAccessFile.seek(l5);
            randomAccessFile.writeByte(1);
            l3 = randomAccessFile.getFilePointer();
            randomAccessFile.writeInt(0);
            l4 = randomAccessFile.getFilePointer();
            randomAccessFile.writeByte(this.statusType);
            randomAccessFile.writeInt(this.waveType);
            randomAccessFile.writeBoolean(this.pk_detect);
            randomAccessFile.writeInt(this.pos0);
            randomAccessFile.writeInt(this.tbIdx);
            randomAccessFile.writeInt(this.vbIdx);
            randomAccessFile.writeInt(this.probeMultiIdx);
            randomAccessFile.writeInt(n4);
            randomAccessFile.writeInt(this.offset);
            if (this.statusType == 77) {
                randomAccessFile.writeDouble(this.gap);
            } else {
                randomAccessFile.writeDouble(n);
            }
            randomAccessFile.writeInt((int)l);
            l5 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l3);
            randomAccessFile.writeInt((int)(l5 - l4));
            randomAccessFile.seek(l2);
            randomAccessFile.writeInt((int)randomAccessFile.length());
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

