/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model.trigger.helper;

import com.owon.uppersoft.dso.control.TrgLevelCheckHandler;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.TrgCheckType;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.model.trigger.VoltsensableTrigger;
import com.owon.uppersoft.dso.model.trigger.helper.PaintChannelTrgLabelContext;
import com.owon.uppersoft.dso.source.pack.VTPatchable;
import com.owon.uppersoft.dso.wf.ChartScreenSelectModel;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.data.LocRectangle;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class TriggerLevelDelegate {
    private TriggerControl trgc;
    private PaintChannelTrgLabelContext pctlc = new PaintChannelTrgLabelContext();
    private List<TriggerSet> altTrgslist;

    public TriggerLevelDelegate(TriggerControl triggerControl) {
        this.trgc = triggerControl;
    }

    public void preparePaintChannelTrgLabelContext(Graphics2D graphics2D, ScreenContext screenContext, LocRectangle locRectangle, ChartScreenSelectModel chartScreenSelectModel) {
        this.pctlc.prepare(graphics2D, screenContext, locRectangle, chartScreenSelectModel);
    }

    public void paintTrgLabel(ControlManager controlManager, WaveFormManager waveFormManager) {
        if (controlManager.isTrgLevelDisable()) {
            return;
        }
        if (this.trgc.isSingleTrg()) {
            TriggerSet triggerSet = this.trgc.getSingleTriggerSet();
            triggerSet.paintTriggerSet(waveFormManager, this.pctlc);
        } else {
            List<TriggerSet> list = this.getAltTrgslist();
            ListIterator<TriggerSet> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                TriggerSet triggerSet = listIterator.previous();
                triggerSet.paintTriggerSet(waveFormManager, this.pctlc);
            }
        }
    }

    public void changeTrgLabel(int n, TrgCheckType trgCheckType, int n2, WaveFormManager waveFormManager) {
        this.changeTrgLabel(n, trgCheckType, n2, waveFormManager, true);
    }

    public void changeTrgLabel(int n, TrgCheckType trgCheckType, int n2, WaveFormManager waveFormManager, boolean bl) {
        int n3;
        ControlManager controlManager = waveFormManager.getDataHouse().controlManager;
        WaveForm waveForm = waveFormManager.getWaveForm(n);
        if (waveForm == null) {
            return;
        }
        if (waveForm.isInverted()) {
            n2 = -n2;
        }
        int n4 = controlManager.getSupportChannelsNumber();
        TriggerSet triggerSet = null;
        if (n >= 0 && n < n4) {
            if (this.trgc.isSingleTrg()) {
                n3 = this.trgc.getSingleTrgChannel();
                if (n == n3) {
                    triggerSet = this.trgc.getSingleTriggerSet();
                } else {
                    this.logln("trgc changeTrgLevel chl != singleTrgChannel!!!");
                }
            } else {
                triggerSet = this.find(n);
            }
        } else {
            this.logln("trgc changeTrgLevel (chl >= 0 && chl < len) can not satisfy!!!");
        }
        if (triggerSet != null && (n3 = triggerSet.handelIncr(n2, trgCheckType)) != 0) {
            VTPatchable vTPatchable = this.trgc.getVTPatchable();
            switch (trgCheckType) {
                case UppOver: 
                case LowOver: {
                    if (!bl) break;
                    vTPatchable.submiteUpper_Lower(n, triggerSet.slope, trgCheckType);
                    break;
                }
                case VoltsenseOver: {
                    if (!bl) break;
                    vTPatchable.submiteVoltsense(n, (VoltsensableTrigger)triggerSet.getTrigger());
                    break;
                }
                default: {
                    return;
                }
            }
            controlManager.pcs.firePropertyChange(trgCheckType.fireItem, -1, n);
        }
    }

    private void logln(String string) {
    }

    public List<TriggerSet> getAltTrgslist() {
        if (this.altTrgslist == null) {
            this.altTrgslist = new LinkedList<TriggerSet>();
            int n = this.trgc.getChannelsNumber();
            for (int i = 0; i < n; ++i) {
                TriggerSet triggerSet = this.trgc.getAlternateTriggerSet(i);
                this.altTrgslist.add(triggerSet);
            }
        }
        return this.altTrgslist;
    }

    private TriggerSet find(int n) {
        List<TriggerSet> list = this.getAltTrgslist();
        ListIterator<TriggerSet> listIterator = list.listIterator();
        TriggerSet triggerSet = null;
        int n2 = 0;
        while (listIterator.hasNext()) {
            triggerSet = listIterator.next();
            if (triggerSet.getChannel() == n) {
                if (n2 != 0) {
                    listIterator.remove();
                    list.add(0, triggerSet);
                }
                return triggerSet;
            }
            ++n2;
        }
        return null;
    }

    public void checkAllAroundTrgLabel(TrgLevelCheckHandler trgLevelCheckHandler, WaveFormManager waveFormManager) {
        boolean bl = false;
        if (this.trgc.isSingleTrg()) {
            TriggerSet triggerSet = this.trgc.getSingleTriggerSet();
            int n = triggerSet.getChannel();
            WaveForm waveForm = waveFormManager.getWaveForm(n);
            if (waveForm == null || !waveForm.isOn()) {
                return;
            }
            trgLevelCheckHandler.setWaveForm(waveForm);
            bl = triggerSet.checkTrgLevel(trgLevelCheckHandler);
            if (bl) {
                return;
            }
        } else {
            for (TriggerSet triggerSet : this.getAltTrgslist()) {
                int n = triggerSet.getChannel();
                WaveForm waveForm = waveFormManager.getWaveForm(n);
                if (!waveForm.isOn()) continue;
                trgLevelCheckHandler.setWaveForm(waveForm);
                bl = triggerSet.checkTrgLevel(trgLevelCheckHandler);
                if (!bl) continue;
                return;
            }
        }
    }
}

