/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model.trigger;

import com.owon.uppersoft.dso.control.TrgLevelCheckHandler;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.TrgCheckType;
import com.owon.uppersoft.dso.model.trigger.TrgTypeDefine;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.common.Voltsensor;
import com.owon.uppersoft.dso.model.trigger.helper.PaintChannelTrgLabelContext;
import com.owon.uppersoft.dso.util.ui.LineUtil;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.data.LocRectangle;
import com.owon.uppersoft.vds.util.Pref;
import java.awt.Color;
import java.awt.Graphics2D;

public abstract class VoltsensableTrigger
extends AbsTrigger {
    public int coupling = 0;
    private int sweep = 0;
    private Voltsensor vs;

    public VoltsensableTrigger(TrgTypeDefine trgTypeDefine, int n) {
        super(trgTypeDefine);
        this.vs = new Voltsensor(n);
    }

    public boolean c_setVoltsense(int n) {
        return this.vs.c_setVoltsense(n);
    }

    public int c_getVoltsense() {
        return this.vs.c_getVoltsense();
    }

    public Voltsensor getVoltsensor() {
        return this.vs;
    }

    public boolean c_setVoltsenseWithoutSync(int n) {
        return this.vs.c_setVoltsense(n);
    }

    @Override
    public void loadProperties(String string, Pref pref) {
        String string2 = this.getName();
        this.coupling = pref.loadInt(string + string2 + ".coupling");
        this.setSweep(pref.loadInt(string + string2 + ".sweep"));
        this.c_setVoltsenseWithoutSync(pref.loadInt(string + string2 + ".voltsense"));
    }

    @Override
    public void persistProperties(String string, Pref pref) {
        String string2 = this.getName();
        pref.persistInt(string + string2 + ".coupling", this.coupling);
        pref.persistInt(string + string2 + ".sweep", this.getSweep());
        pref.persistInt(string + string2 + ".voltsense", this.vs.c_getVoltsense());
    }

    @Override
    public void paintIcon(Graphics2D graphics2D) {
    }

    @Override
    public String getLabelText(ChannelInfo channelInfo) {
        boolean bl = channelInfo.isInverse();
        int n = channelInfo.getVoltageLabel().getValue();
        int n2 = channelInfo.getPos0();
        double d = this.c_getVoltsense() - n2;
        d = d * (double)n / 25.0;
        return channelInfo.getValueLabel(bl ? -d : d);
    }

    @Override
    public boolean handelIncr(int n, TrgCheckType trgCheckType) {
        if (n != 0) {
            int n2 = this.vs.c_getVoltsense() + n;
            return this.c_setVoltsense(n2);
        }
        return false;
    }

    @Override
    public boolean doCheckTrgLevel(TrgLevelCheckHandler trgLevelCheckHandler) {
        int n = this.c_getVoltsense();
        return trgLevelCheckHandler.checkAroundTrgAndHandle(n, TrgCheckType.VoltsenseOver, TrgCheckType.NotOver);
    }

    protected void paintChannelVoltsenseLabel(PaintChannelTrgLabelContext paintChannelTrgLabelContext) {
        Graphics2D graphics2D = paintChannelTrgLabelContext.g2d;
        ScreenContext screenContext = paintChannelTrgLabelContext.pc;
        ChannelInfo channelInfo = paintChannelTrgLabelContext.ci;
        LocRectangle locRectangle = paintChannelTrgLabelContext.lr;
        boolean bl = paintChannelTrgLabelContext.lineLevel;
        boolean bl2 = paintChannelTrgLabelContext.cssm.isDrawArrow();
        boolean bl3 = channelInfo.isInverse();
        int n = channelInfo.getPos0();
        Color color = channelInfo.getColor();
        int n2 = this.c_getVoltsense();
        boolean bl4 = bl && !paintChannelTrgLabelContext.cssm.isTrgInfoControlActive();
        int n3 = 0;
        String string = this.getLabelText(channelInfo);
        if (bl3) {
            n2 = ChannelInfo.getLevelFromPos0(n2, n);
        }
        if (!screenContext.isScreenMode_3()) {
            n2 <<= 1;
        }
        n3 = screenContext.getHcenter() - n2;
        graphics2D.setColor(color);
        LineUtil.paintTrgLevel(n3, locRectangle, graphics2D, color, bl, bl2, "T");
        if (string != null && bl4) {
            LineUtil.paintTrgLevelDetail(graphics2D, locRectangle, n3, string, color);
        }
    }

    @Override
    public void paintChannelTrgLabel(PaintChannelTrgLabelContext paintChannelTrgLabelContext) {
        this.paintChannelVoltsenseLabel(paintChannelTrgLabelContext);
    }

    public abstract void submitVoltsense(int var1, int var2, Submitable var3);

    @Override
    public void c_setSweep(int n, TriggerControl triggerControl) {
        this.sweep = n;
        triggerControl.doSumbitTrgSweep(n);
    }

    public int setSweep(int n) {
        this.sweep = n;
        return this.sweep;
    }

    @Override
    public int getSweep() {
        return this.sweep;
    }
}

