/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model.trigger;

import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.vds.util.Pref;

public class TriggerUIInfo {
    private boolean auto_trglevel_middle;
    private int channel = 0;
    private TriggerControl tc;

    public TriggerUIInfo(TriggerControl triggerControl) {
        this.tc = triggerControl;
    }

    public void load(Pref pref, int n) {
        int n2 = pref.loadInt("triggerChannelIndex");
        if (n2 >= n) {
            n2 = 0;
        }
        this.setCurrentAltChannel(n2);
        this.auto_trglevel_middle = pref.loadBoolean("auto_trglevel_middle");
    }

    public void persist(Pref pref) {
        pref.persistInt("triggerChannelIndex", this.channel);
        pref.persistBoolean("auto_trglevel_middle", this.auto_trglevel_middle);
    }

    public boolean isAuto_trglevel_middle() {
        return this.auto_trglevel_middle;
    }

    public void setAuto_trglevel_middle(boolean bl) {
        this.auto_trglevel_middle = bl;
    }

    public void setCurrentAltChannel(int n) {
        this.channel = n;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getCurrentChannel() {
        if (this.tc.isSingleTrg()) {
            return this.tc.singleTriggerSet.getChannel();
        }
        return this.getChannel();
    }

    public TriggerSet getCurrentTriggerSet() {
        if (this.tc.isSingleTrg()) {
            return this.tc.singleTriggerSet;
        }
        return this.tc.getAlternateTriggerSet(this.channel);
    }

    public TriggerSet getTriggerSet(int n) {
        switch (n) {
            case 0: {
                return this.tc.getSingleTriggerSet();
            }
            case 1: {
                return this.tc.getAlternateTriggerSet(this.channel);
            }
        }
        return null;
    }

    public void c_setTrigger(AbsTrigger absTrigger) {
        this.getCurrentTriggerSet().setTrigger(absTrigger);
        this.tc.doSubmit();
    }

    public int getTriggerSetChannel(int n) {
        switch (n) {
            case 0: {
                return this.tc.singleTriggerSet.getChannel();
            }
            case 1: {
                return this.channel;
            }
        }
        return -1;
    }
}

