/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model.trigger;

import com.owon.uppersoft.dso.control.TrgLevelCheckHandler;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.EdgeTrigger;
import com.owon.uppersoft.dso.model.trigger.PulseTrigger;
import com.owon.uppersoft.dso.model.trigger.SlopeTrigger;
import com.owon.uppersoft.dso.model.trigger.TrgCheckType;
import com.owon.uppersoft.dso.model.trigger.TrgTypeDefine;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.VideoTrigger;
import com.owon.uppersoft.dso.model.trigger.VoltsensableTrigger;
import com.owon.uppersoft.dso.model.trigger.common.Voltsensor;
import com.owon.uppersoft.dso.model.trigger.helper.PaintChannelTrgLabelContext;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.util.Pref;

public class TriggerSet {
    private int channel;
    public final SlopeTrigger slope;
    public final PulseTrigger pulse;
    public final VideoTrigger video;
    public final EdgeTrigger edge;
    private AbsTrigger trigger;
    private int category;
    private int mode_single_alt;

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public AbsTrigger getTrigger() {
        return this.trigger;
    }

    public AbsTrigger getTriggerSet(byte by) {
        switch (by) {
            case 101: {
                return this.edge;
            }
            case 112: {
                return this.pulse;
            }
            case 115: {
                return this.slope;
            }
            case 118: {
                return this.video;
            }
        }
        return null;
    }

    public AbsTrigger getTriggerSet(TrgTypeDefine trgTypeDefine) {
        switch (trgTypeDefine) {
            case Edge: {
                return this.edge;
            }
            case Pulse: {
                return this.pulse;
            }
            case Slope: {
                return this.slope;
            }
            case Video: {
                return this.video;
            }
        }
        return null;
    }

    public void paintTriggerSet(WaveFormManager waveFormManager, PaintChannelTrgLabelContext paintChannelTrgLabelContext) {
        int n = this.getChannel();
        WaveForm waveForm = waveFormManager.getWaveForm(n);
        if (waveForm == null || !waveForm.isOn()) {
            return;
        }
        paintChannelTrgLabelContext.setChannelInfo(waveForm.wfi.ci);
        this.trigger.paintChannelTrgLabel(paintChannelTrgLabelContext);
    }

    public boolean isVoltsenseSupport() {
        return this.trigger instanceof VoltsensableTrigger;
    }

    public boolean checkTrgLevel(TrgLevelCheckHandler trgLevelCheckHandler) {
        return this.trigger.doCheckTrgLevel(trgLevelCheckHandler);
    }

    public boolean handelIncr(int n, TrgCheckType trgCheckType) {
        return this.trigger.handelIncr(n, trgCheckType);
    }

    public int getVoltsenseHalfRange() {
        if (this.trigger == this.pulse) {
            return 125;
        }
        if (this.trigger == this.edge) {
            return 125;
        }
        return -1;
    }

    public Voltsensor getVoltsense() {
        Voltsensor voltsensor;
        if (this.trigger == this.pulse) {
            voltsensor = this.pulse.getVoltsensor();
        } else if (this.trigger == this.edge) {
            voltsensor = this.edge.getVoltsensor();
        } else {
            return null;
        }
        return voltsensor;
    }

    void trySweepOnce(TriggerControl triggerControl) {
        this.getTrigger().c_setSweep(2, triggerControl);
    }

    void trySweepNormal(TriggerControl triggerControl) {
        this.getTrigger().c_setSweep(1, triggerControl);
    }

    boolean isSweepOnce() {
        return this.getTrigger().getSweep() == 2;
    }

    boolean isSweepNormal() {
        return this.getTrigger().getSweep() == 1;
    }

    boolean isSweepAuto() {
        return this.getTrigger().getSweep() == 0;
    }

    void resumeAuto(TriggerControl triggerControl) {
        this.getTrigger().c_setSweep(0, triggerControl);
    }

    public boolean isCurrentTrigger_Video() {
        return this.trigger == this.video;
    }

    public boolean isCurrentTrigger_Slope() {
        return this.trigger == this.slope;
    }

    public boolean isCurrentTrigger_Edge() {
        return this.trigger == this.edge;
    }

    public boolean isCurrentTrigger_Pulse() {
        return this.trigger == this.pulse;
    }

    public String category() {
        switch (this.category) {
            case 0: {
                return "single";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return "alt_" + this.category;
            }
        }
        return "ts_?";
    }

    public boolean isSingle() {
        return this.mode_single_alt == 0;
    }

    public boolean isAlternate() {
        return this.mode_single_alt == 1;
    }

    public TriggerSet(int n) {
        this.mode_single_alt = n;
        this.slope = new SlopeTrigger();
        this.pulse = new PulseTrigger();
        this.video = new VideoTrigger();
        this.edge = new EdgeTrigger();
    }

    public void initTrigger(TrgTypeDefine trgTypeDefine, int n) {
        this.category = n;
        switch (trgTypeDefine) {
            case Slope: {
                this.trigger = this.slope;
                break;
            }
            case Edge: {
                this.trigger = this.edge;
                break;
            }
            case Video: {
                this.trigger = this.video;
                break;
            }
            case Pulse: {
                this.trigger = this.pulse;
            }
        }
    }

    public void load(String string, Pref pref) {
        this.slope.load(string, pref);
        this.edge.load(string, pref);
        this.video.load(string, pref);
        this.pulse.load(string, pref);
    }

    public void setTrigger(AbsTrigger absTrigger) {
        this.trigger = absTrigger;
    }
}

