/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model.trigger;

import com.owon.uppersoft.dso.delegate.DefaultTriggerExtendDelegate;
import com.owon.uppersoft.dso.model.trigger.EdgeTrigger;
import com.owon.uppersoft.dso.model.trigger.TrgTypeDefine;
import com.owon.uppersoft.dso.model.trigger.TrgVTPatch;
import com.owon.uppersoft.dso.model.trigger.TriggerExtendDelegate;
import com.owon.uppersoft.dso.model.trigger.TriggerInfoForChannel;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.model.trigger.TriggerUIInfo;
import com.owon.uppersoft.dso.model.trigger.common.Voltsensor;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_TrgConditon;
import com.owon.uppersoft.dso.model.trigger.holdoff.HoldoffDelegate;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.dso.source.pack.VTPatchable;
import com.owon.uppersoft.vds.core.aspect.base.IOrgan;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.util.Pref;

public class TriggerControl
implements IOrgan,
TriggerInfoForChannel {
    private final TriggerSet[] trgchs;
    private int channelMode = 0;
    public TriggerSet singleTriggerSet;
    private TriggerExtendDelegate ted;
    private TriggerUIInfo tui = new TriggerUIInfo(this);
    private final int EXTTRG_CHANNEL;
    private int[] oldVoltsenses;
    private boolean trgEnable;

    public TriggerSet[] getAltTriggerSets() {
        return this.trgchs;
    }

    public TriggerSet getAlternateTriggerSet(int n) {
        return this.trgchs[n];
    }

    public int getChannelsNumber() {
        return this.trgchs.length;
    }

    public int getChannelMode() {
        return this.channelMode;
    }

    public TriggerSet getTriggerSetOrNull(int n) {
        if (this.isSingleTrg()) {
            if (this.singleTriggerSet.getChannel() != n) {
                return null;
            }
            return this.singleTriggerSet;
        }
        return this.trgchs[n];
    }

    public ETV_TrgConditon getTrgConditonOrNull(int n) {
        TriggerSet triggerSet = this.getTriggerSetOrNull(n);
        if (triggerSet != null) {
            if (triggerSet.isCurrentTrigger_Slope()) {
                return triggerSet.slope.trgcondition;
            }
            if (triggerSet.isCurrentTrigger_Pulse()) {
                return triggerSet.pulse.trgcondition;
            }
        }
        return null;
    }

    public TriggerSet getSingleTriggerSet() {
        return this.singleTriggerSet;
    }

    public int getSingleTrgChannel() {
        return this.singleTriggerSet.getChannel();
    }

    public DefaultTriggerExtendDelegate getDelegate() {
        return (DefaultTriggerExtendDelegate)this.ted;
    }

    public TriggerControl(int n, TriggerExtendDelegate triggerExtendDelegate) {
        this.ted = triggerExtendDelegate;
        this.EXTTRG_CHANNEL = n;
        this.trgchs = new TriggerSet[n];
        this.oldVoltsenses = new int[n];
    }

    public void load(Pref pref) {
        int n;
        int n2 = this.getChannelsNumber();
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            String string = "CH" + (n + 1) + ".";
            int n3 = pref.loadInt(string + "trgMode");
            TrgTypeDefine trgTypeDefine = TrgTypeDefine.getExtTrgDefine(n3);
            if (TrgTypeDefine.Video == trgTypeDefine) {
                if (bl) {
                    trgTypeDefine = TrgTypeDefine.Edge;
                } else {
                    bl = true;
                }
            }
            if (this.trgchs[n] == null) {
                this.trgchs[n] = new TriggerSet(1);
            }
            TriggerSet triggerSet = this.trgchs[n];
            triggerSet.initTrigger(trgTypeDefine, n + 1);
            triggerSet.setChannel(n);
            triggerSet.load(string, pref);
        }
        this.channelMode = pref.loadInt("triggerChannelMode");
        if (!this.isAlternativeSupport()) {
            this.channelMode = 0;
        }
        this.tui.load(pref, n2);
        n = pref.loadInt("SingleTrg.selectIndex");
        if (this.singleTriggerSet == null) {
            this.singleTriggerSet = new TriggerSet(0);
        }
        int n4 = pref.loadInt("SingleTrg.trgMode");
        TrgTypeDefine trgTypeDefine = TrgTypeDefine.values()[n4];
        this.singleTriggerSet.initTrigger(trgTypeDefine, 0);
        this.singleTriggerSet.setChannel(n);
        this.singleTriggerSet.load("SingleTrg.", pref);
    }

    public TriggerUIInfo getTriggerUIInfo() {
        return this.tui;
    }

    public void persist(Pref pref) {
        int n = this.getChannelsNumber();
        for (int i = 0; i < n; ++i) {
            String string = "CH" + (i + 1) + ".";
            TriggerSet triggerSet = this.trgchs[i];
            pref.persistInt(string + "trgMode", triggerSet.getTrigger().type.ordinal());
            triggerSet.slope.persist(string, pref);
            triggerSet.edge.persist(string, pref);
            triggerSet.video.persist(string, pref);
            triggerSet.pulse.persist(string, pref);
        }
        pref.persistInt("SingleTrg.selectIndex", this.singleTriggerSet.getChannel());
        pref.persistInt("SingleTrg.trgMode", this.singleTriggerSet.getTrigger().type.ordinal());
        this.tui.persist(pref);
        pref.persistInt("triggerChannelMode", this.channelMode);
        this.singleTriggerSet.slope.persist("SingleTrg.", pref);
        this.singleTriggerSet.edge.persist("SingleTrg.", pref);
        this.singleTriggerSet.video.persist("SingleTrg.", pref);
        this.singleTriggerSet.pulse.persist("SingleTrg.", pref);
    }

    public void c_setChannelMode(int n) {
        this.channelMode = n;
        this.doSubmit();
    }

    public void resetAltTrgSet() {
        for (TriggerSet triggerSet : this.trgchs) {
            EdgeTrigger edgeTrigger = triggerSet.edge;
            triggerSet.setTrigger(edgeTrigger);
            edgeTrigger.c_setVoltsense(0);
            edgeTrigger.setSweep(0);
            edgeTrigger.etvho = HoldoffDelegate.createDefaultETV();
        }
        this.selfSubmit();
    }

    public void resetSingleTrgset() {
        EdgeTrigger edgeTrigger = this.singleTriggerSet.edge;
        this.singleTriggerSet.setTrigger(edgeTrigger);
        edgeTrigger.c_setVoltsense(0);
        edgeTrigger.setSweep(0);
        edgeTrigger.etvho = HoldoffDelegate.createDefaultETV();
    }

    public void setChannelMode(int n) {
        this.channelMode = n;
    }

    public boolean isOnExtTrgMode() {
        return this.isSingleTrg() && this.isExtTrg(this.getSingleTrgChannel());
    }

    public void setSingleExtTrg() {
        TriggerSet triggerSet = this.singleTriggerSet;
        triggerSet.setChannel(this.EXTTRG_CHANNEL);
        triggerSet.setTrigger(triggerSet.edge);
        this.ted.handleSingleTrgChannel2Ext();
    }

    public boolean isExtTrg(int n) {
        return n == this.EXTTRG_CHANNEL;
    }

    public void saveOldVoltsenses(int n, long l) {
        if (this.isExtTrg(n)) {
            return;
        }
        this.oldVoltsenses[n] = (int)l;
    }

    public void setSingleChannel(int n) {
        Voltsensor voltsensor;
        TriggerSet triggerSet = this.singleTriggerSet;
        int n2 = triggerSet.getChannel();
        if (triggerSet.isVoltsenseSupport() && (voltsensor = triggerSet.getVoltsense()) != null) {
            long l = voltsensor.getVoltsense();
            this.saveOldVoltsenses(n2, l);
        }
        if (n >= this.getChannelsNumber()) {
            n = this.EXTTRG_CHANNEL;
        }
        if (this.isExtTrg(n)) {
            this.setSingleExtTrg();
            return;
        }
        if (n2 == n) {
            return;
        }
        triggerSet.setChannel(n);
        if (!this.isExtTrg(n2)) {
            this.ted.handleSingleTrgChannelLevelTransport(n2, n, triggerSet, this);
        } else {
            triggerSet.edge.c_setVoltsenseWithoutSync(this.oldVoltsenses[n]);
            this.ted.handleSingleTrgChannelReturnFromExt();
        }
    }

    public boolean isSweepEnable() {
        return this.isSingleTrg();
    }

    public boolean isSingleTrg() {
        return this.channelMode == 0;
    }

    @Override
    public boolean isChannelVideoTrg(int n) {
        if (this.isSingleTrg()) {
            if (this.singleTriggerSet.getChannel() == n) {
                return this.singleTriggerSet.isCurrentTrigger_Video();
            }
            return false;
        }
        TriggerSet triggerSet = this.getAlternateTriggerSet(n);
        if (triggerSet != null) {
            return triggerSet.isCurrentTrigger_Video();
        }
        return false;
    }

    public void trySweepOnce() {
        if (!this.isSingleTrg()) {
            return;
        }
        this.singleTriggerSet.trySweepOnce(this);
        this.ted.broadcastSweepOnce();
    }

    public void trySweepNormal() {
        if (!this.isSingleTrg()) {
            return;
        }
        this.singleTriggerSet.trySweepNormal(this);
        this.ted.broadcastSweepAuto();
    }

    public void trySweepAuto() {
        if (!this.isSingleTrg()) {
            return;
        }
        this.singleTriggerSet.resumeAuto(this);
        this.ted.broadcastSweepAuto();
    }

    public boolean isSweepOnce() {
        boolean bl = this.isSingleTrg() && this.singleTriggerSet.isSweepOnce();
        return bl;
    }

    public boolean isSweepNormal() {
        boolean bl = this.isSingleTrg() && this.singleTriggerSet.isSweepNormal();
        return bl;
    }

    public boolean isSweepAuto() {
        boolean bl = this.isSingleTrg() && this.singleTriggerSet.isSweepAuto();
        return bl;
    }

    public boolean resumeAuto() {
        if (this.isSweepOnce()) {
            this.singleTriggerSet.resumeAuto(this);
            this.doSubmit();
            return true;
        }
        return false;
    }

    public byte getChannelModeAlpha() {
        return (byte)(this.isSingleTrg() ? 115 : 97);
    }

    public int nextSingleChannel() {
        int n = this.getChannelsNumber();
        if (this.singleTriggerSet.isCurrentTrigger_Edge() && this.ted.isExtTrgSupport()) {
            ++n;
        }
        int n2 = this.singleTriggerSet.getChannel();
        n2 = (n2 + 1) % n;
        this.setSingleChannel(n2);
        return n2;
    }

    public void selfSubmit() {
    }

    public VTPatchable getVTPatchable() {
        return new TrgVTPatch(this);
    }

    public void setTrgEnable(boolean bl) {
        this.trgEnable = bl;
    }

    public void behaveWhenSwitch2SlowMove() {
        if (this.isSingleTrg()) {
            this.singleTriggerSet.resumeAuto(this);
        }
        this.doSubmit();
    }

    public boolean isTrgEnable() {
        return this.trgEnable;
    }

    public boolean isAlternativeSupport() {
        return this.getChannelsNumber() > 1;
    }

    public void doSubmit() {
        Submitable submitable = SubmitorFactory.reInit();
        this.selfSubmit();
        submitable.apply_trg();
    }

    public void doSumbitTrgSweep(int n) {
        Submitable submitable = SubmitorFactory.reInit();
        this.selfSubmit();
        submitable.apply_trgSweep(n);
    }

    public void doSubmitTrgCondition(int n) {
        Submitable submitable = SubmitorFactory.reInit();
        byte by = this.getChannelModeAlpha();
        TriggerSet triggerSet = this.getTriggerSetOrNull(n);
        if (triggerSet.isCurrentTrigger_Slope()) {
            triggerSet.slope.submitCondition(by, n, submitable);
        } else if (triggerSet.isCurrentTrigger_Pulse()) {
            triggerSet.pulse.submitCondition(by, n, submitable);
        }
        submitable.apply_trg();
    }
}

