/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model.trigger;

import com.owon.uppersoft.dso.control.TrgLevelCheckHandler;
import com.owon.uppersoft.dso.function.SoftwareControl;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.TrgCheckType;
import com.owon.uppersoft.dso.model.trigger.TrgTypeDefine;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerDefine;
import com.owon.uppersoft.dso.model.trigger.common.Thredshold;
import com.owon.uppersoft.dso.model.trigger.condition.TrgConditionDelegate;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_TrgConditon;
import com.owon.uppersoft.dso.model.trigger.helper.PaintChannelTrgLabelContext;
import com.owon.uppersoft.dso.util.ui.LineUtil;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.data.LocRectangle;
import com.owon.uppersoft.vds.util.Pref;
import java.awt.Color;
import java.awt.Graphics2D;

public class SlopeTrigger
extends AbsTrigger {
    public static final int ThredsholdHalfRange = 125;
    public int condition = 0;
    private Thredshold ts;
    public ETV_TrgConditon trgcondition = TrgConditionDelegate.createETV();
    private int sweep = 0;
    private TrgCheckType thredsholdType = TrgCheckType.NotOver;
    static final String T1 = "T";
    static final String T2 = "T";

    public Thredshold getThredshold() {
        return this.ts;
    }

    public boolean c_setUppestOrLowest(TrgCheckType trgCheckType, int n) {
        switch (trgCheckType) {
            case UppOver: {
                return this.ts.c_setUppest(n);
            }
            case LowOver: {
                return this.ts.c_setLowest(n);
            }
        }
        return false;
    }

    public boolean c_addUppestOrLowest(TrgCheckType trgCheckType, int n) {
        switch (trgCheckType) {
            case UppOver: {
                return this.ts.c_setUppest(this.ts.c_getUppest() + n);
            }
            case LowOver: {
                return this.ts.c_setLowest(this.ts.c_getLowest() + n);
            }
        }
        return false;
    }

    public int c_getLowest() {
        return this.ts.c_getLowest();
    }

    public int c_getUppest() {
        return this.ts.c_getUppest();
    }

    public boolean c_setUppestWithoutSync(int n) {
        return this.ts.c_setUppest(n);
    }

    public boolean c_setLowestWithoutSync(int n) {
        return this.ts.c_setLowest(n);
    }

    public String getUppestLabel(ChannelInfo channelInfo) {
        return this.ts.getUppestLabel(channelInfo);
    }

    public String getLowestLabel(ChannelInfo channelInfo) {
        return this.ts.getLowestLabel(channelInfo);
    }

    public SlopeTrigger() {
        super(TrgTypeDefine.Slope);
        this.ts = new Thredshold(125);
    }

    @Override
    public void paintIcon(Graphics2D graphics2D) {
    }

    @Override
    public void loadProperties(String string, Pref pref) {
        String string2 = this.getName();
        this.loadETV(string, pref, this.trgcondition);
        this.condition = pref.loadInt(string + string2 + ".condition");
        this.c_setUppestWithoutSync(pref.loadInt(string + string2 + ".uppest"));
        this.c_setLowestWithoutSync(pref.loadInt(string + string2 + ".lowest"));
        this.setSweep(pref.loadInt(string + string2 + ".sweep"));
    }

    @Override
    public void persistProperties(String string, Pref pref) {
        String string2 = this.getName();
        this.persistETV(string, pref, this.trgcondition);
        pref.persistInt(string + string2 + ".condition", this.condition);
        pref.persistInt(string + string2 + ".uppest", this.ts.c_getUppest());
        pref.persistInt(string + string2 + ".lowest", this.ts.c_getLowest());
        pref.persistInt(string + string2 + ".sweep", this.getSweep());
    }

    @Override
    public String getIconKey() {
        String string = null;
        switch (this.condition) {
            case 0: 
            case 1: 
            case 2: {
                string = "sr.png";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "sf.png";
                break;
            }
        }
        return string;
    }

    @Override
    public String getLabelText(ChannelInfo channelInfo) {
        String string;
        switch (this.condition) {
            case 0: 
            case 3: {
                string = ">";
                break;
            }
            case 1: 
            case 4: {
                string = "=";
                break;
            }
            case 2: 
            case 5: {
                string = "<";
                break;
            }
            default: {
                return null;
            }
        }
        return string + " " + this.trgcondition;
    }

    @Override
    public void nextStatus() {
        this.condition = (this.condition + 1) % TriggerDefine.CONDITIONS_SLOPE.length;
    }

    @Override
    public boolean handelIncr(int n, TrgCheckType trgCheckType) {
        this.thredsholdType = trgCheckType;
        return this.c_addUppestOrLowest(trgCheckType, n);
    }

    @Override
    public boolean doCheckTrgLevel(TrgLevelCheckHandler trgLevelCheckHandler) {
        TrgCheckType trgCheckType;
        TrgCheckType trgCheckType2;
        int n;
        int n2;
        switch (this.thredsholdType) {
            default: {
                n2 = this.ts.c_getUppest();
                n = this.ts.c_getLowest();
                trgCheckType2 = TrgCheckType.UppOver;
                trgCheckType = TrgCheckType.LowOver;
                break;
            }
            case LowOver: {
                n = this.ts.c_getUppest();
                n2 = this.ts.c_getLowest();
                trgCheckType2 = TrgCheckType.LowOver;
                trgCheckType = TrgCheckType.UppOver;
            }
        }
        boolean bl = trgLevelCheckHandler.checkAroundTrgAndHandleOnTrue(n2, trgCheckType2);
        if (bl) {
            return bl;
        }
        return trgLevelCheckHandler.checkAroundTrgAndHandle(n, trgCheckType, TrgCheckType.NotOver);
    }

    @Override
    public void paintChannelTrgLabel(PaintChannelTrgLabelContext paintChannelTrgLabelContext) {
        String string;
        int n;
        String string2;
        int n2;
        Graphics2D graphics2D = paintChannelTrgLabelContext.g2d;
        ScreenContext screenContext = paintChannelTrgLabelContext.pc;
        ChannelInfo channelInfo = paintChannelTrgLabelContext.ci;
        LocRectangle locRectangle = paintChannelTrgLabelContext.lr;
        boolean bl = paintChannelTrgLabelContext.lineLevel;
        boolean bl2 = channelInfo.isInverse();
        int n3 = channelInfo.getPos0();
        Color color = channelInfo.getColor();
        boolean bl3 = bl && !paintChannelTrgLabelContext.cssm.isTrgInfoControlActive();
        int n4 = 0;
        String string3 = null;
        int n5 = this.ts.c_getLowest();
        int n6 = this.ts.c_getUppest();
        if (bl2) {
            n6 = ChannelInfo.getLevelFromPos0(n6, n3);
            n5 = ChannelInfo.getLevelFromPos0(n5, n3);
        }
        if (!screenContext.isScreenMode_3()) {
            n5 <<= 1;
            n6 <<= 1;
        }
        boolean bl4 = false;
        int n7 = screenContext.getHcenter();
        switch (this.thredsholdType) {
            case LowOver: {
                if (bl3) {
                    string3 = this.getLowestLabel(channelInfo);
                }
                n2 = n7 - n6;
                string2 = "T";
                n = n7 - n5;
                string = "T";
                bl4 = true;
                break;
            }
            case UppOver: {
                if (bl3) {
                    string3 = this.getUppestLabel(channelInfo);
                }
                n2 = n7 - n5;
                string2 = "T";
                n = n7 - n6;
                string = "T";
                bl4 = true;
                break;
            }
            default: {
                n2 = n7 - n6;
                string2 = "T";
                n = n7 - n5;
                string = "T";
                bl4 = false;
            }
        }
        LineUtil.paintThredsholds(n2, locRectangle, graphics2D, bl, false, color, string2);
        LineUtil.paintThredsholds(n, locRectangle, graphics2D, bl, bl4 &= bl, color, string);
        n4 = n;
        if (string3 != null && bl3) {
            LineUtil.paintTrgLevelDetail(graphics2D, locRectangle, n4, string3, color);
        }
    }

    public void submitUpper_Lower(int n, int n2, Submitable submitable) {
        submitable.c_trg_slope(n, n2, (byte)2, this.ts.c_getUppest());
        submitable.c_trg_slope(n, n2, (byte)6, this.ts.c_getLowest());
    }

    public void submitUpper_Lower(int n, int n2, Submitable submitable, TrgCheckType trgCheckType) {
        if (trgCheckType.code == 6) {
            submitable.c_trg_slope(n, n2, (byte)6, this.ts.c_getLowest());
        } else if (trgCheckType.code == 2) {
            submitable.c_trg_slope(n, n2, (byte)2, this.ts.c_getUppest());
        }
    }

    @Override
    public void submitHoldOff(int n, int n2, Submitable submitable) {
        submitable.c_trg_slope(n, n2, (byte)4, this.etvho.toInt(), this.etvho.getValueDivTimeOnStage(), this.etvho.enumPart());
    }

    public void submitCondition(int n, int n2, Submitable submitable) {
        if (SoftwareControl.firmware > 2) {
            int[] nArray = this.trgcondition.getValue();
            submitable.c_trg_slope(n2, (byte)5, this.condition, this.trgcondition.toInt(), nArray[0], nArray[1]);
            return;
        }
        submitable.c_trg_slope(n, n2, (byte)5, this.condition, this.trgcondition.toInt(), this.trgcondition.getValueDivTimeOnStage(), this.trgcondition.enumPart());
    }

    public static final boolean isCondition_Equal(int n) {
        return n == 1 || n == 4;
    }

    @Override
    public void c_setSweep(int n, TriggerControl triggerControl) {
        this.sweep = n;
        triggerControl.doSumbitTrgSweep(n);
    }

    public int setSweep(int n) {
        this.sweep = n;
        return this.sweep;
    }

    @Override
    public int getSweep() {
        return this.sweep;
    }
}

