/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model.trigger;

import com.owon.uppersoft.dso.function.SoftwareControl;
import com.owon.uppersoft.dso.model.trigger.TrgTypeDefine;
import com.owon.uppersoft.dso.model.trigger.TriggerDefine;
import com.owon.uppersoft.dso.model.trigger.VoltsensableTrigger;
import com.owon.uppersoft.dso.model.trigger.condition.TrgConditionDelegate;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_TrgConditon;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.util.Pref;
import java.awt.Graphics2D;

public class PulseTrigger
extends VoltsensableTrigger {
    public static final int VoltSenseHalfRange = 125;
    public int condition = 0;
    public ETV_TrgConditon trgcondition = TrgConditionDelegate.createETV();

    public PulseTrigger() {
        super(TrgTypeDefine.Pulse, 125);
    }

    @Override
    public void loadProperties(String string, Pref pref) {
        super.loadProperties(string, pref);
        this.loadETV(string, pref, this.trgcondition);
        String string2 = this.getName();
        this.condition = pref.loadInt(string + string2 + ".condition");
    }

    @Override
    public void persistProperties(String string, Pref pref) {
        this.persistETV(string, pref, this.trgcondition);
        String string2 = this.getName();
        pref.persistInt(string + string2 + ".condition", this.condition);
        super.persistProperties(string, pref);
    }

    @Override
    public String getIconKey() {
        String string = null;
        switch (this.condition) {
            case 0: 
            case 1: 
            case 2: {
                string = "pr.png";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "pf.png";
                break;
            }
        }
        return string;
    }

    @Override
    public void paintIcon(Graphics2D graphics2D) {
        int n = 40;
        int n2 = 12;
        switch (this.condition) {
            case 0: 
            case 3: {
                graphics2D.drawString(">", n, n2);
                break;
            }
            case 1: 
            case 4: {
                graphics2D.drawString("=", n, n2);
                break;
            }
            case 2: 
            case 5: {
                graphics2D.drawString("<", n, n2);
            }
        }
    }

    public String getConditionText() {
        String string;
        switch (this.condition) {
            case 0: 
            case 3: {
                string = ">";
                break;
            }
            case 1: 
            case 4: {
                string = "=";
                break;
            }
            case 2: 
            case 5: {
                string = "<";
                break;
            }
            default: {
                return null;
            }
        }
        return string + " " + this.trgcondition;
    }

    public int toRelateSense(int n) {
        return this.c_getVoltsense() - n;
    }

    @Override
    public void nextStatus() {
        this.condition = (this.condition + 1) % TriggerDefine.CONDITIONS_PULSE.length;
    }

    @Override
    public void submitVoltsense(int n, int n2, Submitable submitable) {
        submitable.c_trg_pulse(n, n2, (byte)6, this.c_getVoltsense(), this.getRaiseNFall());
    }

    public int getRaiseNFall() {
        return this.condition <= 2 ? 0 : 1;
    }

    @Override
    public void submitHoldOff(int n, int n2, Submitable submitable) {
        submitable.c_trg_pulse(n, n2, (byte)4, this.etvho.toInt(), this.etvho.getValueDivTimeOnStage(), this.etvho.enumPart());
    }

    public void submitCondition(int n, int n2, Submitable submitable) {
        if (SoftwareControl.firmware > 2) {
            int[] nArray = this.trgcondition.getValue();
            submitable.c_trg_pulse(n2, (byte)5, this.condition, this.trgcondition.toInt(), nArray[0], nArray[1]);
            return;
        }
        submitable.c_trg_pulse(n, n2, (byte)5, this.condition, this.trgcondition.toInt(), this.trgcondition.getValueDivTimeOnStage(), this.trgcondition.enumPart());
    }

    public static final boolean isCondition_Equal(int n) {
        return n == 1 || n == 4;
    }
}

