/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model.trigger;

import com.owon.uppersoft.dso.control.TrgLevelCheckHandler;
import com.owon.uppersoft.dso.model.trigger.TrgCheckType;
import com.owon.uppersoft.dso.model.trigger.TrgTypeDefine;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_Holdoff;
import com.owon.uppersoft.dso.model.trigger.helper.PaintChannelTrgLabelContext;
import com.owon.uppersoft.dso.model.trigger.holdoff.HoldoffDelegate;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.trigger.help.EnumNValue;
import com.owon.uppersoft.vds.util.Pref;
import com.owon.uppersoft.vds.util.format.EndianUtil;
import java.awt.Graphics2D;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public abstract class AbsTrigger {
    public static final BigInteger bi100 = BigInteger.valueOf(100L);
    public static final BigInteger bi30 = BigInteger.valueOf(30L);
    public static final BigInteger bi10 = BigInteger.valueOf(10L);
    public final TrgTypeDefine type;
    public ETV_Holdoff etvho = HoldoffDelegate.createETV();

    public AbsTrigger(TrgTypeDefine trgTypeDefine) {
        this.type = trgTypeDefine;
    }

    public String getName() {
        return this.type.name();
    }

    protected void loadETV(String string, Pref pref, EnumNValue enumNValue) {
        enumNValue.fromInt(pref.loadInt(string + this.getName() + "." + enumNValue.itemName()));
    }

    protected void persistETV(String string, Pref pref, EnumNValue enumNValue) {
        pref.persistInt(string + this.getName() + "." + enumNValue.itemName(), enumNValue.toInt());
    }

    protected void addETV(ByteBuffer byteBuffer, EnumNValue enumNValue) {
        int n = enumNValue.toInt();
        byteBuffer.putInt(n);
        this.dbg(enumNValue.itemName() + ":" + n);
    }

    public int applyETV(byte[] byArray, int n, EnumNValue enumNValue) {
        int n2 = EndianUtil.nextIntB(byArray, n);
        enumNValue.fromInt(n2);
        this.dbg(enumNValue.itemName() + ":" + enumNValue);
        return n + 4;
    }

    public int parseETV(byte[] byArray, int n, EnumNValue enumNValue) {
        int n2 = EndianUtil.nextIntB(byArray, n);
        enumNValue.fromInt(n2);
        this.dbg(enumNValue.toString());
        return n + 4;
    }

    private void dbg(String string) {
        System.out.println(string);
    }

    public String toString() {
        return this.getName();
    }

    public void load(String string, Pref pref) {
        this.loadETV(string, pref, this.etvho);
        this.loadProperties(string, pref);
    }

    public void persist(String string, Pref pref) {
        this.persistETV(string, pref, this.etvho);
        this.persistProperties(string, pref);
    }

    protected abstract void loadProperties(String var1, Pref var2);

    protected abstract void persistProperties(String var1, Pref var2);

    public abstract String getIconKey();

    public abstract String getLabelText(ChannelInfo var1);

    public abstract void c_setSweep(int var1, TriggerControl var2);

    public abstract int getSweep();

    public abstract void nextStatus();

    public abstract void paintIcon(Graphics2D var1);

    public abstract boolean handelIncr(int var1, TrgCheckType var2);

    public abstract boolean doCheckTrgLevel(TrgLevelCheckHandler var1);

    public abstract void paintChannelTrgLabel(PaintChannelTrgLabelContext var1);

    public abstract void submitHoldOff(int var1, int var2, Submitable var3);
}

