/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model;

import com.owon.uppersoft.dso.function.FFTView;
import com.owon.uppersoft.dso.function.PFRuleManager;
import com.owon.uppersoft.dso.function.ReferenceWaveControl;
import com.owon.uppersoft.dso.function.measure.MeasureWFSupport;
import com.owon.uppersoft.dso.function.perspective.CompositeWaveForm;
import com.owon.uppersoft.dso.function.perspective.XYView;
import com.owon.uppersoft.dso.function.record.OfflineChannelsInfo;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.machine.aspect.IMultiWFManager;
import com.owon.uppersoft.dso.mode.control.FFTControl;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.WFTimeScopeControl;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.model.trigger.helper.TriggerLevelDelegate;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.ChartScreenSelectModel;
import com.owon.uppersoft.dso.wf.ON_WF_Iterator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.Decorate;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.core.wf.dm.DMInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelsTransportInfo;
import com.owon.uppersoft.vds.data.LocRectangle;
import com.owon.uppersoft.vds.util.LocalizeCenter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.ResourceBundle;

public abstract class WaveFormManager
implements Decorate,
MeasureWFSupport,
Localizable {
    private DataHouse dh;
    private XYView xyv1;
    private FFTView fftv;
    private CompositeWaveForm cwf;
    private ReferenceWaveControl rwc;
    private IMultiWFManager mwfm;
    protected WFTimeScopeControl wftsc;
    protected ControlManager cm;
    private ArrayList<WaveForm> offWfs;
    public static final int RollOverCheckGap = 10;
    public int freqFreshCount;
    private PFRuleManager ruleManager;
    private boolean hideDraw = false;
    private boolean forcefreshFreq = false;
    private WaveFormInfoControl wfic;

    public WaveFormInfoControl getWaveFormInfoControl() {
        return this.wfic;
    }

    public boolean isMath(int n) {
        return n < 0 || n >= this.cm.getSupportChannelsNumber();
    }

    public boolean isMathSupport() {
        return this.cm.getSupportChannelsNumber() > 1;
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.xyv1.localize(resourceBundle);
        this.fftv.localize(resourceBundle);
    }

    public WaveFormManager(DataHouse dataHouse) {
        this.dh = dataHouse;
        this.cm = dataHouse.controlManager;
        this.wfic = this.cm.getWaveFormInfoControl();
        this.wfic.setDataHouse(dataHouse);
        this.retainClosedWaveForms();
        this.xyv1 = new XYView(this, this.cm.displayControl);
        this.fftv = new FFTView(this, this.cm);
        LocalizeCenter localizeCenter = this.cm.getLocalizeCenter();
        localizeCenter.addPrimeTextLocalizable(this);
        this.cwf = new CompositeWaveForm(this, this.cm.mathControl, this.cm.getCoreControl().getVoltageProvider(), this.cm);
        this.rwc = this.cm.rwc;
        this.ruleManager = this.cm.ruleManager;
        this.mwfm = this.createMultiWFManager(this.cm);
        this.wftsc = this.createWFTimeScopeControl();
        this.freqFreshCount = this.cm.computeFreqTimes;
        this.cm.pcs.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("onTimebaseEffect")) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    int n2 = (Integer)propertyChangeEvent.getOldValue();
                    WaveFormManager.this.setWaveFormTimebaseIndex(n, n2);
                }
            }
        });
    }

    protected abstract IMultiWFManager createMultiWFManager(ControlManager var1);

    protected abstract WFTimeScopeControl createWFTimeScopeControl();

    public boolean is3in1On() {
        return this.xyv1.isOn() || this.cm.getFFTControl().isFFTon();
    }

    public void setZeroYLoc(WaveForm waveForm, int n, boolean bl) {
        boolean bl2 = false;
        if (this.dh.isDMLoad()) {
            bl2 = true;
        } else if (this.cm.allowTransformScreenWaveForm_Ready() || this.dh.allowTransformScreenWaveFormVertical()) {
            bl2 = true;
        }
        waveForm.setZeroYLoc(n, bl, bl2);
    }

    public boolean setVoltBaseIndex(WaveForm waveForm, int n) {
        boolean bl = false;
        if (this.dh.isDMLoad()) {
            bl = true;
        } else if (this.cm.allowTransformScreenWaveForm_Ready() || this.dh.allowTransformScreenWaveFormVertical()) {
            bl = true;
        }
        return waveForm.setVoltBaseIndex(n, bl);
    }

    @Override
    public WaveForm getWaveForm(int n) {
        return this.wfic.getWaveForm(n);
    }

    public String getClosedChannelName(int n, int n2) {
        String string = "";
        WaveForm waveForm = this.getWaveForm(n);
        WaveForm waveForm2 = this.getWaveForm(n2);
        if (!waveForm.isOn()) {
            string = string + waveForm.toString();
        }
        if (n != n2 && !waveForm2.isOn()) {
            if (string.length() != 0) {
                string = string + ", ";
            }
            string = string + waveForm2.toString();
        }
        if (string.length() != 0) {
            string = " " + string + " ";
        }
        return string;
    }

    public void retainClosedWaveForms() {
        WaveFormInfoControl waveFormInfoControl = this.cm.getWaveFormInfoControl();
        this.offWfs = waveFormInfoControl.getClosedWaveForms();
    }

    public boolean isNoWFDataFilled(WaveForm waveForm) {
        if (this.cm.isRuntime()) {
            return false;
        }
        return this.offWfs.contains(waveForm);
    }

    public WaveForm getCHX() {
        return this.getWaveForm(this.cm.displayControl.wfx);
    }

    public WaveForm getCHY() {
        return this.getWaveForm(this.cm.displayControl.wfy);
    }

    public WaveForm getM1() {
        return this.getWaveForm(this.cm.mathControl.m1);
    }

    public WaveForm getM2() {
        return this.getWaveForm(this.cm.mathControl.m2);
    }

    public void setMathOperation(int n) {
        this.cm.mathControl.operation = n;
    }

    public int getMathOperation() {
        return this.cm.mathControl.operation;
    }

    public boolean isCHXYSupport() {
        WaveForm waveForm = this.getCHX();
        WaveForm waveForm2 = this.getCHY();
        return waveForm != null && waveForm2 != null && waveForm.isOn() && waveForm2.isOn();
    }

    public boolean isM1M2Support() {
        WaveForm waveForm = this.getM1();
        WaveForm waveForm2 = this.getM2();
        return waveForm != null && waveForm2 != null && waveForm.isOn() && waveForm2.isOn();
    }

    public WaveForm getSelectedWaveForm() {
        return this.wfic.getSelectedWF();
    }

    public boolean setSelectedWaveForm(int n) {
        int n2 = this.wfic.getSelectedwfIdx();
        if (n2 == n) {
            return false;
        }
        this.wfic.setSelectedwfIdx(n);
        this.cm.pcs.firePropertyChange("SelectWF", n2, n);
        return true;
    }

    private boolean checkChannelRoll(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n < n3) {
            n = n3;
            n6 = n3;
            n5 = n3 + 20;
        } else if (n > n4) {
            n = n4;
            n6 = n4 - 20;
            n5 = n4;
        } else {
            n6 = n - 10;
            n5 = n + 10;
        }
        boolean bl = false;
        if (n2 > n6 && n2 < n5) {
            bl = true;
        }
        return bl;
    }

    public int isWaveFormRollOver(ScreenContext screenContext, Rectangle rectangle, int n) {
        int n2;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        if (this.cwf.isOn() && this.checkChannelRoll(n2 = this.cwf.getPos0onChart(screenContext), n, n3, n4)) {
            return Integer.MAX_VALUE;
        }
        ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            ChannelInfo channelInfo = waveForm.wfi.ci;
            int n5 = waveForm.getPos0onChart(screenContext);
            if (!this.checkChannelRoll(n5, n, n3, n4)) continue;
            return channelInfo.getNumber();
        }
        return -1;
    }

    public void addWaveFormsRTXloc(int n, ScreenContext screenContext) {
        if (this.cm.allowTransformScreenWaveForm_Ready()) {
            this.wftsc.addWaveFormsXloc(n);
            this.cwf.receiveNewData(screenContext);
        }
    }

    public void addWaveFormsDMXloc(int n, ScreenContext screenContext) {
        WaveFormInfo[] waveFormInfoArray;
        for (WaveFormInfo waveFormInfo : waveFormInfoArray = this.wfic.getWaveFormInfos()) {
            if (!waveFormInfo.ci.isOn()) continue;
            waveFormInfo.addWaveFormsXloc(n, screenContext);
        }
        this.mwfm.simulateReloadAsDM(screenContext, this.wfic, this.wftsc, this);
    }

    private void setWaveFormTimebaseRTIndex(int n, int n2) {
        ScreenContext screenContext = this.getScreenContext();
        if (this.cm.allowTransformScreenWaveForm_Ready()) {
            this.wftsc.setTimebaseIndex(n, n2);
            this.cwf.receiveNewData(screenContext);
        }
    }

    private ScreenContext getScreenContext() {
        return this.cm.paintContext;
    }

    private void setWaveFormTimebaseDMIndex(int n, int n2) {
        WaveFormInfo[] waveFormInfoArray;
        ScreenContext screenContext = this.getScreenContext();
        for (WaveFormInfo waveFormInfo : waveFormInfoArray = this.wfic.getWaveFormInfos()) {
            if (!waveFormInfo.ci.isOn() || waveFormInfo.getDataLen() <= 0) continue;
            waveFormInfo.setTimebaseIndex(n, n2, screenContext);
        }
        this.mwfm.simulateReloadAsDM(screenContext, this.wfic, this.wftsc, this);
    }

    public void offAllWaveForms() {
        ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            waveForm.wfi.ci.setOn(false);
        }
    }

    public void afterWaveFormsFeed(ScreenContext screenContext) {
        this.cwf.receiveNewData(screenContext);
        this.fftv.receiveNewData();
    }

    public void receiveOfflineData(OfflineChannelsInfo offlineChannelsInfo, ScreenContext screenContext, boolean bl, int n) {
        int n2 = offlineChannelsInfo.screendatalen;
        int n3 = offlineChannelsInfo.slowMove;
        boolean bl2 = offlineChannelsInfo.isPKDetect;
        this.wftsc.loadRT(n2, n3, bl, bl2, false);
        this.mwfm.receiveOfflineData(offlineChannelsInfo, screenContext, this);
    }

    public void receiveOfflineDMData(DMInfo dMInfo, ScreenContext screenContext, BigDecimal bigDecimal, int n) {
        this.mwfm.receiveOfflineDMData(dMInfo, screenContext, bigDecimal, n, this);
    }

    public void receiveRTDMData(DMInfo dMInfo, ScreenContext screenContext, BigDecimal bigDecimal, int n) {
        this.mwfm.receiveRTDMData(dMInfo, screenContext, bigDecimal, n, this);
    }

    public void receiveRTData(ChannelsTransportInfo channelsTransportInfo, ScreenContext screenContext, boolean bl) {
        boolean bl2 = this.cm.isPeakDetectWork();
        FFTControl fFTControl = this.cm.getFFTControl();
        boolean bl3 = fFTControl.isFFTon();
        int n = channelsTransportInfo.screendatalen;
        int n2 = channelsTransportInfo.slowMove;
        this.wftsc.loadRT(n, n2, bl, bl2, bl3);
        boolean bl4 = this.freqFreshCount == this.cm.computeFreqTimes || this.forcefreshFreq;
        this.resetVbmulti();
        this.mwfm.receiveRTData(channelsTransportInfo, screenContext, this, bl4);
        this.ruleManager.receiveData(this, n);
        this.releaseWFIDMLocInfos();
        this.freqFreshCount = this.freqFreshCount <= 0 ? this.cm.computeFreqTimes : --this.freqFreshCount;
    }

    public void releaseWFIDMLocInfos() {
        this.wfic.releaseWFIDMLocInfos();
    }

    public WFTimeScopeControl getWFTimeScopeControl() {
        return this.wftsc;
    }

    public void paintRulePoints(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        this.ruleManager.paintRulePoints(graphics2D, screenContext.isScreenMode_3(), rectangle, this.dh.getGlobalDecorater());
    }

    public void paintPFLabel(Graphics2D graphics2D, ScreenContext screenContext) {
        this.ruleManager.paintPFLabel(graphics2D, screenContext);
    }

    @Override
    public void adjustView(ScreenContext screenContext, Rectangle rectangle) {
        this.rwc.adjustReferenceView(screenContext, rectangle);
        ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            waveForm.adjustView(screenContext, rectangle);
        }
        this.cwf.adjustView(screenContext, rectangle);
        this.ruleManager.adjustView();
    }

    public void hideDraw() {
        this.hideDraw = true;
    }

    public void resumeDraw() {
        this.hideDraw = false;
    }

    public void forceFreshFreq() {
        this.forcefreshFreq = true;
    }

    public void resumeForceFreshFreq() {
        this.forcefreshFreq = false;
    }

    public void setTrgEdgeMiddle() {
        if (!this.cm.getTriggerControl().getTriggerUIInfo().isAuto_trglevel_middle() || !this.cm.getMachine().isTrgEdgeMiddleSupport()) {
            return;
        }
        ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            waveForm.setTrgEdgeMiddle(this.cm.getTriggerControl());
        }
    }

    @Override
    public void paintView(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        if (this.hideDraw) {
            return;
        }
        this.rwc.paitReferenceWaves(graphics2D, screenContext, rectangle);
        FFTControl fFTControl = this.cm.getFFTControl();
        if (fFTControl.isFFTon()) {
            this.getWaveForm(fFTControl.getFFTchl()).paintView(graphics2D, screenContext, rectangle);
        } else {
            int n = this.cm.getWaveFormInfoControl().getSelectedwfIdx();
            WaveForm waveForm = null;
            ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
            while (oN_WF_Iterator.hasNext()) {
                WaveForm waveForm2 = oN_WF_Iterator.next();
                if (waveForm2.getChannelNumber() == n) {
                    waveForm = waveForm2;
                    continue;
                }
                waveForm2.paintView(graphics2D, screenContext, rectangle);
            }
            if (waveForm != null) {
                waveForm.paintView(graphics2D, screenContext, rectangle);
            }
        }
        this.cwf.paintView(graphics2D, screenContext, rectangle);
    }

    public void paintViewWithoutWaveForms(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        this.rwc.paitReferenceWaves(graphics2D, screenContext, rectangle);
        this.cwf.paintView(graphics2D, screenContext, rectangle);
    }

    public int getOnWaveForms() {
        int n = 0;
        ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            oN_WF_Iterator.next();
            ++n;
        }
        return n;
    }

    protected void paintFreq(Graphics2D graphics2D, ScreenContext screenContext) {
        int n = 20;
        int n2 = 520 - this.getOnWaveForms() * 20;
        ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            Color color = waveForm.getColor();
            graphics2D.setColor(color);
            n2 += n;
        }
    }

    public void paintWaveFormInfo(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle, ControlManager controlManager, LocRectangle locRectangle, ChartScreenSelectModel chartScreenSelectModel) {
        if (this.hideDraw) {
            return;
        }
        this.rwc.paitReferenceItems(graphics2D, screenContext, rectangle);
        TriggerLevelDelegate triggerLevelDelegate = controlManager.getCoreControl().getTriggerLevelDelegate();
        triggerLevelDelegate.preparePaintChannelTrgLabelContext(graphics2D, screenContext, locRectangle, chartScreenSelectModel);
        triggerLevelDelegate.paintTrgLabel(controlManager, this);
        int n = chartScreenSelectModel.getScreenSelectWFidx();
        FFTControl fFTControl = controlManager.getFFTControl();
        if (fFTControl.isFFTon()) {
            this.getWaveForm(fFTControl.getFFTchl()).paintItem(graphics2D, screenContext, rectangle, controlManager, false);
        } else {
            if (n >= 0 && n < this.wfic.getLowMachineChannels()) {
                WaveForm waveForm = null;
                ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
                while (oN_WF_Iterator.hasNext()) {
                    WaveForm waveForm2 = oN_WF_Iterator.next();
                    if (waveForm2.getChannelNumber() == n) {
                        waveForm = waveForm2;
                        continue;
                    }
                    waveForm2.paintItem(graphics2D, screenContext, rectangle, controlManager, false);
                }
                this.cwf.paintItem(graphics2D, screenContext, rectangle, controlManager, false);
                if (waveForm != null) {
                    waveForm.paintItem(graphics2D, screenContext, rectangle, controlManager, true);
                }
                return;
            }
            ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
            while (oN_WF_Iterator.hasNext()) {
                WaveForm waveForm = oN_WF_Iterator.next();
                waveForm.paintItem(graphics2D, screenContext, rectangle, controlManager, false);
            }
        }
        this.cwf.paintItem(graphics2D, screenContext, rectangle, controlManager, n == Integer.MAX_VALUE);
    }

    @Override
    public CompositeWaveForm getCompositeWaveForm() {
        return this.cwf;
    }

    public FFTView getFFTView() {
        return this.fftv;
    }

    public DataHouse getDataHouse() {
        return this.dh;
    }

    public int getHorTrgPos(TimeControl timeControl) {
        return this.cm.getTimeControl().getHorizontalTriggerPosition();
    }

    public int getSkipPoints() {
        return this.wftsc.getSkipPoints();
    }

    public void reduceFrame() {
        ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            waveForm.reduceFrame();
        }
    }

    public void resetVbmulti() {
        ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            waveForm.resetVbmulti();
        }
    }

    public void saveFirstLoadPos0() {
        ON_WF_Iterator oN_WF_Iterator = this.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            waveForm.saveFirstLoadPos0();
        }
    }

    @Override
    public ON_WF_Iterator on_wf_Iterator() {
        return this.wfic.on_wf_Iterator();
    }

    public XYView getXYView() {
        return this.xyv1;
    }

    public ReferenceWaveControl getReferenceWaveControl() {
        return this.rwc;
    }

    public void setWaveFormTimebaseIndex(int n, int n2) {
        if (this.dh.isDMLoad()) {
            this.setWaveFormTimebaseDMIndex(n, n2);
        } else {
            this.setWaveFormTimebaseRTIndex(n, n2);
        }
    }
}

