/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model;

import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.ON_WF_Iterator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.calibration.ChannelSets;
import com.owon.uppersoft.vds.core.aspect.base.IOrgan;
import com.owon.uppersoft.vds.core.aspect.control.ISupportChannelsNumber;
import com.owon.uppersoft.vds.core.aspect.control.Pos0_VBChangeInfluence;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.core.comm.effect.IPatchable;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.util.Pref;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class WaveFormInfoControl
implements IPatchable,
IOrgan,
ISupportChannelsNumber {
    private int lowMachineChannels;
    private WaveFormInfo[] wfinfo;
    private boolean[] wfDisplay;
    private int selectedwfIdx = 0;
    private ArrayList<WaveForm> wfs;

    public int getMaxSupportChannelsNumber() {
        return this.wfinfo.length;
    }

    public WaveFormInfoControl(VoltageProvider voltageProvider, int n, Pos0_VBChangeInfluence pos0_VBChangeInfluence) {
        this.wfinfo = new WaveFormInfo[n];
        this.wfDisplay = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.wfinfo[i] = this.createWaveFormInfo(i, voltageProvider, pos0_VBChangeInfluence);
        }
        this.lowMachineChannels = n;
    }

    protected abstract WaveFormInfo createWaveFormInfo(int var1, VoltageProvider var2, Pos0_VBChangeInfluence var3);

    public boolean isSupportDelay1_2() {
        return this.wfinfo[0].ci.isOn() && this.wfinfo[1].ci.isOn();
    }

    public boolean isSupportDelay3_4() {
        return this.wfinfo[2].ci.isOn() && this.wfinfo[3].ci.isOn();
    }

    public void releaseWFIDMLocInfos() {
        int n = this.wfinfo.length;
        for (int i = 0; i < n; ++i) {
            this.wfinfo[i].releaseDM();
        }
    }

    public void releaseWF() {
        int n = 0;
        for (WaveForm waveForm : this.getWFs()) {
            this.wfinfo[n++].releaseDM();
            waveForm.releaseRT();
        }
    }

    public List<WaveForm> getWFs() {
        return this.wfs.subList(0, this.lowMachineChannels);
    }

    public Iterator<WaveForm> getLowMachineWFIterator() {
        return this.getWFs().iterator();
    }

    @Override
    public int getSupportChannelsNumber() {
        return this.getLowMachineChannels();
    }

    public int getLowMachineChannels() {
        return this.lowMachineChannels;
    }

    public void selectOneChannelOn(int n) {
        for (int i = 0; i < this.lowMachineChannels; ++i) {
            this.wfinfo[i].ci.c_setOn(i == n);
        }
    }

    public void storeChannelsDisplaybeforeFFT() {
        for (int i = 0; i < this.lowMachineChannels; ++i) {
            this.wfDisplay[i] = this.wfinfo[i].ci.isOn();
        }
    }

    public void recoverChannelsDisplayfromNonFFT() {
        for (int i = 0; i < this.lowMachineChannels; ++i) {
            this.wfinfo[i].ci.setOnWithoutSync(this.wfDisplay[i]);
        }
    }

    public void preSetChannelsForFFT(int n) {
        for (int i = 0; i < this.lowMachineChannels; ++i) {
            this.wfinfo[i].ci.setOnWithoutSync(i == n);
        }
    }

    public void turnOnAllChannelsWitouSync() {
        for (int i = 0; i < this.lowMachineChannels; ++i) {
            this.wfinfo[i].ci.setOnWithoutSync(true);
        }
    }

    public void turnOnAllChannelsACNotInverse() {
        this.turnOnAllChannelsNotInverse(1);
    }

    public void turnOnAllChannelsNotInverse(int n) {
        for (int i = 0; i < this.lowMachineChannels; ++i) {
            ChannelInfo channelInfo = this.wfinfo[i].ci;
            channelInfo.c_setCoupling(n);
            channelInfo.c_setInverse(false);
            channelInfo.c_setOn(true);
        }
    }

    public void turnOnAllChannelsCouplingNotInverse() {
        for (int i = 0; i < this.lowMachineChannels; ++i) {
            ChannelInfo channelInfo = this.wfinfo[i].ci;
            channelInfo.c_setInverse(false);
            channelInfo.c_setOn(true);
        }
    }

    public void turnChannelsDC(ChannelSets[] channelSetsArray) {
        for (ChannelSets channelSets : channelSetsArray) {
            WaveFormInfo waveFormInfo = this.wfinfo[channelSets.channel];
            if (!waveFormInfo.ci.isOn()) continue;
            waveFormInfo.ci.c_setCoupling(channelSets.coupling);
        }
    }

    public boolean isWFOn(int n) {
        if (n < 0 || n >= this.lowMachineChannels) {
            return false;
        }
        return this.wfinfo[n].ci.isOn();
    }

    public ChannelSets[] getAllChannelSets() {
        ChannelSets[] channelSetsArray = new ChannelSets[this.lowMachineChannels];
        for (int i = 0; i < this.lowMachineChannels; ++i) {
            ChannelSets channelSets;
            WaveFormInfo waveFormInfo = this.wfinfo[i];
            channelSetsArray[i] = channelSets = new ChannelSets();
            channelSets.channel = i;
            channelSets.on = waveFormInfo.ci.isOn();
            if (!channelSets.on) continue;
            channelSets.coupling = waveFormInfo.ci.getCouplingIdx();
            channelSets.inverse = waveFormInfo.ci.isInverse();
            channelSets.vbidx = waveFormInfo.ci.getVoltbaseIndex();
            channelSets.pos0 = waveFormInfo.ci.getPos0();
        }
        return channelSetsArray;
    }

    public void customizeChannelCouplingNInverse(ChannelSets[] channelSetsArray) {
        for (ChannelSets channelSets : channelSetsArray) {
            WaveFormInfo waveFormInfo = this.wfinfo[channelSets.channel];
            waveFormInfo.ci.c_setOn(channelSets.on);
            if (!channelSets.on) continue;
            waveFormInfo.ci.c_setCoupling(channelSets.coupling);
            waveFormInfo.ci.c_setInverse(channelSets.inverse);
            waveFormInfo.ci.c_setZero(channelSets.pos0, true);
            waveFormInfo.ci.c_setVoltage(channelSets.vbidx, null);
        }
    }

    public byte getWaveFormFlag() {
        return (byte)this.getWaveFormFlagTailing(1);
    }

    public int getWaveFormFlagTailing(int n) {
        int n2 = 0;
        int n3 = this.lowMachineChannels;
        for (int i = n3 - 1; i >= 0; --i) {
            n2 = n2 << n | (this.wfinfo[i].ci.isOn() ? 1 : 0);
        }
        return n2;
    }

    public int getWaveFormFlagHeading16bitsL(byte[] byArray, int n, boolean bl, int n2, int n3) {
        int n4 = n;
        int n5 = this.lowMachineChannels;
        for (int i = n5 - 1; i >= 0; --i) {
            int n6 = this.wfinfo[i].ci.isOn() ? 128 : 0;
            byArray[n4] = (byte)(n6 | n2);
            n6 = bl ? 128 : 0;
            byArray[++n4] = (byte)(n6 | n3);
            ++n4;
        }
        return n4;
    }

    public ChannelInfo getWaveFormChannelInfo(int n) {
        return this.wfinfo[n].ci;
    }

    public int getOnWaveFormNumber() {
        int n = 0;
        int n2 = this.lowMachineChannels;
        for (int i = 0; i < n2; ++i) {
            if (!this.wfinfo[i].ci.isOn()) continue;
            ++n;
        }
        return n;
    }

    public ArrayList<WaveForm> getClosedWaveForms() {
        ArrayList<WaveForm> arrayList = new ArrayList<WaveForm>();
        for (int i = 0; i < this.lowMachineChannels; ++i) {
            if (this.isWFOn(i)) continue;
            arrayList.add(this.getWaveForm(i));
        }
        return arrayList;
    }

    public WaveFormInfo getWaveFormInfoForDM() {
        WaveFormInfo waveFormInfo = null;
        for (WaveFormInfo waveFormInfo2 : this.wfinfo) {
            if (!waveFormInfo2.ci.isOn()) continue;
            waveFormInfo = waveFormInfo2;
            break;
        }
        return waveFormInfo;
    }

    public WaveFormInfo getWaveFormInfo(int n) {
        return this.wfinfo[n];
    }

    public WaveFormInfo[] getWaveFormInfos() {
        return this.wfinfo;
    }

    public void load(Pref pref) {
        int n = this.wfinfo.length;
        for (int i = 0; i < n; ++i) {
            this.wfinfo[i].load(pref);
        }
        this.selectedwfIdx = pref.loadInt("selectedwfIdx");
        if (this.selectedwfIdx >= this.lowMachineChannels) {
            this.selectedwfIdx = this.lowMachineChannels - 1;
        }
    }

    public void persist(Pref pref) {
        int n = this.wfinfo.length;
        for (int i = 0; i < n; ++i) {
            this.wfinfo[i].persist(pref);
        }
        pref.persistInt("selectedwfIdx", this.selectedwfIdx);
        pref.persistInt("lowMachineChannels", this.lowMachineChannels);
    }

    @Override
    public void selfSubmit(Submitable submitable) {
        for (int i = 0; i < this.lowMachineChannels; ++i) {
            this.wfinfo[i].ci.c_SyncChannel(submitable);
        }
    }

    public int getSelectedwfIdx() {
        return this.selectedwfIdx;
    }

    public WaveForm getSelectedWF() {
        return this.getWaveForm(this.getSelectedwfIdx());
    }

    public void setSelectedwfIdx(int n) {
        this.selectedwfIdx = n;
    }

    public ON_WF_Iterator on_wf_Iterator() {
        return new ON_WF_Iterator(this.getWFs());
    }

    public WaveForm getWaveForm(int n) {
        if (n < 0 || n >= this.lowMachineChannels) {
            return null;
        }
        return this.wfs.get(n);
    }

    public void setDataHouse(DataHouse dataHouse) {
        int n = this.wfinfo.length;
        this.wfs = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            WaveForm waveForm = this.createWaveForm(dataHouse, this.wfinfo[i]);
            this.wfs.add(waveForm);
        }
    }

    protected abstract WaveForm createWaveForm(DataHouse var1, WaveFormInfo var2);
}

