/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.wf.WFTimeScopeContext;
import com.owon.uppersoft.vds.core.rt.WFDrawRTUtil;
import com.owon.uppersoft.vds.core.wf.rt.ChannelsTransportInfo;
import java.math.BigDecimal;

public abstract class WFTimeScopeControl
implements WFTimeScopeContext {
    private boolean hasZoom;
    private double orggap;
    private double nowgap;
    protected ControlManager cm;
    private int xboff = 0;
    private int orgtbidx;
    private int orgfsl;
    private int skipPoints;
    private boolean PK_Detect;
    private int pk_detect_type = -1;
    private int drawMode = -1;
    private double gap;
    private boolean commonXboff = true;

    public WFTimeScopeControl(ControlManager controlManager) {
        this.cm = controlManager;
    }

    public void setTimebaseIndex(int n, int n2) {
        this.setHasZoom(true);
        BigDecimal[] bigDecimalArray = this.cm.getMachineInfo().bdTIMEBASE;
        BigDecimal bigDecimal = bigDecimalArray[this.orgtbidx];
        BigDecimal bigDecimal2 = bigDecimalArray[n];
        BigDecimal bigDecimal3 = bigDecimalArray[n2];
        BigDecimal bigDecimal4 = bigDecimal2.divide(bigDecimal);
        this.nowgap = BigDecimal.valueOf(this.orggap).divide(bigDecimal4).doubleValue();
        int n3 = 500;
        int n4 = n3 - this.getXboff();
        BigDecimal bigDecimal5 = BigDecimal.valueOf(n4).divide(bigDecimal2.divide(bigDecimal3));
        this.setXboff(n3 - (int)bigDecimal5.doubleValue());
    }

    public void addWaveFormsXloc(int n) {
        this.setXboff(this.getXboff() - n);
    }

    public int computeXoffset(int n, int n2) {
        if (this.isZoom()) {
            return n += this.getXboff() + (int)((double)this.skipPoints * this.nowgap);
        }
        n += this.getXboff();
        return n += this.getSlowMoveOffset(n2);
    }

    public int getSlowMoveOffset(int n) {
        int n2 = 0;
        if (this.skipPoints > 0) {
            switch (n) {
                case 4: {
                    n2 = this.skipPoints >> 2;
                    break;
                }
                case 1: {
                    n2 = this.skipPoints;
                    break;
                }
                case 2: {
                    n2 = this.skipPoints >> 1;
                }
            }
        }
        return n2;
    }

    private void saveOrginalTimebaseStatus(int n) {
        this.orgtbidx = this.cm.getTimeControl().getTimebaseIdx();
        this.orgfsl = n;
        this.setXboff(0);
        this.setHasZoom(false);
        this.orggap = 1000.0 / (double)this.orgfsl;
    }

    private void computeSkipPoints(int n, int n2, boolean bl) {
        this.skipPoints = bl ? n - n2 : 0;
    }

    private void setPKDetect(boolean bl) {
        this.PK_Detect = bl;
    }

    public boolean isPK_Detect() {
        return this.PK_Detect;
    }

    public int getPK_detect_type() {
        return this.pk_detect_type;
    }

    protected void setPK_detect_type(int n) {
        if (this.PK_Detect) {
            this.pk_detect_type = n;
        }
    }

    protected void setPK_detect_typeByDrawMode(boolean bl) {
        if (this.PK_Detect) {
            this.pk_detect_type = this.getPKType(bl, this.drawMode);
        }
    }

    protected abstract int getPKType(boolean var1, int var2);

    public int getSkipPoints() {
        return this.skipPoints;
    }

    private void setSkipPoints(int n) {
        this.skipPoints = n;
    }

    @Override
    public double getZoomGap() {
        return this.nowgap;
    }

    @Override
    public boolean isZoom() {
        return this.hasZoom;
    }

    private void setHasZoom(boolean bl) {
        this.hasZoom = bl;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    private void setDrawModeByScreendatalen(int n) {
        this.drawMode = WFDrawRTUtil.getDrawModeFromLength(n);
    }

    private void setDrawMode(int n) {
        this.drawMode = n;
    }

    public void loadRT(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            this.drawMode = 5;
        } else {
            this.setDrawModeByScreendatalen(n);
        }
        this.saveOrginalTimebaseStatus(n);
        this.computeSkipPoints(n, n2, bl);
        this.setPKDetect(bl2);
        this.setPK_detect_typeByDrawMode(false);
        this.commonXboff = true;
    }

    public void loadDM(ChannelsTransportInfo channelsTransportInfo, boolean bl, int n, double d) {
        this.setSkipPoints(0);
        this.setPKDetect(bl);
        this.setDrawMode(n);
        this.setPK_detect_typeByDrawMode(true);
        this.gap = d;
        this.commonXboff = false;
    }

    public boolean useCommonXboff() {
        return this.commonXboff;
    }

    private void setXboff(int n) {
        this.xboff = n;
    }

    private int getXboff() {
        return this.xboff;
    }

    @Override
    public double getDiluteGap() {
        return this.gap;
    }
}

