/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model;

import com.owon.uppersoft.dso.data.AbsDataSaver;
import com.owon.uppersoft.dso.function.SoftwareControl;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.DMDataInfoTiny;
import com.owon.uppersoft.dso.model.DMInfoTiny;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.source.manager.IDMSourceManager;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.ChannelInverseTranslator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.wf.dm.DMDataInfo;
import com.owon.uppersoft.vds.core.wf.dm.DMInfo;
import com.owon.uppersoft.vds.util.FileUtil;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DataSaverTiny
extends AbsDataSaver {
    private int fileVer = 4;
    private ChannelInverseTranslator cit = new ChannelInverseTranslator();

    @Override
    public DMInfo saveFileM(ControlManager controlManager, File file, PropertyChangeListener propertyChangeListener, IDMSourceManager iDMSourceManager) {
        int n = 77;
        DMInfoTiny dMInfoTiny = new DMInfoTiny(controlManager.getCoreControl().getDeepProvider());
        dMInfoTiny.file = file;
        dMInfoTiny.DMem = (byte)n;
        dMInfoTiny.dmidx = controlManager.getDeepMemoryControl().getDeepIdx();
        dMInfoTiny.chlflag = controlManager.getWaveFormInfoControl().getWaveFormFlag();
        try {
            Object object;
            FileUtil.checkPath(file);
            if (!file.exists()) {
                file.createNewFile();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            try {
                randomAccessFile.setLength(0L);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            SoftwareControl softwareControl = controlManager.getSoftwareControl();
            byte[] byArray = softwareControl.getMachineHeader().getBytes("ASCII");
            randomAccessFile.write(byArray);
            randomAccessFile.writeInt(controlManager.getMachineTypeForSave());
            randomAccessFile.writeInt(this.fileVer);
            randomAccessFile.writeByte(1);
            randomAccessFile.writeByte(0);
            randomAccessFile.writeByte(0);
            randomAccessFile.writeByte(0);
            long l = randomAccessFile.getFilePointer();
            randomAccessFile.writeInt(0);
            randomAccessFile.writeByte(0);
            long l2 = randomAccessFile.getFilePointer();
            randomAccessFile.writeInt(0);
            long l3 = randomAccessFile.getFilePointer();
            dMInfoTiny.raf = randomAccessFile;
            dMInfoTiny.pcl = propertyChangeListener;
            if (dMInfoTiny.chlflag != 0) {
                object = Platform.getDataHouse();
                if (!((DataHouse)object).isPlayRecord()) {
                    iDMSourceManager.acceptDMData(dMInfoTiny);
                }
                if (dMInfoTiny.status == -1) {
                    randomAccessFile.close();
                    return dMInfoTiny;
                }
            }
            long l4 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l2);
            randomAccessFile.writeInt((int)(l4 - l3));
            randomAccessFile.seek(l4);
            randomAccessFile.writeByte(1);
            l2 = randomAccessFile.getFilePointer();
            randomAccessFile.writeInt(0);
            l3 = randomAccessFile.getFilePointer();
            randomAccessFile.writeByte(n);
            randomAccessFile.writeInt(1000);
            randomAccessFile.writeInt(Define.def.AREA_HEIGHT);
            object = dMInfoTiny.channels.iterator();
            dMInfoTiny.channelNum = dMInfoTiny.channels.size();
            WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
            TimeControl timeControl = controlManager.getTimeControl();
            int n2 = timeControl.getTimebaseIdx();
            randomAccessFile.writeInt(n2);
            randomAccessFile.writeInt(timeControl.getHorizontalTriggerPosition());
            randomAccessFile.writeBoolean(controlManager.isPeakDetectWork());
            l4 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l2);
            randomAccessFile.writeInt((int)(l4 - l3));
            randomAccessFile.seek(l4);
            l2 = randomAccessFile.getFilePointer();
            randomAccessFile.writeInt(0);
            l3 = randomAccessFile.getFilePointer();
            while (object.hasNext()) {
                DMDataInfo dMDataInfo = (DMDataInfo)object.next();
                WaveForm waveForm = waveFormManager.getWaveForm(dMDataInfo.chl);
                ChannelInfo channelInfo = waveForm.wfi.ci;
                channelInfo.snapShot2ChannelDataInfo(dMDataInfo, waveForm);
                long l5 = randomAccessFile.getFilePointer();
                randomAccessFile.writeBytes(waveForm.toString());
                long l6 = randomAccessFile.getFilePointer();
                randomAccessFile.writeInt(0);
                randomAccessFile.writeInt(this.cit.getInverseType_DM(channelInfo.isInverse()));
                dMDataInfo.writeRandomAccessFile(randomAccessFile);
                dMInfoTiny.initPos = dMDataInfo.initPos;
                dMInfoTiny.datalen = dMDataInfo.datalen;
                dMInfoTiny.setScreendatalen(dMDataInfo);
                dMInfoTiny.slowMove = dMDataInfo.slowMove;
                randomAccessFile.writeInt(dMDataInfo.filePointer);
                long l7 = randomAccessFile.getFilePointer();
                int n3 = (int)(l7 - l5);
                randomAccessFile.seek(l6);
                randomAccessFile.writeInt(n3);
                randomAccessFile.seek(l7);
            }
            l4 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l2);
            randomAccessFile.writeInt((int)(l4 - l3));
            randomAccessFile.seek(l);
            randomAccessFile.writeInt((int)randomAccessFile.length());
            randomAccessFile.close();
            return dMInfoTiny;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    @Override
    protected DMDataInfo createDMDataInfo() {
        return new DMDataInfoTiny();
    }
}

