/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.model;

import com.owon.uppersoft.dso.function.PersistentDisplay;
import com.owon.uppersoft.dso.function.PersistentPropertyChangeListener;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.WorkBench;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_TrgConditon;
import com.owon.uppersoft.dso.util.ui.LineUtil;
import com.owon.uppersoft.dso.wf.ChartScreenSelectModel;
import com.owon.uppersoft.dso.wf.ON_WF_Iterator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.Decorate;
import com.owon.uppersoft.vds.core.aspect.help.AreaImageHelper;
import com.owon.uppersoft.vds.core.paint.Background;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.data.LocRectangle;
import com.owon.uppersoft.vds.data.Point;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ChartDecorater
implements Decorate,
AreaImageHelper {
    private ControlManager cm;
    private Background bg;
    private WaveFormManager wfm;
    private WorkBench wb;
    private DataHouse dh;
    private TriggerControl tgc;
    private LocRectangle lr = new LocRectangle();
    private Point drawsz = new Point();
    private PersistentDisplay pd;

    public ChartDecorater(ControlManager controlManager, WorkBench workBench, DataHouse dataHouse) {
        this.cm = controlManager;
        this.wb = workBench;
        this.dh = dataHouse;
        this.tgc = controlManager.getTriggerControl();
        this.wfm = dataHouse.getWaveFormManager();
        this.pd = new PersistentDisplay(controlManager.getIRuntime(), this, controlManager.getSupportChannelsNumber(), dataHouse);
        controlManager.pcs.addPropertyChangeListener(new PersistentPropertyChangeListener(controlManager, this.pd));
        this.bg = new Background(){
            private int VpixPerDiv;

            @Override
            public void adjustView(Rectangle rectangle, boolean bl) {
                super.adjustView(rectangle, bl);
                this.VpixPerDiv = bl ? 25 : 50;
                this.setYunitlen(bl ? 5 : 10);
            }

            @Override
            protected void paintLines(Graphics2D graphics2D, Color color) {
                super.paintLines(graphics2D, color);
                int n = this.VpixPerDiv * 2;
                int n2 = this.xcenter - 250;
                int n3 = this.xcenter + 250;
                int n4 = this.ycenter - n;
                int n5 = this.ycenter + n;
                this.stampCross(graphics2D, n2, n4);
                this.stampCross(graphics2D, n3, n4);
                this.stampCross(graphics2D, n2, n5);
                this.stampCross(graphics2D, n3, n5);
            }

            private void stampCross(Graphics2D graphics2D, int n, int n2) {
                graphics2D.drawLine(n - 4, n2, n + 4, n2);
                graphics2D.drawLine(n, n2 - 4, n, n2 + 4);
            }
        };
    }

    @Override
    public void adjustView(ScreenContext screenContext, Rectangle rectangle) {
        Insets insets = screenContext.getChartInsets();
        this.drawsz.x = rectangle.width + insets.left;
        this.drawsz.y = rectangle.height + insets.top;
        this.bg.adjustView(rectangle, screenContext.isScreenMode_3());
        this.wfm.adjustView(screenContext, rectangle);
        this.pd.adjustView(screenContext, rectangle);
    }

    public Background getBackground() {
        return this.bg;
    }

    @Override
    public void paintView(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.scale(DataHouse.xRate, DataHouse.yRate);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Font font = graphics2D.getFont();
        double d = (DataHouse.yRate < 1.0 ? 1.0 : DataHouse.yRate) * 1.2;
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(d / DataHouse.xRate, d / DataHouse.yRate);
        graphics2D.setFont(font.deriveFont(affineTransform2));
        if (this.pd.isUseCanvasBuffer()) {
            this.bg.paintView(graphics2D, screenContext);
            this.wfm.paintRulePoints(graphics2D, screenContext, rectangle);
            this.pd.paintView(graphics2D, this.drawsz);
            this.wfm.paintViewWithoutWaveForms(graphics2D, screenContext, rectangle);
            this.paintMarks(graphics2D, screenContext);
            this.paintLabels(graphics2D, screenContext, rectangle);
        } else {
            this.bg.paintView(graphics2D, screenContext);
            this.wfm.paintRulePoints(graphics2D, screenContext, rectangle);
            this.wfm.paintView(graphics2D, screenContext, rectangle);
            this.paintMarks(graphics2D, screenContext);
            this.paintLabels(graphics2D, screenContext, rectangle);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font);
    }

    protected void paintLabels(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        Insets insets = screenContext.getChartInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = n2;
        int n6 = n + n3;
        int n7 = n2 + n4;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartScreenSelectModel chartScreenSelectModel = this.wb.getMainWindow().getChartChannelSelectModel();
        if (!this.cm.getCoreControl().isRunMode_FFT()) {
            TimeControl timeControl = this.cm.getTimeControl();
            int n8 = timeControl.getHorizontalTriggerPosition();
            int n9 = this.tgc.isSingleTrg() ? this.tgc.getSingleTriggerSet().getChannel() : this.tgc.getAlternateTriggerSet(0).getChannel();
            WaveForm waveForm = this.wfm.getWaveForm(n9);
            graphics2D.setColor(waveForm == null ? Color.WHITE : waveForm.getColor());
            int n10 = n + (n3 >> 1) - n8;
            if (!this.dh.isHorTrgPosFrozen()) {
                LineUtil.paintHorTrg(n10, n5, n, n6, graphics2D);
                LineUtil.paintHorTrgDetail(n10, n5, rectangle, graphics2D, timeControl.getHorizontalTriggerLabel(), chartScreenSelectModel.isOnShowHtpDetail());
                this.paintTrgCondition(graphics2D, rectangle, n10, n5, n, n6);
            }
        }
        this.lr.set(n, n6, n2, n7);
        this.wfm.paintWaveFormInfo(graphics2D, screenContext, rectangle, this.cm, this.lr, chartScreenSelectModel);
        this.wfm.paintPFLabel(graphics2D, screenContext);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void paintTrgCondition(Graphics2D graphics2D, Rectangle rectangle, int n, int n2, int n3, int n4) {
        ChartScreenSelectModel chartScreenSelectModel = this.wb.getMainWindow().getChartChannelSelectModel();
        ON_WF_Iterator oN_WF_Iterator = this.wfm.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            int n5;
            WaveForm waveForm = oN_WF_Iterator.next();
            int n6 = waveForm.getChannelNumber();
            ETV_TrgConditon eTV_TrgConditon = this.tgc.getTrgConditonOrNull(n6);
            if (eTV_TrgConditon == null || (n5 = n - (int)(eTV_TrgConditon.getTime_mS() / this.cm.getTimeControl().getPixelTime_mS())) < n3) continue;
            graphics2D.setColor(waveForm.getColor());
            LineUtil.paintHorTrgWidth(n5, n2, n3, n4, graphics2D);
            if (!chartScreenSelectModel.isOnShowHtcDetail() || chartScreenSelectModel.getScreenSelectWFidx() != n6) continue;
            LineUtil.paintHorTrgDetail(n5, n2, rectangle, graphics2D, eTV_TrgConditon.toString(), true);
        }
    }

    protected void paintMarks(Graphics2D graphics2D, ScreenContext screenContext) {
        Rectangle rectangle = screenContext.getChartRectangle();
        this.cm.mcctr.drawMarkCursor(graphics2D, rectangle);
        this.cm.getZoomAssctr().drawMarks(graphics2D, rectangle);
    }

    public static final void fillBackground(BufferedImage bufferedImage, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(1, 0.0f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
    }

    @Override
    public Point getDrawSize() {
        return this.drawsz;
    }

    @Override
    public void resetARGBBufferImage(BufferedImage bufferedImage) {
        ChartDecorater.fillBackground(bufferedImage, this.drawsz.x, this.drawsz.y);
    }

    @Override
    public BufferedImage createARGBScreenBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.drawsz.x, this.drawsz.y, 2);
        return bufferedImage;
    }

    public PersistentDisplay getPersistentDisplay() {
        return this.pd;
    }

    @Deprecated
    public void fadeThdOn_Off_UI(int n) {
        this.pd.fadeThdOn_Off_UI(n);
    }

    public void rebuffer() {
        if (this.pd.isUseCanvasBuffer() && this.pd.isRuntime()) {
            this.pd.resetPersistBufferImage();
        }
    }
}

