/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.mode.control;

import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.mode.control.TimeControlDelegate;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.vds.core.aspect.base.IOrgan;
import com.owon.uppersoft.vds.core.aspect.control.DeepProvider;
import com.owon.uppersoft.vds.core.aspect.control.FullScreenQuery;
import com.owon.uppersoft.vds.core.aspect.control.ITimeControl;
import com.owon.uppersoft.vds.core.aspect.control.TimeConfProvider;
import com.owon.uppersoft.vds.core.comm.effect.IPatchable;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.machine.MachineInfo;
import com.owon.uppersoft.vds.core.paint.PaintContext;
import com.owon.uppersoft.vds.data.Range;
import com.owon.uppersoft.vds.util.Pref;
import com.owon.uppersoft.vds.util.format.UnitConversionUtil;
import java.math.BigDecimal;

public class TimeControl
implements IOrgan,
IPatchable,
ITimeControl {
    private int timebaseIdx = -1;
    private double horTrgPos = 0.0;
    private int rtfls = 0;
    private Range horTrgRange = new Range(20000000, -20000000);
    private DeepProvider dp;
    private TimeConfProvider tcp;
    private TimeControlDelegate tcd;
    private FullScreenQuery fsq;
    private double pixelTime_mS;
    private int horTrgIdx;
    private String hortrglbl;

    public void setHorTrgPos(double d) {
        this.horTrgPos = d;
    }

    public void resetPersistence() {
        this.tcd.nofiyResetPersistence();
    }

    public double getDBHorizontalTriggerPosition() {
        return this.horTrgPos;
    }

    @Override
    public int getHorizontalTriggerPosition() {
        return (int)this.horTrgPos;
    }

    public int getRTfullScreenNumber() {
        return this.rtfls;
    }

    public void setRTfullScreenNumber(int n) {
        this.rtfls = n;
    }

    public Range getHorTrgRange() {
        return this.horTrgRange;
    }

    private void setHorTrgRange(Range range) {
        this.horTrgRange.left = range.left;
        this.horTrgRange.right = range.right;
    }

    public int restrictHorTrgPos() {
        int n = this.getHorizontalTriggerPosition();
        int n2 = this.restrictHorTrgPos(n);
        int n3 = n2 - n;
        if (n3 != 0) {
            this.setHorTrgPos(n2);
            this.resetPersistence();
            this.dosubmit();
        }
        return n2;
    }

    private int restrictHorTrgPos(int n) {
        return n;
    }

    public TimeConfProvider getTimeConfProvider() {
        return this.tcp;
    }

    public TimeControl(MachineInfo machineInfo, TimeConfProvider timeConfProvider, TimeControlDelegate timeControlDelegate, DeepProvider deepProvider, FullScreenQuery fullScreenQuery) {
        this.dp = deepProvider;
        this.tcp = timeConfProvider;
        this.tcd = timeControlDelegate;
        this.fsq = fullScreenQuery;
    }

    public void load(Pref pref) {
        int n = pref.loadInt("Timebase.index");
        if (n < 0 || n >= this.tcp.getTimebaseNumber()) {
            n = 0;
        }
        this.setTimebaseIndexValue(n);
        this.tcd.notifyInitSlowMove(this.tcp.isOnSlowMoveTimebase(n));
        this.updatePixel_mS_Sample_mS();
        int n2 = pref.loadInt("HorTrgPos");
        this.setHorTrgPos(n2);
    }

    public void persist(Pref pref) {
        pref.persistInt("Timebase.index", this.getTimebaseIdx());
        int n = this.getHorizontalTriggerPosition();
        pref.persistInt("HorTrgPos", n);
    }

    public void internalTimebaseIndex(int n) {
        this.internalTimebaseIndex(n, true);
    }

    public void internalTimebaseIndex(int n, boolean bl) {
        int n2 = this.getTimebaseIdx();
        this.setTimebaseIndexValue(n);
        this.updateTimebase();
        this.tcd.onTimebaseChange(n2, n, bl);
    }

    public void setTimebaseIndexValue(int n) {
        this.timebaseIdx = n;
    }

    public void updateTimebase() {
        this.updatePixel_mS_Sample_mS();
        this.tcd.notifyUpdateCurrentSampleRate();
    }

    private void updatePixel_mS_Sample_mS() {
        double d = this.getBDTimebase().doubleValue() * 1000.0;
        this.pixelTime_mS = d / 50.0;
    }

    @Override
    public int getTimebaseIdx() {
        return this.timebaseIdx;
    }

    @Override
    public double getPixelTime_mS() {
        return this.pixelTime_mS;
    }

    public boolean isOnSlowMoveTimebase() {
        return this.tcp.isOnSlowMoveTimebase(this.getTimebaseIdx());
    }

    public String getTimebaseLabel() {
        return this.tcp.getTimebaseLabel(this.getTimebaseIdx());
    }

    public BigDecimal getBDTimebase() {
        return this.tcp.getBDTimebase(this.getTimebaseIdx());
    }

    public int getValidTimebaseIndex(int n) {
        int n2 = n;
        if (n < 0) {
            n2 = 0;
        }
        if (n >= this.tcp.getTimebaseNumber()) {
            n2 = this.tcp.getTimebaseNumber() - 1;
        }
        return n2 == this.getTimebaseIdx() ? -1 : n2;
    }

    public void c_setTimebaseIdx(int n, boolean bl) {
        int n2 = this.getValidTimebaseIndex(n);
        if (n2 < 0) {
            return;
        }
        n = n2;
        int n3 = this.getTimebaseIdx();
        this.internalTimebaseIndex(n, bl);
        this.tcd.notifyUpdateHorTrgPosRange();
        double d = this.getDBHorizontalTriggerPosition();
        double d2 = BigDecimal.valueOf(d).divide(this.tcp.ratio(this.getTimebaseIdx(), n3)).doubleValue();
        this.setHorTrgPos(d2);
        this.restrictHorTrgPos();
        this.dosubmit();
        this.tcd.onHorTrgPosChangedByTimebase(n, this.getHorizontalTriggerPosition());
    }

    public void offline_setTimeBaseIdx(int n) {
        this.internalTimebaseIndex(n);
        this.tcd.notifyUpdateHorTrgPosRange();
        this.restrictHorTrgPos();
    }

    @Override
    public void c_setTimebase_HorTrgPos(int n, int n2) {
        if (this.getTimebaseIdx() != n) {
            this.internalTimebaseIndex(n);
        }
        this.tcd.notifyUpdateHorTrgPosRange();
        n2 = this.restrictHorTrgPos(n2);
        this.setHorTrgPos(n2);
        this.resetPersistence();
        this.dosubmit();
        Platform.getMainWindow().update_HorTrg();
    }

    public String getHorizontalTriggerLabel() {
        this.hortrglbl = this.computeHorizontalTriggerLabel();
        return this.hortrglbl;
    }

    public void recomputeHorizontalTriggerLabel() {
        this.hortrglbl = this.computeHorizontalTriggerLabel();
    }

    private String computeHorizontalTriggerLabel() {
        int n = this.getHorizontalTriggerPosition();
        return this.getHTPLabel(this.getTimebaseIdx(), n);
    }

    @Override
    public String getHTPLabel(int n, int n2) {
        BigDecimal bigDecimal = this.tcp.getBDTimebase(n);
        double d = bigDecimal.divide(BigDecimal.valueOf(50L)).multiply(BigDecimal.valueOf(n2)).multiply(BigDecimal.valueOf(1000L)).doubleValue();
        return UnitConversionUtil.getSimplifiedTimebaseLabel_mS(d);
    }

    public double getSlowTriggerTime() {
        return (this.horTrgPos + 500.0 - 3.0) * this.pixelTime_mS;
    }

    public double getSlowTriggerPos() {
        return this.rtfls - this.horTrgIdx;
    }

    private void setHorTrgIdx(int n) {
        this.horTrgIdx = n;
    }

    public int getHorTrgIdx() {
        return this.horTrgIdx;
    }

    public void computeHorTrgIdx(int n, int n2) {
        double d = (double)this.rtfls / 1000.0;
        double d2 = (double)this.dp.getLength(n) / d;
        double d3 = (d2 / 2.0 - (double)n2) * d;
        int n3 = (int)Math.round(d3);
        this.setHorTrgIdx(n3);
    }

    public void computeDMHorTrgIdx(int n, int n2) {
        int n3 = this.getHorizontalTriggerPosition();
        double d = (double)n2 / 1000.0;
        int n4 = n + (int)((double)(500 - n3) * d);
        this.setHorTrgIdx(n4);
    }

    public void computeHorTrgRange(int n, int n2) {
        Range range = new Range();
        int n3 = this.computeRTFullScreen(n, n2);
        if (n3 == 0) {
            range.left = Integer.MAX_VALUE;
            range.right = Integer.MIN_VALUE;
        } else {
            double d = (double)n3 / 1000.0;
            range.left = (int)(5.0E7 / d);
            range.right = -((int)((double)(this.dp.getLength(n) >> 1) / d));
        }
        this.setHorTrgRange(range);
    }

    private int computeRTFullScreen(int n, int n2) {
        int n3 = n2 < 0 ? 0 : this.fsq.getFullScreen(n2, n, this.getTimebaseIdx());
        this.setRTfullScreenNumber(n3);
        return n3;
    }

    @Override
    public void c_setHorizontalTriggerPosition(int n) {
        this.c_setHorizontalTriggerPosition(n, true);
    }

    public void c_addHorizontalTriggerPosition(int n) {
        this.c_addHorizontalTriggerPosition(n, true);
    }

    public void c_addHorizontalTriggerPosition(int n, boolean bl) {
        int n2 = this.getHorizontalTriggerPosition();
        this.c_setHorizontalTriggerPosition(n2 + n, bl);
    }

    public void c_setHorizontalTriggerPosition(int n, boolean bl) {
        DataHouse dataHouse = Platform.getDataHouse();
        MainWindow mainWindow = dataHouse.getMainWindow();
        PaintContext paintContext = mainWindow.getChartScreen().getPaintContext();
        WaveFormManager waveFormManager = dataHouse.getWaveFormManager();
        int n2 = this.getHorizontalTriggerPosition();
        int n3 = n - n2;
        n3 = n - n2;
        this.setHorTrgPos(n);
        this.resetPersistence();
        if (bl) {
            Submitable submitable = SubmitorFactory.reInit();
            submitable.recommendOptimize();
            submitable.c_htp(this.getHorizontalTriggerPosition());
            submitable.apply();
        }
        this.hortrglbl = this.computeHorizontalTriggerLabel();
        if (dataHouse.isDMLoad()) {
            waveFormManager.addWaveFormsDMXloc(n3, paintContext);
        } else {
            waveFormManager.addWaveFormsRTXloc(n3, paintContext);
        }
        mainWindow.update_HorTrg();
    }

    @Override
    public void selfSubmit(Submitable submitable) {
        submitable.c_tb_htp(this.getTimebaseIdx(), this.getHorizontalTriggerPosition());
    }

    public void applyTB_DM(int n, int n2) {
        this.hortrglbl = this.computeHorizontalTriggerLabel();
        this.computeHorTrgRange(n, n2);
    }

    public void dosubmit() {
        Submitable submitable = SubmitorFactory.reInit();
        submitable.recommendOptimize();
        submitable.c_tb_htp(this.getTimebaseIdx(), this.getHorizontalTriggerPosition());
        submitable.applyThen(this.tcd.getResetPersistenceRunnable());
    }

    public void setShouldEnableTrgByJudgeIsSlowMove() {
        this.tcd.notifyInitSlowMove(this.tcp.isOnSlowMoveTimebase(this.getTimebaseIdx()));
    }
}

