/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.mode.control;

import com.owon.uppersoft.dso.data.LObject;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.vds.core.aspect.base.IOrgan;
import com.owon.uppersoft.vds.core.comm.effect.IPatchable;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import com.owon.uppersoft.vds.util.Pref;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;

public class SysControl
implements IOrgan,
IPatchable {
    public static final int SYNOUT_PF = 2;
    public static final int SYNOUT_TrgOut = 1;
    public static final int SYNOUT_TrgIn = 0;
    public static final List<LObject> syncs = new LinkedList<LObject>();
    public byte[] link_ip_address = new byte[]{-64, -88, 1, 72};
    public int link_port = 3000;
    public byte[] ipaddress = new byte[]{-64, -88, 1, 72};
    public byte[] smaddress = new byte[]{-1, -1, -1, 0};
    public byte[] gwaddress = new byte[]{-64, -88, 1, 1};
    private byte[] macaddress = new byte[6];
    public int port = 3000;
    private int sync_output = 0;
    public final boolean netOn = true;

    public void load(Pref pref, boolean bl) {
        if (bl) {
            this.link_ip_address = pref.loadBytes("NetWork.linkIP", this.link_ip_address.length);
            this.link_port = pref.loadInt("NetWork.linkPort");
            this.ipaddress = pref.loadBytes("NetWork.setIP", this.ipaddress.length);
            this.smaddress = pref.loadBytes("NetWork.setSubnetmask", this.smaddress.length);
            this.gwaddress = pref.loadBytes("NetWork.setGateway", this.gwaddress.length);
            this.port = pref.loadInt("NetWork.setPort");
            this.macaddress = pref.loadBytes("NetWork.setMac", this.macaddress.length);
        }
        this.setSyncOutput(pref.loadInt("NetWork.Sync_out"));
        if (this.getSyncOutput() == 0) {
            this.setSyncOutput(1);
        }
    }

    public void persist(Pref pref) {
        pref.persistBytes("NetWork.linkIP", this.link_ip_address);
        pref.persistInt("NetWork.linkPort", this.link_port);
        pref.persistBytes("NetWork.setIP", this.ipaddress);
        pref.persistBytes("NetWork.setSubnetmask", this.smaddress);
        pref.persistBytes("NetWork.setGateway", this.gwaddress);
        pref.persistInt("NetWork.setPort", this.port);
        pref.persistBytes("NetWork.setMac", this.macaddress);
        pref.persistInt("NetWork.Sync_out", this.getSyncOutput());
    }

    @Override
    public void selfSubmit(Submitable submitable) {
        submitable.c_sync_output(this.getSyncOutput());
    }

    public void c_network() {
        Submitable submitable = SubmitorFactory.reInit();
        submitable.c_network(true, this.ipaddress, this.port, this.gwaddress, this.smaddress, this.macaddress);
        submitable.apply();
    }

    public void c_setSyncOut(int n) {
        this.setSyncOutput(n);
        Submitable submitable = SubmitorFactory.reInit();
        submitable.c_sync_output(n);
        submitable.apply();
    }

    public void setSyncOutput(int n) {
        this.sync_output = n;
    }

    public int getSyncOutput() {
        return this.sync_output;
    }

    public String getIP() {
        return this.getIP(this.ipaddress);
    }

    public boolean setIP(String string) {
        return this.c_setIP(string, this.ipaddress);
    }

    public String getGATeway() {
        return this.getIP(this.gwaddress);
    }

    public boolean setGATeway(String string) {
        return this.c_setIP(string, this.gwaddress);
    }

    public String getSMASk() {
        return this.getIP(this.smaddress);
    }

    public boolean setSMASk(String string) {
        return this.c_setIP(string, this.smaddress);
    }

    private String getIP(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("");
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            String string = Integer.toString(byArray[i] & 0xFF);
            stringBuilder.append(string);
            if (i >= n - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    private boolean c_setIP(String string, byte[] byArray) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[i]);
            }
            catch (Exception exception) {
                return false;
            }
            byArray[i] = (byte)(n & 0xFF);
        }
        this.c_network();
        return true;
    }

    public String getMac() {
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < this.macaddress.length; ++i) {
            String string = Integer.toHexString(this.macaddress[i] & 0xFF);
            if (string.length() < 2) {
                stringBuilder.append("0");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public final void saveMac(String string) {
        if (!this.isMacvalid(string)) {
            return;
        }
        byte[] byArray = this.macaddress;
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = i << 1;
            String string2 = string.substring(n2, n2 + 2);
            try {
                n = Integer.parseInt(string2, 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
            byArray[i] = (byte)n;
        }
    }

    public final boolean isMacvalid(String string) {
        ResourceBundle resourceBundle = I18nProvider.bundle();
        if (string.length() != 12) {
            String string2 = resourceBundle.getString("M.Utility.MachineSetting.Unfit");
            new FadeIOShell().prompt(string2, Platform.getMainWindow().getFrame());
            return false;
        }
        string = string.toUpperCase();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue;
            String string3 = resourceBundle.getString("M.Utility.MachineSetting.Invalid");
            new FadeIOShell().prompt(string3, Platform.getMainWindow().getFrame());
            return false;
        }
        return true;
    }

    static {
        syncs.add(new LObject("M.Utility.SYNO.TrgIn"));
        syncs.add(new LObject("M.Utility.SYNO.TrgOut"));
        syncs.add(new LObject("M.Utility.SYNO.PF"));
    }
}

