/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.mode.control;

import com.owon.uppersoft.dso.data.LObject;
import com.owon.uppersoft.dso.mode.control.ISampleControl;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.vds.core.aspect.base.IOrgan;
import com.owon.uppersoft.vds.core.comm.effect.IPatchable;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.data.MinMax;
import com.owon.uppersoft.vds.util.Pref;

public class SampleControl
implements IPatchable,
IOrgan,
ISampleControl {
    public static final LObject[] SamplingMode = new LObject[]{new LObject("M.Sample.Sampling"), new LObject("M.Sample.PKdetect"), new LObject("M.Sample.Average")};
    public final String[] SAMPleMode = new String[]{"SAMPle", "PEAK", "AVERage"};
    public static int MinAverageSampleTimes = 1;
    public static int MaxAverageSampleTimes = 128;
    public boolean avgon = false;
    private int avgTimes = 1;
    private int modelIdx = 0;
    public static int Sample_Sampling = 0;
    public static int Sample_PKDetect = 1;
    public static int Sample_Average = 2;

    @Override
    public MinMax getAvgTimesRange() {
        return new MinMax(MinAverageSampleTimes, MaxAverageSampleTimes);
    }

    public void load(Pref pref) {
        this.modelIdx = pref.loadInt("Sample.mode");
        this.avgon = this.modelIdx == 2;
        this.c_setAvgTimes(pref.loadInt("Sample.avgTimes"));
    }

    public void persist(Pref pref) {
        pref.persistInt("Sample.avgTimes", this.avgTimes);
        pref.persistInt("Sample.mode", this.modelIdx);
    }

    public boolean isPeakDetect() {
        return this.getModelIdx() == 1;
    }

    @Override
    public int getModelIdx() {
        return this.modelIdx;
    }

    public void setModelIdx(int n) {
        this.modelIdx = n;
        this.avgon = n == 2;
    }

    @Override
    public void c_setModelIdx(int n) {
        this.modelIdx = n;
        this.avgon = n == 2;
        Submitable submitable = SubmitorFactory.reInit();
        submitable.c_sample(this.modelIdx);
        submitable.apply();
    }

    @Override
    public int getAvgTimes() {
        return this.avgTimes;
    }

    @Override
    public void c_setAvgTimes(int n) {
        this.avgTimes = n;
        if (this.avgTimes > MaxAverageSampleTimes) {
            this.avgTimes = MaxAverageSampleTimes;
        } else if (this.avgTimes < MinAverageSampleTimes) {
            this.avgTimes = MinAverageSampleTimes;
        }
    }

    @Override
    public void selfSubmit(Submitable submitable) {
        submitable.c_sample(this.modelIdx);
    }

    public int getSAMPleModeIdx(String string) {
        for (int i = 0; i < this.SAMPleMode.length; ++i) {
            if (!string.equalsIgnoreCase(this.SAMPleMode[i])) continue;
            return i;
        }
        return -1;
    }
}

