/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.mode.control;

import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.base.IOrgan;
import com.owon.uppersoft.vds.core.aspect.control.FFTDelegate;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.core.comm.effect.IPatchable;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.util.Pref;
import java.awt.Color;
import java.math.BigDecimal;

public class FFTControl
implements IOrgan,
IPatchable {
    public ChannelInfo.Volt[] VOLTAGEs;
    public String[] dBPerDiv;
    private WaveFormManager wfm;
    private FFTDelegate cc;
    private VoltageProvider vp;
    public Color color;
    public static final String[] format = new String[]{"Vrms", "dBV"};
    public static final String[] scale = new String[]{"X1", "X2", "X5", "X10"};
    public static final int[] SCALES_VALUE = new int[]{1, 2, 5, 10};
    public static final int[] dBValuePerDiv = new int[]{20, 10, 5, 2, 1};
    public int fftvaluetype;
    public int fftscale;
    private int fftchl;
    private int fftwnd;
    private boolean ffton;
    private static final BigDecimal VALUE_OF_20 = BigDecimal.valueOf(20L);

    public FFTControl(FFTDelegate fFTDelegate, VoltageProvider voltageProvider) {
        this.cc = fFTDelegate;
        int n = dBValuePerDiv.length;
        this.dBPerDiv = new String[n];
        for (int i = 0; i < n; ++i) {
            this.dBPerDiv[i] = dBValuePerDiv[i] + "dBV";
        }
        this.vp = voltageProvider;
    }

    public void load(Pref pref, int n) {
        this.fftchl = pref.loadInt("Math.fftchl");
        if (this.fftchl >= n) {
            this.fftchl = n - 1;
        }
        this.fftvaluetype = pref.loadInt("Math.fftvaluetype");
        this.setFFTwnd(pref.loadInt("Math.fftwnd"));
        this.fftscale = pref.loadInt("Math.fftscale");
        this.fftscale = 0;
        this.ffton = pref.loadBoolean("Math.ffton");
        this.ffton = false;
        if (this.ffton) {
            this.cc.preSetChannelsForFFT(this.fftchl);
        }
        this.color = pref.loadColor("Math.fftrgb", Color.WHITE);
    }

    public void persist(Pref pref) {
        pref.persistInt("Math.fftchl", this.fftchl);
        pref.persistInt("Math.fftvaluetype", this.fftvaluetype);
        pref.persistInt("Math.fftwnd", this.getFFTwnd());
        pref.persistInt("Math.fftscale", this.fftscale);
        pref.persistBoolean("Math.ffton", this.ffton);
        pref.persistColor("Math.fftrgb", this.color);
    }

    public void c_setFFTchl(int n) {
        this.fftchl = n;
        this.VOLTAGEs = this.getWaveForm().wfi.ci.getVoltageLabels();
        this.cc.preSetChannelsForFFT(n);
        this.wfm.getFFTView().updateYScaleRate();
        Submitable submitable = SubmitorFactory.reInit();
        submitable.c_fft(this.ffton, n);
        submitable.apply();
    }

    public void setWaveFormManager(WaveFormManager waveFormManager) {
        this.wfm = waveFormManager;
        this.VOLTAGEs = this.getWaveForm().wfi.ci.getVoltageLabels();
    }

    public int getFFTchl() {
        return this.fftchl;
    }

    public WaveForm getWaveForm() {
        return this.wfm.getWaveForm(this.fftchl);
    }

    public int getFFTwnd() {
        return this.fftwnd;
    }

    public void setFFTwnd(int n) {
        this.fftwnd = n;
    }

    public String getFORMat() {
        return format[this.fftvaluetype];
    }

    public void c_setFFTon(boolean bl) {
        if (this.ffton == bl) {
            return;
        }
        this.ffton = bl;
        this.wfm.getFFTView().updateYScaleRate();
        this.cc.ontFFTSwitch(bl, this.fftchl);
    }

    public void setFFTTimebaseIndex(int n) {
        Platform.getMainWindow().getToolPane().getDetailPane().changeFFTTimeBase(n);
    }

    public int getFFTTimebaseIndex() {
        return this.cc.getFFTTimebaseIdx();
    }

    public BigDecimal getFFTTimebaseBD() {
        return this.cc.getBDFFTTimeBases();
    }

    public BigDecimal getFFTSampleRateBD() {
        BigDecimal bigDecimal = this.getFFTTimebaseBD();
        return bigDecimal.multiply(VALUE_OF_20);
    }

    public boolean isFFTon() {
        return this.ffton;
    }

    @Override
    public void selfSubmit(Submitable submitable) {
        submitable.c_fft(this.ffton, this.fftchl);
    }
}

