/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.mode.control;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.vds.core.aspect.base.IOrgan;
import com.owon.uppersoft.vds.core.aspect.control.DeepProvider;
import com.owon.uppersoft.vds.core.comm.effect.IPatchable;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.util.Pref;

public class DeepMemoryControl
implements IPatchable,
IOrgan {
    private int deepIdx = 0;
    private int fpga_deepIdx = 0;
    private DeepProvider dp;
    public static final int XYModeSupportOnly1DeepMemoryIndex = 0;

    public DeepMemoryControl(DeepProvider deepProvider) {
        this.dp = deepProvider;
    }

    public void load(Pref pref) {
        int n = pref.loadInt("DeepMemory");
        if (n < 0 || n >= this.dp.getDeepNumber()) {
            n = 0;
        }
        this.deepIdx = n;
    }

    public void persist(Pref pref) {
        pref.persistInt("DeepMemory", this.deepIdx);
    }

    public int getDeepIdx() {
        return this.deepIdx;
    }

    public int restrictDMidx(int n) {
        int n2 = this.dp.getDeepNumber();
        if (n < 0) {
            n = 0;
        } else if (n >= n2) {
            n = n2 - 1;
        }
        return n;
    }

    public int getDeepDataLen() {
        return this.dp.getLength(this.deepIdx);
    }

    public String getDeepLabel() {
        return this.dp.getLabel(this.deepIdx);
    }

    public int getC_DeepIdx() {
        return this.fpga_deepIdx;
    }

    public void applyDeepIdx(int n) {
        this.deepIdx = n;
    }

    public void applyFPGADeepIdx() {
        this.fpga_deepIdx = this.deepIdx;
    }

    public void setDeepIdx(int n) {
        if (this.deepIdx == n || n < 0) {
            return;
        }
        this.deepIdx = n;
        ControlManager controlManager = Platform.getDataHouse().controlManager;
        controlManager.getCoreControl().updateCurrentSampleRate();
        controlManager.getCoreControl().updateHorTrgPosRange();
        controlManager.getTimeControl().restrictHorTrgPos();
    }

    public void c_setDeepIdx(int n) {
        this.setDeepIdx(n);
        Submitable submitable = SubmitorFactory.reInit();
        submitable.c_dm(n);
        submitable.apply();
    }

    @Override
    public void selfSubmit(Submitable submitable) {
        submitable.c_dm(this.deepIdx);
    }

    public boolean restrictDeepMemory() {
        boolean bl = DeepMemoryControl.restrictShouldChange(this.deepIdx);
        if (bl) {
            this.c_setDeepIdx(0);
        }
        return bl;
    }

    public static final boolean restrictShouldChange(int n) {
        return n != 0;
    }
}

