/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.global;

import com.owon.uppersoft.dso.global.ConfigFactoryTiny;
import com.owon.uppersoft.dso.global.ControlApps;
import com.owon.uppersoft.dso.global.ControlAppsTiny;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.ControlManagerTiny;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.CoreControlTiny;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.global.WorkBench;
import com.owon.uppersoft.dso.machine.aspect.IMultiReceiver;
import com.owon.uppersoft.dso.machine.aspect.IMultiWFManager;
import com.owon.uppersoft.dso.model.WFTimeScopeControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.ToolPane;
import com.owon.uppersoft.dso.view.sub.ButtonPane;
import com.owon.uppersoft.dso.wf.common.MultiReceiver;
import com.owon.uppersoft.dso.wf.common.MultiWFManager;
import com.owon.uppersoft.vds.core.pref.Config;
import com.owon.uppersoft.vds.machine.PrincipleTiny;
import com.owon.uppersoft.vds.machine.TinyMachine;
import com.owon.uppersoft.vds.ui.resource.FontCenter;
import com.owon.uppersoft.vds.util.Pref;
import com.owon.uppersoft.vds.util.ui.UIUtil;
import com.owon.vds.tiny.firm.pref.model.Register;
import com.owon.vds.tiny.tune.TinyTuneFunction;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class WorkBenchTiny
implements WorkBench {
    protected MainWindow mw;
    protected DataHouse dh;
    protected ControlApps ca;
    private Thread ui;
    protected ControlManager ctrlMgr;
    private File confIni = this.getConfigInIFile();
    private CoreControl cc;
    public static final String SCOPEINFOR = "/com/owon/uppersoft/dso/pref/scopeInfo.ini";
    public static final String sp = "/com/owon/uppersoft/dso/pref/default.ini";
    public static String CONFIG_DIR = Platform.DATA_DIR;
    public static String PREFERENCES = "preferences.ini";
    public static String PREFERENCES_DEFAULT = "preferences-default.ini";

    @Override
    public void join() {
        try {
            this.ui.join();
            System.out.println("out_ui.join");
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public ControlApps getControlApps() {
        return this.ca;
    }

    @Override
    public MainWindow getMainWindow() {
        return this.mw;
    }

    @Override
    public DataHouse getDataHouse() {
        return this.dh;
    }

    @Override
    public ControlManager getControlManager() {
        return this.ctrlMgr;
    }

    public WorkBenchTiny() {
        Config config = ConfigFactoryTiny.createConfig(this.confIni, this.getDefaultInIStream(), this.getStaticPrefStream());
        Pref pref = config.getSessionProperties();
        String string = pref.getProperty("productParam", "VDS3102ONE").toUpperCase();
        final PrincipleTiny principleTiny = new PrincipleTiny(string);
        this.cc = new CoreControlTiny(config, principleTiny);
        this.ctrlMgr = new ControlManagerTiny(config, principleTiny, this.cc);
        this.dh = new DataHouse(this.ctrlMgr, this){

            @Override
            public IMultiReceiver createMultiReceiver(ControlManager controlManager, WaveFormManager waveFormManager) {
                return new MultiReceiver(controlManager, waveFormManager);
            }

            @Override
            protected WaveFormManager createWaveFormManager() {
                return new WaveFormManager(this){

                    @Override
                    public IMultiWFManager createMultiWFManager(ControlManager controlManager) {
                        return new MultiWFManager(controlManager);
                    }

                    @Override
                    protected WFTimeScopeControl createWFTimeScopeControl() {
                        return new WFTimeScopeControl(this.cm){

                            @Override
                            protected int getPKType(boolean bl, int n) {
                                return ((TinyMachine)this.cm.getMachine()).getPKType(n);
                            }
                        };
                    }
                };
            }
        };
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    WorkBenchTiny.this.showMainFrm(principleTiny);
                    WorkBenchTiny.this.ui = Thread.currentThread();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        this.ca = new ControlAppsTiny(this.dh, this.mw);
        try {
            Pref pref2 = new Pref();
            pref2.load(new FileInputStream(this.getDefaultInIFile()));
            config.setSessionProperties(pref2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Pref pref3 = config.getFactoryProperties();
            config.setSessionProperties(pref3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void showMainFrm(final PrincipleTiny principleTiny) {
        UIUtil.modifyui();
        FontCenter.updateFont();
        this.mw = new MainWindow(this, this.dh){

            @Override
            protected ToolPane createToolPane(Dimension dimension, ControlManager controlManager) {
                return new ToolPane(this, dimension, controlManager){

                    @Override
                    protected ButtonPane createButtonPane(MainWindow mainWindow, ControlManager controlManager) {
                        return new ButtonPane(mainWindow, controlManager, WorkBenchTiny.this.dh){

                            @Override
                            public void quickPatch() {
                                TinyTuneFunction tinyTuneFunction = principleTiny.getTuneFunction();
                                Register register = tinyTuneFunction.getTuneModel().getRegister();
                                register.enableLanguage("pt_BR");
                                tinyTuneFunction.getTinyTuneDelegate().burnAll();
                                String string = "Patch Done! Notice: this software is only for PATCH VDS1022 but not an application of software for VDS";
                                String string2 = "";
                                JOptionPane.showMessageDialog(Platform.getMainWindow().getWindow(), string, string2, 1);
                            }
                        };
                    }
                };
            }
        };
        this.mw.show();
    }

    @Override
    public void exit() {
        try {
            this.ctrlMgr.getConfig().getSessionProperties().store(new FileOutputStream(this.getDefaultInIFile()), null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.ctrlMgr.onRelease(this.confIni);
        this.ca.onExit();
    }

    public InputStream getDefaultInIStream() {
        return WorkBenchTiny.class.getResourceAsStream(SCOPEINFOR);
    }

    public InputStream getStaticPrefStream() {
        return WorkBenchTiny.class.getResourceAsStream(sp);
    }

    public File getConfigInIFile() {
        File file = new File(CONFIG_DIR, PREFERENCES);
        return file;
    }

    public File getDefaultInIFile() {
        File file = new File(CONFIG_DIR, PREFERENCES_DEFAULT);
        return file;
    }
}

