/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.global;

import com.owon.uppersoft.dso.function.RecordControl;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.ChannelInverseTranslator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.wf.rt.ChannelDataInfo;
import com.owon.uppersoft.vds.core.wf.rt.LoadMedia;
import com.owon.uppersoft.vds.util.Pref;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class RecordControlTiny
extends RecordControl {
    private ChannelInverseTranslator cit = new ChannelInverseTranslator();

    public RecordControlTiny(ControlManager controlManager, Pref pref) {
        super(controlManager, pref);
    }

    @Override
    public int writeOnce(RandomAccessFile randomAccessFile, ControlManager controlManager, WaveFormManager waveFormManager, LoadMedia loadMedia, RecordControl recordControl) {
        int n;
        int n2 = recordControl.getCounter();
        int n3 = recordControl.getMaxframe();
        int n4 = loadMedia.getFrameCount();
        for (n = 0; n < n4; ++n) {
            this.writeFrame(randomAccessFile, controlManager, waveFormManager, loadMedia, n);
            if (++n2 < n3) continue;
            break;
        }
        return n;
    }

    public void writeFrame(RandomAccessFile randomAccessFile, ControlManager controlManager, WaveFormManager waveFormManager, LoadMedia loadMedia, int n) {
        long l = 0L;
        try {
            l = randomAccessFile.getFilePointer();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            randomAccessFile.writeInt(0);
            TimeControl timeControl = controlManager.getTimeControl();
            randomAccessFile.writeInt(timeControl.getTimebaseIdx());
            randomAccessFile.writeInt(timeControl.getHorizontalTriggerPosition());
            randomAccessFile.writeBoolean(controlManager.isPeakDetectWork());
            randomAccessFile.writeInt(controlManager.getDeepMemoryControl().getDeepDataLen());
            Iterator<? extends ChannelDataInfo> iterator = loadMedia.iterator_ChannelDataInfo();
            while (iterator.hasNext()) {
                ChannelDataInfo channelDataInfo = iterator.next();
                WaveForm waveForm = waveFormManager.getWaveForm(channelDataInfo.chl);
                ChannelInfo channelInfo = waveForm.wfi.ci;
                randomAccessFile.write(channelInfo.getNumber());
                long l2 = randomAccessFile.getFilePointer();
                randomAccessFile.writeInt(0);
                randomAccessFile.writeInt(this.cit.getInverseType_Record(channelInfo.isInverse()));
                int n2 = channelDataInfo.initPos;
                int n3 = channelDataInfo.screendatalen;
                int n4 = channelDataInfo.datalen;
                randomAccessFile.writeInt(0);
                randomAccessFile.writeInt(n3);
                randomAccessFile.writeInt(n3);
                randomAccessFile.writeInt(channelDataInfo.slowMove);
                randomAccessFile.writeInt(channelInfo.getPos0());
                randomAccessFile.writeInt(channelInfo.getVoltbaseIndex());
                randomAccessFile.writeInt(channelInfo.getProbeMultiIdx());
                randomAccessFile.writeFloat(channelInfo.getFreq());
                randomAccessFile.writeFloat(1.0f / channelInfo.getFreq());
                ByteBuffer byteBuffer = waveForm.getNextFrameADCBuffer(n);
                byte[] byArray = null;
                if (byteBuffer == null || (byArray = byteBuffer.array()) == null) {
                    randomAccessFile.seek(l);
                    return;
                }
                int n5 = byteBuffer.position();
                if (timeControl.isOnSlowMoveTimebase()) {
                    n5 = 0;
                }
                randomAccessFile.write(byArray, n5 + n2, n3);
                long l3 = randomAccessFile.getFilePointer();
                randomAccessFile.seek(l2);
                randomAccessFile.writeInt((int)(l3 - l2 - 4L));
                randomAccessFile.seek(l3);
            }
            long l4 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l);
            randomAccessFile.writeInt((int)(l4 - l - 4L));
            randomAccessFile.seek(l4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

