/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.global;

import com.owon.uppersoft.dso.function.PersistentDisplay;
import com.owon.uppersoft.dso.function.record.OfflineChannelsInfo;
import com.owon.uppersoft.dso.global.ControlApps;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.WorkBench;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.machine.aspect.IMultiReceiver;
import com.owon.uppersoft.dso.model.ChartDecorater;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.aspect.Paintable;
import com.owon.uppersoft.vds.core.data.CByteArrayInputStream;
import com.owon.uppersoft.vds.core.paint.ILazy;
import com.owon.uppersoft.vds.core.pref.Config;
import com.owon.uppersoft.vds.core.wf.dm.DMInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelsTransportInfo;
import com.owon.uppersoft.vds.ui.resource.FontCenter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class DataHouse
implements Localizable,
ILazy,
Paintable {
    public static final int Offline_Unload = 0;
    public static final int Offline_Normal = 1;
    public static final int Offline_DM = 2;
    public static final int RT_Normal = 11;
    public static final int RT_DM = 12;
    public static final int RC_Play = 21;
    public static double xRate = 1.0;
    public static double yRate = 1.0;
    private int status = 0;
    private boolean DataComplete = false;
    private CByteArrayInputStream cba;
    private WorkBench wb;
    private WaveFormManager wfm;
    public final ControlManager controlManager;
    protected CoreControl cc;
    private IMultiReceiver mr;
    public String divUnit;
    public String divUnits;
    private ChartDecorater gd;

    public MainWindow getMainWindow() {
        return this.wb.getMainWindow();
    }

    public ControlApps getControlApps() {
        return this.wb.getControlApps();
    }

    @Override
    public boolean allowLazyRepaint() {
        return this.isRuntime() || this.status == 0;
    }

    private boolean isRuntime() {
        return this.controlManager.isRuntime();
    }

    public boolean allowTransformScreenWaveFormVertical() {
        return !this.isRuntime() && this.status == 11 && this.controlManager.isRecentRunThenStop();
    }

    public boolean isDataComplete() {
        return this.DataComplete;
    }

    public void dataComplete() {
        this.DataComplete = true;
    }

    public void dataNotComplete() {
        this.DataComplete = false;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isPlayRecord() {
        return this.status == 21;
    }

    public boolean isParaAsync() {
        return this.status == 2 || this.status == 1;
    }

    public boolean isDMLoad() {
        return this.status == 2 || this.status == 12;
    }

    public boolean isRTWhenLoad() {
        return this.status == 11 || this.status == 12;
    }

    public void admiteRT() {
        this.status = 11;
    }

    public int getADC_yb() {
        return this.controlManager.paintContext.getHcenter();
    }

    public void setupDeepMemoryStorage(File file) {
        this.releaseDeepMemoryStorage();
        this.cba = new CByteArrayInputStream(file);
    }

    public void releaseDeepMemoryStorage() {
        if (this.cba != null) {
            this.cba.dispose();
        }
    }

    public CByteArrayInputStream getDeepMemoryStorage() {
        return this.cba;
    }

    public boolean isOptimizeDragCommandSend() {
        return this.controlManager.sourceManager.isNETConnect();
    }

    public DataHouse(ControlManager controlManager, WorkBench workBench) {
        this.wb = workBench;
        this.controlManager = controlManager;
        this.cc = controlManager.getCoreControl();
        controlManager.paintContext.setLazy(this);
        this.wfm = this.createWaveFormManager();
        this.gd = new ChartDecorater(controlManager, workBench, this);
        this.cc.getFFTControl().setWaveFormManager(this.wfm);
        this.mr = this.createMultiReceiver(controlManager, this.wfm);
        controlManager.pcs.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n;
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("CHARTSCREEN_UPDATESHOW")) {
                    DataHouse.this.getMainWindow().updateShow();
                } else if (!string.equals("SYNCOUTPUTCHANGE") || (n = ((Integer)propertyChangeEvent.getOldValue()).intValue()) == 0) {
                    // empty if block
                }
            }
        });
        this.localize(I18nProvider.bundle());
    }

    protected abstract IMultiReceiver createMultiReceiver(ControlManager var1, WaveFormManager var2);

    protected abstract WaveFormManager createWaveFormManager();

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.divUnit = resourceBundle.getString("Label.DivUnit");
        this.divUnits = this.controlManager.isEnglishLocale() ? this.divUnit + "s" : this.divUnit;
    }

    public boolean isLineLink() {
        return this.controlManager.displayControl.linelink;
    }

    @Override
    public void re_paint() {
        this.getMainWindow().re_paint();
    }

    public void adjustLocale_LocalizeWindow(Config config, int n) {
        config.setLocaleIndex(n);
        Locale locale = config.getLocales().get(n).getLocale();
        ResourceBundle resourceBundle = I18nProvider.updateLocale(locale);
        FontCenter.updateFont();
        this.controlManager.getLocalizeCenter().reLocalize(resourceBundle);
    }

    public WorkBench getWorkBench() {
        return this.wb;
    }

    public WaveFormManager getWaveFormManager() {
        return this.wfm;
    }

    public boolean isHorTrgPosFrozen() {
        return this.cc.getFFTControl().isFFTon();
    }

    public void receiveOfflineNormalData(OfflineChannelsInfo offlineChannelsInfo) {
        this.mr.receiveOfflineData(offlineChannelsInfo, this, 1);
        this.getWaveFormManager().retainClosedWaveForms();
    }

    public void receiveOfflineVideoData(OfflineChannelsInfo offlineChannelsInfo) {
        this.mr.receiveOfflineData(offlineChannelsInfo, this, 21);
        this.getWaveFormManager().retainClosedWaveForms();
    }

    public void receiveOfflineDMData(DMInfo dMInfo) {
        this.mr.receiveOfflineDMData(dMInfo, this);
        this.getWaveFormManager().retainClosedWaveForms();
    }

    public void receiveRTData(ChannelsTransportInfo channelsTransportInfo) {
        this.mr.receiveRTData(channelsTransportInfo, this);
    }

    public void reloadRTData(ChannelsTransportInfo channelsTransportInfo) {
        this.mr.reloadRTData(channelsTransportInfo, this);
    }

    public void receiveRTDMData(DMInfo dMInfo) {
        this.mr.receiveRTDMData(dMInfo, this);
    }

    public ControlManager getControlManager() {
        return this.controlManager;
    }

    public ChartDecorater getGlobalDecorater() {
        return this.gd;
    }

    public void resetPersistence() {
        this.controlManager.resetPersistence();
    }

    public void set3in1(boolean bl) {
        this.gd.getPersistentDisplay().resetPersistBufferImage();
    }

    public void closePersistence() {
        this.getPersistentDisplay().destroyFadeThread();
    }

    public PersistentDisplay getPersistentDisplay() {
        return this.gd.getPersistentDisplay();
    }
}

