/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.global;

import com.owon.uppersoft.dso.delegate.DefaultDeepProvider;
import com.owon.uppersoft.dso.delegate.DefaultFFTDelegate;
import com.owon.uppersoft.dso.delegate.DefaultFullScreenQuery;
import com.owon.uppersoft.dso.delegate.DefaultPVI;
import com.owon.uppersoft.dso.delegate.DefaultTimeConfProvider;
import com.owon.uppersoft.dso.delegate.DefaultTimeControlDelegate;
import com.owon.uppersoft.dso.delegate.DefaultTriggerExtendDelegate;
import com.owon.uppersoft.dso.delegate.DefaultVoltageProvider;
import com.owon.uppersoft.dso.function.measure.TimePerPointProvider;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.global.Principle;
import com.owon.uppersoft.dso.mode.control.DeepMemoryControl;
import com.owon.uppersoft.dso.mode.control.FFTControl;
import com.owon.uppersoft.dso.mode.control.SampleControl;
import com.owon.uppersoft.dso.mode.control.SysControl;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.mode.control.TimeControlDelegate;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerExtendDelegate;
import com.owon.uppersoft.dso.model.trigger.helper.TriggerLevelDelegate;
import com.owon.uppersoft.vds.core.aspect.control.DeepProvider;
import com.owon.uppersoft.vds.core.aspect.control.FullScreenQuery;
import com.owon.uppersoft.vds.core.aspect.control.ISupportChannelsNumber;
import com.owon.uppersoft.vds.core.aspect.control.MachineInfoProvider;
import com.owon.uppersoft.vds.core.aspect.control.Pos0_VBChangeInfluence;
import com.owon.uppersoft.vds.core.aspect.control.TimeConfProvider;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.machine.MachineInfo;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.core.pref.Config;
import com.owon.uppersoft.vds.core.sample.SampleRate;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.util.Pref;
import com.owon.uppersoft.vds.util.format.UnitConversionUtil;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;

public abstract class CoreControl
implements TimePerPointProvider,
MachineInfoProvider,
ISupportChannelsNumber {
    private final int channelsNumber;
    private Principle principle;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private MachineInfoProvider mip;
    private DefaultFFTDelegate fftd;
    private VoltageProvider vp;
    private TimeConfProvider tcp;
    private DeepProvider dp;
    private TimeControlDelegate tcd;
    private TriggerExtendDelegate ted;
    private FullScreenQuery fsq;
    private TriggerLevelDelegate tld;
    private DefaultPVI pvi;
    private String productParam = null;
    private SampleRate currentSampleRate;
    protected TriggerControl triggerControl;
    protected WaveFormInfoControl wfic;
    protected TimeControl timeControl;
    protected SampleControl sampleControl;
    protected DeepMemoryControl deepMemoryControl;
    protected SysControl sysControl;
    protected FFTControl fftControl;

    public Principle getPrinciple() {
        return this.principle;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.pcs;
    }

    public CoreControl(Config config, final Principle principle) {
        this.principle = principle;
        this.mip = new MachineInfoProvider(){

            @Override
            public MachineInfo getMachineInfo() {
                return principle.getMachine();
            }
        };
        Pref pref = config.getSessionProperties();
        principle.prepareTuneFunction(pref);
        MachineInfo machineInfo = principle.getMachine();
        this.channelsNumber = machineInfo.getChannelNumbers();
        this.vp = new DefaultVoltageProvider(this.mip);
        this.tcp = new DefaultTimeConfProvider(this.mip);
        this.dp = new DefaultDeepProvider(this.mip);
        this.tcd = new DefaultTimeControlDelegate(this, this.pcs);
        this.fsq = new DefaultFullScreenQuery(this.mip);
        this.fftd = new DefaultFFTDelegate(this);
        this.pvi = new DefaultPVI(this, this.pcs);
        this.initCore(machineInfo);
        this.productParam = null;
    }

    public VoltageProvider getVoltageProvider() {
        return this.vp;
    }

    public TimeConfProvider getTimeConfProvider() {
        return this.tcp;
    }

    public DeepProvider getDeepProvider() {
        return this.dp;
    }

    public TriggerLevelDelegate getTriggerLevelDelegate() {
        return this.tld;
    }

    public Pos0_VBChangeInfluence getPos0_VBChangeInfluence() {
        return this.pvi;
    }

    private void initCore(MachineInfo machineInfo) {
        this.wfic = this.createWaveFormInfoControl(this.vp, this.channelsNumber, this.pvi);
        this.ted = new DefaultTriggerExtendDelegate(this, this.pcs, this.wfic);
        this.triggerControl = this.createTriggerControl(this.channelsNumber, this.ted);
        this.tld = new TriggerLevelDelegate(this.triggerControl);
        this.sysControl = new SysControl();
        this.sampleControl = new SampleControl();
        this.deepMemoryControl = new DeepMemoryControl(this.dp);
        this.fftControl = new FFTControl(this.fftd, this.vp);
        this.timeControl = new TimeControl(machineInfo, this.tcp, this.tcd, this.dp, this.fsq);
    }

    protected TriggerControl createTriggerControl(int n, TriggerExtendDelegate triggerExtendDelegate) {
        return new TriggerControl(n, triggerExtendDelegate);
    }

    protected abstract WaveFormInfoControl createWaveFormInfoControl(VoltageProvider var1, int var2, Pos0_VBChangeInfluence var3);

    public int getAllChannelsNumber() {
        return this.wfic.getLowMachineChannels();
    }

    @Override
    public int getSupportChannelsNumber() {
        return this.wfic.getLowMachineChannels();
    }

    @Override
    public MachineInfo getMachineInfo() {
        return this.principle.getMachine();
    }

    public MachineType getMachine() {
        return this.principle.getMachineType();
    }

    public int getMachineTypeForSave() {
        return this.getMachine().saveID();
    }

    public void setProductParam(String string) {
        this.productParam = string;
    }

    public void persist(Pref pref) {
        if (this.productParam == null) {
            this.productParam = this.getMachine().name();
        }
        pref.setProperty("productParam", this.productParam + "ONE");
        this.principle.persist(pref);
        this.triggerControl.persist(pref);
        this.wfic.persist(pref);
        this.sampleControl.persist(pref);
        this.timeControl.persist(pref);
        this.deepMemoryControl.persist(pref);
        this.fftControl.persist(pref);
        this.sysControl.persist(pref);
    }

    public void factoryset(Pref pref) {
        this.triggerControl.load(pref);
        this.wfic.load(pref);
        this.sampleControl.load(pref);
        this.deepMemoryControl.load(pref);
        this.timeControl.load(pref);
        this.fftControl.load(pref, this.channelsNumber);
        this.sysControl.load(pref, false);
        this.currentSampleRate = this.computeSampleRate();
    }

    public void load(Pref pref) {
        this.triggerControl.load(pref);
        this.wfic.load(pref);
        this.sampleControl.load(pref);
        this.deepMemoryControl.load(pref);
        this.timeControl.load(pref);
        this.fftControl.load(pref, this.channelsNumber);
        this.sysControl.load(pref, true);
        this.currentSampleRate = this.computeSampleRate();
    }

    public void initDetail(Submitable submitable) {
        this.triggerControl.selfSubmit();
        this.wfic.selfSubmit(submitable);
        this.sampleControl.selfSubmit(submitable);
        this.deepMemoryControl.selfSubmit(submitable);
        this.sysControl.selfSubmit(submitable);
        this.fftControl.selfSubmit(submitable);
        this.timeControl.selfSubmit(submitable);
    }

    public void syncDetail(Submitable submitable) {
        if (this.fftControl.isFFTon()) {
            this.wfic.selfSubmit(submitable);
            this.fftControl.selfSubmit(submitable);
            this.timeControl.selfSubmit(submitable);
        } else {
            this.initDetail(submitable);
        }
    }

    public int getChannelSampleConfig() {
        return this.getMachineInfo().getChannelSampleType(this.wfic.getOnWaveFormNumber());
    }

    public boolean isPeakDetectWork() {
        if (this.fftControl.isFFTon()) {
            return false;
        }
        boolean bl = this.sampleControl.isPeakDetect();
        boolean bl2 = bl && this.checkPeakDetectWork();
        this.pcs.firePropertyChange("UPDATE_PK", null, (Object)bl2);
        return bl2;
    }

    protected abstract boolean checkPeakDetectWork();

    public boolean isSamplePromtion() {
        SampleRate sampleRate;
        int n = this.getChannelSampleConfig();
        if (n < 0) {
            return false;
        }
        SampleRate sampleRate2 = this.getSampleRateWithChannelNumFlag(n);
        boolean bl = !sampleRate2.equals((Object)(sampleRate = this.getChannelsSampleRate(n)));
        return bl;
    }

    public boolean isFullPointsLargerThenScreen() {
        int n;
        int n2 = this.timeControl.getRTfullScreenNumber();
        boolean bl = n2 > (n = 1000);
        return bl;
    }

    private SampleRate getSampleRateWithChannelNumFlag(int n) {
        if (n < 0) {
            return null;
        }
        SampleRate sampleRate = this.getMachineInfo().getSampleRate(n, this.deepMemoryControl.getDeepIdx())[this.timeControl.getTimebaseIdx()];
        return sampleRate;
    }

    public void updateCurrentSampleRate() {
        if (!this.fftControl.isFFTon()) {
            SampleRate sampleRate = this.currentSampleRate;
            SampleRate sampleRate2 = this.computeSampleRate();
            if (sampleRate2 == null) {
                return;
            }
            if (!sampleRate2.equals((Object)sampleRate)) {
                this.currentSampleRate = sampleRate2;
                this.pcs.firePropertyChange("SampleRateChange", (Object)sampleRate, (Object)sampleRate2);
            }
        }
    }

    public BigDecimal getCurrentSampleRateBD_kHz() {
        if (this.fftControl.isFFTon()) {
            BigDecimal bigDecimal = this.fftControl.getFFTSampleRateBD();
            if (bigDecimal == null) {
                return null;
            }
            return bigDecimal.divide(BigDecimal.valueOf(1000L));
        }
        if (this.currentSampleRate == null) {
            return null;
        }
        return this.currentSampleRate.getBDValue_kHz();
    }

    public String getCurrentSampleRate_Text() {
        if (this.fftControl.isFFTon()) {
            BigDecimal bigDecimal = this.fftControl.getFFTSampleRateBD();
            if (bigDecimal == null) {
                return "";
            }
            return UnitConversionUtil.getSimplifiedFrequencyLabel_Hz(bigDecimal.doubleValue());
        }
        if (this.currentSampleRate == null) {
            return "";
        }
        return this.currentSampleRate.getSampleRateTxt();
    }

    public boolean isTrgLevelDisable() {
        return false;
    }

    public boolean mayDelayInvalid() {
        return !this.getTriggerControl().isSingleTrg() || this.getTriggerControl().getSingleTriggerSet().isCurrentTrigger_Video();
    }

    public boolean shouldSkipBeforeFrames() {
        return this.getTriggerControl().isSweepNormal() || this.getTriggerControl().isSweepOnce() || this.getFFTControl().isFFTon() || this.isPeakDetectWork() || this.getSampleControl().avgon || this.getTimeControl().isOnSlowMoveTimebase();
    }

    private SampleRate computeSampleRate() {
        return this.getSampleRateWithChannelNumFlag(this.getChannelSampleConfig());
    }

    private SampleRate getChannelsSampleRate(int n) {
        MachineInfo machineInfo = this.getMachineInfo();
        SampleRate sampleRate = machineInfo.getSampleRate(n, machineInfo.DEEPValue.length - 1)[0];
        return sampleRate;
    }

    public TimeControl getTimeControl() {
        return this.timeControl;
    }

    public SampleControl getSampleControl() {
        return this.sampleControl;
    }

    public DeepMemoryControl getDeepMemoryControl() {
        return this.deepMemoryControl;
    }

    public SysControl getSysControl() {
        return this.sysControl;
    }

    public FFTControl getFFTControl() {
        return this.fftControl;
    }

    public TriggerControl getTriggerControl() {
        return this.triggerControl;
    }

    public WaveFormInfoControl getWaveFormInfoControl() {
        return this.wfic;
    }

    public WaveFormInfo[] getWaveFormInfos() {
        return this.wfic.getWaveFormInfos();
    }

    public WaveFormInfo getWaveFormInfo(int n) {
        return this.wfic.getWaveFormInfo(n);
    }

    public void updateHorTrgPosRange() {
        int n = this.deepMemoryControl.getDeepIdx();
        int n2 = this.getChannelSampleConfig();
        this.timeControl.computeHorTrgRange(n, n2);
    }

    public void updateHorTrgIdx4View() {
        int n = this.deepMemoryControl.getDeepIdx();
        int n2 = this.timeControl.getHorizontalTriggerPosition();
        this.timeControl.computeHorTrgIdx(n, n2);
    }

    public void updateDMHorTrgIdx4View(int n, int n2) {
        this.timeControl.computeDMHorTrgIdx(n, n2);
    }

    public boolean isRunMode_slowMove() {
        return this.timeControl.isOnSlowMoveTimebase() && !this.fftControl.isFFTon();
    }

    public boolean isRunMode_FFT() {
        return this.fftControl.isFFTon();
    }

    @Override
    public abstract double getTimePerPoint(int var1);

    public int fftAvailablePoints() {
        return this.getMachineInfo().fftAvailablePoints(this.fftControl.getFFTTimebaseIndex());
    }

    public void ontFFTSwitch(boolean bl, int n) {
        String string;
        if (bl) {
            this.wfic.storeChannelsDisplaybeforeFFT();
            this.wfic.preSetChannelsForFFT(n);
            this.getSampleControl().c_setModelIdx(0);
            string = "FFT_ON";
        } else {
            this.wfic.recoverChannelsDisplayfromNonFFT();
            string = "FFT_OFF";
        }
        this.getTimeControl().updateTimebase();
        Platform.getControlApps().interComm.syncDetail(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        });
        this.pcs.firePropertyChange(string, null, null);
    }
}

