/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.global;

import com.owon.uppersoft.dso.control.IDataImporter;
import com.owon.uppersoft.dso.function.RecordControl;
import com.owon.uppersoft.dso.function.ref.IReferenceWaveForm;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.DefaultDockControl;
import com.owon.uppersoft.dso.global.DockControl;
import com.owon.uppersoft.dso.global.PageManagerTiny;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.global.Principle;
import com.owon.uppersoft.dso.global.RecordControlTiny;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.DataImporterTiny;
import com.owon.uppersoft.dso.model.RefWFCreator;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.TrgTypeDefine;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.page.function.PageManager;
import com.owon.uppersoft.dso.ref.IRefSource;
import com.owon.uppersoft.dso.ref.RefWaveForm;
import com.owon.uppersoft.dso.source.comm.detect.PromptPlace;
import com.owon.uppersoft.dso.source.manager.SourceManager;
import com.owon.uppersoft.dso.source.usb.USBPortsFilter;
import com.owon.uppersoft.vds.core.comm.IRuntime;
import com.owon.uppersoft.vds.core.pref.Config;
import com.owon.uppersoft.vds.source.comm.PortFilterTiny;
import com.owon.uppersoft.vds.source.comm.SourceManagerTiny;
import com.owon.uppersoft.vds.util.Pref;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class ControlManagerTiny
extends ControlManager {
    private DockControl dc;

    public ControlManagerTiny(Config config, Principle principle, CoreControl coreControl) {
        super(config, principle, coreControl);
    }

    @Override
    public IReferenceWaveForm loadRefWF(File file) {
        return RefWFCreator.loadRefWF(file, this);
    }

    @Override
    protected SourceManager getSourceManager(IRuntime iRuntime) {
        USBPortsFilter uSBPortsFilter = this.createPortFilter();
        SourceManagerTiny sourceManagerTiny = new SourceManagerTiny(iRuntime, uSBPortsFilter);
        sourceManagerTiny.setup();
        return sourceManagerTiny;
    }

    @Deprecated
    private USBPortsFilter createPortFilter() {
        return new PortFilterTiny(){

            @Override
            protected String getMachineNameFromCode(int n) {
                switch (n) {
                    case 1: {
                        return "VDS1022";
                    }
                    case 3: {
                        return "VDS2052";
                    }
                }
                return null;
            }
        };
    }

    @Override
    public IDataImporter geBinaryFileImporter() {
        return new DataImporterTiny();
    }

    @Override
    public void persist(Pref pref) {
        super.persist(pref);
        Platform.getControlApps().onPersist(pref);
    }

    @Override
    public RefWaveForm createReferenceWaveForm(IRefSource iRefSource, WaveFormManager waveFormManager) {
        return RefWFCreator.createRefWF(this, iRefSource, waveFormManager);
    }

    @Override
    protected RecordControl createRecordControl(ControlManager controlManager, Pref pref) {
        return new RecordControlTiny(controlManager, pref);
    }

    @Override
    public DockControl getDockControl() {
        if (this.dc == null) {
            this.dc = new DefaultDockControl(){

                @Override
                protected PageManager createPageManager() {
                    return new PageManagerTiny();
                }
            };
        }
        return this.dc;
    }

    @Override
    public boolean singleVideoAlow(TrgTypeDefine trgTypeDefine, int n, TriggerControl triggerControl) {
        if (n != 0 && trgTypeDefine == TrgTypeDefine.Video) {
            String string = I18nProvider.bundle().getString("Info.VideoOnlyForCH1");
            String string2 = "";
            JFrame jFrame = Platform.getMainWindow().getFrame();
            JOptionPane.showMessageDialog(jFrame, string, string2, 1);
            PropertyChangeSupport propertyChangeSupport = triggerControl.getDelegate().getPropertyChangeSupport();
            propertyChangeSupport.firePropertyChange("CHOOSE_TRGMODECB", (Object)0, (Object)TrgTypeDefine.Edge);
            return false;
        }
        return true;
    }

    @Override
    public PromptPlace createPromptPlace() {
        return new PromptPlace(this){
            protected JProgressBar jpb;

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                super.propertyChange(propertyChangeEvent);
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("FPD_START_SEND")) {
                    this.jpb = new JProgressBar();
                    this.jpb.setMaximum((Integer)propertyChangeEvent.getNewValue());
                    this.jpb.setBounds(0, 125, 350, 22);
                    this.add(this.jpb);
                } else if (string.equals("FPD_SEND_LENGTH")) {
                    if (this.jpb != null) {
                        this.jpb.setValue(this.jpb.getValue() + (Integer)propertyChangeEvent.getNewValue());
                    }
                } else if (string.equals("FPD_DONE")) {
                    if (this.jpb != null) {
                        this.remove(this.jpb);
                    }
                    this.jpb = null;
                } else if (string.equals("FPD_NOFILE")) {
                    this.infoarea.setText(propertyChangeEvent.getNewValue().toString());
                } else if (string.equals("ProgressStart")) {
                    this.jpb = new JProgressBar();
                    this.jpb.setMaximum((Integer)propertyChangeEvent.getNewValue());
                    this.jpb.setBounds(0, 125, 350, 22);
                    this.add(this.jpb);
                } else if (string.equals("ProgressIncrease")) {
                    if (this.jpb != null) {
                        this.jpb.setValue(this.jpb.getValue() + (Integer)propertyChangeEvent.getNewValue());
                    }
                } else if (string.equals("ProgressDone")) {
                    if (this.jpb != null) {
                        this.remove(this.jpb);
                    }
                    this.jpb = null;
                }
            }
        };
    }
}

