/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.global;

import com.owon.uppersoft.dso.control.IDataImporter;
import com.owon.uppersoft.dso.data.LObject;
import com.owon.uppersoft.dso.delegate.DefaultRuntime;
import com.owon.uppersoft.dso.function.DisplayControl;
import com.owon.uppersoft.dso.function.DocsManager;
import com.owon.uppersoft.dso.function.ExportWaveControl;
import com.owon.uppersoft.dso.function.FFTCursorControl;
import com.owon.uppersoft.dso.function.MarkCursorControl;
import com.owon.uppersoft.dso.function.PFRuleManager;
import com.owon.uppersoft.dso.function.PlayerControl;
import com.owon.uppersoft.dso.function.RecordControl;
import com.owon.uppersoft.dso.function.ReferenceWaveControl;
import com.owon.uppersoft.dso.function.ReloadManager;
import com.owon.uppersoft.dso.function.SoftwareControl;
import com.owon.uppersoft.dso.function.measure.MeasureManager;
import com.owon.uppersoft.dso.function.measure.MeasureSnapshot;
import com.owon.uppersoft.dso.function.measure.MeasureWFSupport;
import com.owon.uppersoft.dso.function.record.OfflineChannelsInfo;
import com.owon.uppersoft.dso.function.ref.IReferenceWaveForm;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.DockControl;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.global.Principle;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.mode.control.DeepMemoryControl;
import com.owon.uppersoft.dso.mode.control.FFTControl;
import com.owon.uppersoft.dso.mode.control.SampleControl;
import com.owon.uppersoft.dso.mode.control.SysControl;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.TrgTypeDefine;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.model.trigger.TriggerUIInfo;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.ref.IRefSource;
import com.owon.uppersoft.dso.source.comm.AbsInterCommunicator;
import com.owon.uppersoft.dso.source.comm.TrgStatus;
import com.owon.uppersoft.dso.source.comm.detect.PromptPlace;
import com.owon.uppersoft.dso.source.manager.SourceManager;
import com.owon.uppersoft.dso.util.DBG;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.TitleStatusLabel;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.core.aspect.control.ISupportChannelsNumber;
import com.owon.uppersoft.vds.core.aspect.help.ILoadPersist;
import com.owon.uppersoft.vds.core.comm.IRuntime;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.control.MathControl;
import com.owon.uppersoft.vds.core.machine.MachineInfo;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.core.measure.MeasureModel;
import com.owon.uppersoft.vds.core.paint.IPaintOne;
import com.owon.uppersoft.vds.core.paint.PaintContext;
import com.owon.uppersoft.vds.core.pref.Config;
import com.owon.uppersoft.vds.core.zoom.AssitControl;
import com.owon.uppersoft.vds.print.PrinterPreviewControl;
import com.owon.uppersoft.vds.socket.server.ServerControl;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import com.owon.uppersoft.vds.util.LocalizeCenter;
import com.owon.uppersoft.vds.util.Pref;
import java.awt.Window;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public abstract class ControlManager
implements ISupportChannelsNumber {
    private DefaultRuntime ir = new DefaultRuntime(this);
    public final MathControl mathControl;
    public final SourceManager sourceManager;
    public final DisplayControl displayControl;
    public final MarkCursorControl mcctr;
    public final FFTCursorControl fftctr;
    public final PrinterPreviewControl ppc;
    public ReferenceWaveControl rwc;
    public MeasureModel measMod;
    private AssitControl zoomAssctr;
    public ExportWaveControl ewc;
    public SoftwareControl sc;
    public PlayerControl playCtrl;
    public RecordControl rc;
    public PropertyChangeSupport pcs;
    public PFRuleManager ruleManager;
    public ReloadManager reloadManager;
    public DocsManager docManager;
    public ServerControl scpiServer;
    private Config conf;
    private CoreControl cc;
    public int circleSerialPort;
    private Principle principle;
    private MeasureManager mm;
    private long measureTimes;
    private LocalizeCenter lc = new LocalizeCenter();
    public final IDataImporter binIn;
    public PaintContext paintContext;
    public int computeFreqTimes;
    public int measureSnapshotIdx = 0;
    public int maxFailureTime = 20;
    public String openfilePath;
    public String saveimgPath;
    public String exportPath;
    public boolean istipsWindowShow;
    public List<ILoadPersist> lpList = new LinkedList<ILoadPersist>();
    private boolean pau_expEnable = true;
    private boolean duringDMFtech = false;
    public int curTrgStatus;
    private TitleStatusLabel statuslbl;

    public boolean isRuntime() {
        return this.ir.isRuntime();
    }

    public IRuntime getIRuntime() {
        return this.ir;
    }

    public PromptPlace createPromptPlace() {
        return new PromptPlace(this);
    }

    public WaveFormInfoControl getWaveFormInfoControl() {
        return this.cc.getWaveFormInfoControl();
    }

    public TriggerControl getTriggerControl() {
        return this.cc.getTriggerControl();
    }

    public TimeControl getTimeControl() {
        return this.cc.getTimeControl();
    }

    public SampleControl getSampleControl() {
        return this.cc.getSampleControl();
    }

    public DeepMemoryControl getDeepMemoryControl() {
        return this.cc.getDeepMemoryControl();
    }

    public SysControl getSysControl() {
        return this.cc.getSysControl();
    }

    public FFTControl getFFTControl() {
        return this.cc.getFFTControl();
    }

    public boolean isTrgLevelDisable() {
        return this.cc.isTrgLevelDisable();
    }

    public String getCurrentSampleRate_Text() {
        return this.cc.getCurrentSampleRate_Text();
    }

    public BigDecimal getCurrentSampleRateBD_kHz() {
        return this.cc.getCurrentSampleRateBD_kHz();
    }

    public int getAllChannelsNumber() {
        return this.cc.getAllChannelsNumber();
    }

    @Override
    public int getSupportChannelsNumber() {
        return this.cc.getSupportChannelsNumber();
    }

    public MachineInfo getMachineInfo() {
        return this.cc.getMachineInfo();
    }

    public MachineType getMachine() {
        return this.cc.getMachine();
    }

    public int getMachineTypeForSave() {
        return this.cc.getMachineTypeForSave();
    }

    public CoreControl getCoreControl() {
        return this.cc;
    }

    public Principle getPrinciple() {
        return this.principle;
    }

    public boolean isSuitableMachineType(int n) {
        int n2 = this.getMachineTypeForSave();
        return n2 == n;
    }

    public boolean isSameSeries(int n) {
        return this.principle.isSameSeries(n);
    }

    public boolean isBandLimit() {
        String string = this.getMachine().name();
        if (string.startsWith("VDS2062")) {
            return this.sc.isVDS2062Bandlimit();
        }
        if (string.startsWith("VDS2064")) {
            return this.sc.isVDS2064Bandlimit();
        }
        return this.getMachine().bandLimit();
    }

    public String getMachineTypeName(int n) {
        return this.principle.getMachineTypeName(n);
    }

    public AssitControl getZoomAssctr() {
        return this.zoomAssctr;
    }

    public OfflineChannelsInfo getPlayChannelsInfo() {
        return this.playCtrl.getPlayChannelsInfo();
    }

    public boolean isChineseLocale() {
        return Locale.getDefault().getLanguage().equals(Locale.CHINESE.getLanguage());
    }

    public boolean isEnglishLocale() {
        return Locale.getDefault().getLanguage().equals(Locale.ENGLISH.getLanguage());
    }

    public abstract DockControl getDockControl();

    public MeasureManager getMeasureManager() {
        return this.mm;
    }

    public void updateMeasure(MeasureWFSupport measureWFSupport) {
        if (!this.mm.ison()) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.measureTimes;
        if (l2 > 800L) {
            this.measure(measureWFSupport);
            this.measureTimes = l;
        }
    }

    public void measure(MeasureWFSupport measureWFSupport) {
        double d = this.cc.getMachine().getLimitFrequency();
        boolean bl = this.mayDelayInvalid();
        this.mm.measure(measureWFSupport, this.cc.getTriggerControl(), d, bl, this.cc.getVoltageProvider(), this.measMod, this.cc.getSupportChannelsNumber(), this.cc);
    }

    public LocalizeCenter getLocalizeCenter() {
        return this.lc;
    }

    public String getDivUnit() {
        return this.lc.getCacheText("Label.DivUnit");
    }

    public String getDivUnits() {
        return this.lc.getCacheText("Label.DivUnits");
    }

    public ControlManager(Config config, Principle principle, final CoreControl coreControl) {
        this.conf = config;
        this.principle = principle;
        this.binIn = this.geBinaryFileImporter();
        this.cc = coreControl;
        this.pcs = coreControl.getPropertyChangeSupport();
        this.sc = new SoftwareControl(this);
        Pref pref = config.getSessionProperties();
        int n = this.getSupportChannelsNumber();
        Define.prepare(pref.loadInt("STYLE_TYPE"));
        DBG.debug = pref.loadBoolean("debug");
        this.sourceManager = this.getSourceManager(this.ir);
        PrinterPreviewControl.setupResourceBundleProvider(I18nProvider.getResourceBundleProvider());
        this.ppc = new PrinterPreviewControl(pref);
        this.measMod = new MeasureModel(n, pref);
        this.measureTimes = 0L;
        this.mm = new MeasureManager(this.pcs, this.measMod);
        this.rc = this.createRecordControl(this, pref);
        this.reloadManager = new ReloadManager(this);
        coreControl.load(pref);
        this.getDockControl().init(this);
        this.load(pref);
        this.ruleManager = new PFRuleManager(pref, n);
        this.mathControl = new MathControl(pref);
        this.zoomAssctr = new AssitControl(coreControl.getTimeControl(), pref, coreControl.getTimeConfProvider(), this.pcs);
        coreControl.updateHorTrgPosRange();
        coreControl.updateHorTrgIdx4View();
        this.mcctr = new MarkCursorControl(pref, n, coreControl.getTimeControl(), this.pcs, coreControl.getWaveFormInfoControl());
        this.fftctr = new FFTCursorControl(this, pref);
        this.displayControl = new DisplayControl(pref, this);
        this.rwc = new ReferenceWaveControl(this, pref, coreControl);
        this.playCtrl = new PlayerControl(this, pref);
        this.ewc = new ExportWaveControl(this);
        this.docManager = new DocsManager(this);
        this.paintContext = new PaintContext(){

            @Override
            public IPaintOne getIPaintOne() {
                return coreControl.getMachine().getPaintOne();
            }
        };
        this.paintContext.setColorProvider(this.displayControl);
        this.circleSerialPort = pref.loadInt("circleSerialPort");
        if (this.circleSerialPort < 0) {
            this.circleSerialPort = 0;
        }
        this.scpiServer = new ServerControl(pref);
    }

    public abstract IReferenceWaveForm loadRefWF(File var1);

    public abstract boolean singleVideoAlow(TrgTypeDefine var1, int var2, TriggerControl var3);

    protected abstract SourceManager getSourceManager(IRuntime var1);

    public abstract IDataImporter geBinaryFileImporter();

    public abstract IReferenceWaveForm createReferenceWaveForm(IRefSource var1, WaveFormManager var2);

    protected RecordControl createRecordControl(ControlManager controlManager, Pref pref) {
        return new RecordControl(controlManager, pref);
    }

    public void fire_RefreshMeasureResult() {
        this.pcs.firePropertyChange("RefreshMeasureResult", null, null);
    }

    public void initDetail(Submitable submitable) {
        this.cc.initDetail(submitable);
    }

    public void syncDetail(Submitable submitable) {
        this.cc.syncDetail(submitable);
    }

    public boolean isPeakDetectWork() {
        return this.cc.isPeakDetectWork();
    }

    public void persist(Pref pref) {
        pref.persistLocale(Locale.getDefault());
        this.cc.persist(pref);
        this.ruleManager.persist(pref);
        this.mathControl.persist(pref);
        this.displayControl.persist(pref);
        for (ILoadPersist iLoadPersist : this.lpList) {
            iLoadPersist.persist(pref);
        }
        pref.persistInt("STYLE_TYPE", Define.def.STYLE_TYPE);
        this.mcctr.persist(pref);
        this.fftctr.persist(pref);
        this.ppc.persist(pref);
        this.measMod.persist(pref);
        this.rc.persist(pref);
        this.getZoomAssctr().persist(pref);
        this.rwc.persist(pref);
        this.playCtrl.persist(pref);
        this.reloadManager.persist(pref);
        this.scpiServer.persist(pref);
        if (this.getZoomAssctr().isonZoom()) {
            pref.persistInt("Timebase.index", this.getZoomAssctr().mtbIdx);
            pref.persistInt("HorTrgPos", this.getZoomAssctr().mhtp);
        }
        pref.persistBoolean("debug", DBG.debug);
        pref.persistInt("log_type", DBG.cmddebug);
        pref.persistInt("ComputeFreqTimes", this.computeFreqTimes);
        pref.persistInt("maxFailureTime", this.maxFailureTime);
        pref.setProperty("OpenfilePath", this.openfilePath);
        pref.setProperty("SaveimgPath", this.saveimgPath);
        pref.setProperty("ExportPath", this.exportPath);
        pref.persistBoolean("TipsWindowShow", this.istipsWindowShow);
    }

    protected void load(Pref pref) {
        for (ILoadPersist iLoadPersist : this.lpList) {
            iLoadPersist.load(pref);
        }
        this.reloadManager.load(pref);
        this.computeFreqTimes = pref.loadInt("ComputeFreqTimes");
        if (this.computeFreqTimes <= 0) {
            this.computeFreqTimes = 5;
        }
        this.maxFailureTime = pref.loadInt("maxFailureTime");
        if (this.maxFailureTime < 0) {
            this.maxFailureTime = 20;
        }
        this.openfilePath = pref.getProperty("OpenfilePath", "");
        this.saveimgPath = pref.getProperty("SaveimgPath", "");
        this.exportPath = pref.getProperty("ExportPath", "");
        this.istipsWindowShow = pref.loadBoolean("TipsWindowShow");
    }

    public void changeKeepget(boolean bl) {
        this.fireRecord_PlayUpdate(bl);
        this.pcs.firePropertyChange("Keepget", !bl, bl);
        WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
        waveFormManager.resetVbmulti();
        if (!bl) {
            waveFormManager.saveFirstLoadPos0();
        }
    }

    private void fireRecord_PlayUpdate(boolean bl) {
        boolean bl2 = !bl;
        boolean bl3 = this.rc.isRecording();
        boolean bl4 = this.playCtrl.isPlaying();
        if (bl3 && bl2) {
            this.rc.forceStop();
        }
        if (!bl4 || bl) {
            // empty if block
        }
    }

    public void factorySet() {
        Pref pref = this.conf.getFactoryProperties();
        this.conf.setSessionProperties(pref);
        this.defaultSet(pref);
        Platform.getControlApps().interComm.syncFactorySet2Machine();
    }

    public void defaultSet() {
        this.getWaveFormInfoControl().releaseWF();
        this.defaultSet(this.conf.getSessionProperties());
        AbsInterCommunicator absInterCommunicator = Platform.getControlApps().interComm;
        if (this.ir.isRuntimeStop()) {
            absInterCommunicator.statusRun(false, true);
        }
        absInterCommunicator.initDetail();
    }

    protected void defaultSet(Pref pref) {
        this.cc.factoryset(pref);
        this.load(pref);
        int n = this.getSupportChannelsNumber();
        this.ruleManager.load(pref, n);
        this.getZoomAssctr().factoryload(pref);
        this.cc.updateHorTrgIdx4View();
        this.mathControl.load(pref);
        this.fftctr.load(pref);
        this.displayControl.loadFactorySet(pref);
        this.rwc.factoryload(pref);
        this.mcctr.load(pref, n);
        this.mcctr.computeValues();
        this.rc.load(pref);
        this.playCtrl.load(pref);
        Platform.getDataHouse().getWaveFormManager().getCompositeWaveForm().resetYloc();
        Platform.getDataHouse().getPersistentDisplay().fadeThdOn_Off_UI(this.displayControl.getPersistenceIndex());
        MainWindow mainWindow = Platform.getMainWindow();
        MeasureSnapshot.closeMeasureSnapshot();
        this.fireFFTonoff2EnableMainWindow();
        mainWindow.updateDefaultAll();
    }

    public void fireFFTonoff2EnableMainWindow() {
        boolean bl = this.getFFTControl().isFFTon();
        this.pcs.firePropertyChange(bl ? "FFT_ON" : "FFT_OFF", null, null);
    }

    public void reduceFrame() {
        DataHouse dataHouse = Platform.getDataHouse();
        if (this.ir.isRuntime()) {
            return;
        }
        dataHouse.getWaveFormManager().reduceFrame();
        Platform.getMainWindow().updateShow();
    }

    public void onRelease(File file) {
        this.ir.setExit();
        this.conf.persist(file, new ILoadPersist(){

            @Override
            public void persist(Pref pref) {
                ControlManager.this.persist(pref);
            }

            @Override
            public void load(Pref pref) {
            }
        });
    }

    public boolean isPau_expEnable() {
        return this.pau_expEnable;
    }

    public void updateExportbtnEnable(boolean bl) {
        this.pcs.firePropertyChange("Pau_expBtnUpdate", null, (Object)bl);
        this.pau_expEnable = bl;
    }

    public void duringDMFetch(boolean bl) {
        this.duringDMFtech = bl;
        this.pcs.firePropertyChange("DURINGDMFETCH", null, (Object)bl);
    }

    public boolean isDuringDMFtech() {
        return this.duringDMFtech;
    }

    public SoftwareControl getSoftwareControl() {
        return this.sc;
    }

    public boolean mayDelayInvalid() {
        return this.cc.mayDelayInvalid();
    }

    public Config getConfig() {
        return this.conf;
    }

    public boolean isXYModeSupport() {
        return this.getAllChannelsNumber() > 1;
    }

    public String getFreqLabel(ChannelInfo channelInfo) {
        TriggerUIInfo triggerUIInfo;
        boolean bl;
        boolean bl2 = bl = channelInfo.getFreqtxt() == null || !channelInfo.isOn() || channelInfo.isGround();
        if (bl) {
            return "?";
        }
        TriggerControl triggerControl = this.getTriggerControl();
        TriggerSet triggerSet = triggerControl.getTriggerSetOrNull(channelInfo.getNumber());
        if (triggerSet != null && triggerSet.getTrigger() == triggerSet.video) {
            return "?";
        }
        if (triggerControl.isSingleTrg() && (triggerUIInfo = triggerControl.getTriggerUIInfo()).getCurrentChannel() != channelInfo.getNumber()) {
            return "?";
        }
        boolean bl3 = bl = !TrgStatus.isFreqShowableOnTrgStatus(this.curTrgStatus);
        if (bl) {
            return "<2Hz";
        }
        return channelInfo.getFreqtxt().replace(",", "");
    }

    public List<LObject> getSyncInOuts() {
        return SysControl.syncs;
    }

    public boolean isExit() {
        return this.ir.isExit();
    }

    public boolean isKeepGet() {
        return this.ir.isKeepGet();
    }

    public boolean isRuntimeStop() {
        return this.ir.isRuntimeStop();
    }

    public boolean isRecentRunThenStop() {
        return this.ir.isRecentRunThenStop();
    }

    public boolean isTimeOperatable() {
        if (this.getFFTControl().isFFTon() || this.getZoomAssctr().isonAssistSet()) {
            return false;
        }
        return this.isRuntime() || this.isRuntimeStop() || !this.sourceManager.isConnected();
    }

    public boolean is50percentAvailable() {
        return this.isRuntime() || this.isRecentRunThenStop();
    }

    public boolean allowTransformScreenWaveForm() {
        TriggerControl triggerControl = this.getTriggerControl();
        return this.isRuntime() && (triggerControl.isSweepNormal() || triggerControl.isSweepOnce());
    }

    public boolean allowTransformScreenWaveForm_Ready() {
        return this.allowTransformScreenWaveForm();
    }

    public void resetPersistence() {
        this.pcs.firePropertyChange("PERSISTENCE_RESET", null, null);
    }

    public Runnable getResetPersistenceRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                ControlManager.this.resetPersistence();
            }
        };
    }

    public void notifyShouldEnableTrg() {
        this.getTimeControl().setShouldEnableTrgByJudgeIsSlowMove();
        String string = this.getTriggerControl().isTrgEnable() ? "SwitchNormalMove" : "SwitchSlowMove";
        this.pcs.firePropertyChange(string, null, null);
    }

    public void updateChannelVoltValueEverywhere(int n) {
        ChannelInfo channelInfo = this.getWaveFormInfoControl().getWaveFormChannelInfo(n);
        this.measure(Platform.getDataHouse().getWaveFormManager());
        this.mcctr.computeYValues();
        this.fire_RefreshMeasureResult();
        this.pcs.firePropertyChange("UPDATE_CHLVOLT", null, (Object)n);
        this.pcs.firePropertyChange("REPAINT_CHARTSCREEN", null, null);
        this.pcs.firePropertyChange("UpdateVoltsense", -1, n);
    }

    public boolean shouldAdjustHorTrgPos() {
        Window window = Platform.getMainWindow().getWindow();
        if (this.getZoomAssctr().isonAssistSet()) {
            FadeIOShell fadeIOShell = new FadeIOShell();
            fadeIOShell.prompt(I18nProvider.bundle().getString("M.Zoom.Warn"), window);
            return false;
        }
        boolean bl = Platform.getControlApps().interComm.isTimeOperatableNTryGetDM();
        if (!bl) {
            return false;
        }
        if (Platform.getDataHouse().isHorTrgPosFrozen()) {
            FadeIOShell fadeIOShell = new FadeIOShell();
            fadeIOShell.prompt(I18nProvider.bundle().getString("Label.SlowMoveWarn"), window);
            return false;
        }
        return true;
    }

    public void bufferTitleStatus(TitleStatusLabel titleStatusLabel) {
        this.statuslbl = titleStatusLabel;
    }

    public String getTitleStatusLabel() {
        if (this.statuslbl != null) {
            return this.statuslbl.getText();
        }
        return "?";
    }
}

