/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.global;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.OperateBlocker;
import com.owon.uppersoft.dso.machine.aspect.IStopable;
import com.owon.uppersoft.dso.source.comm.AbsInterCommunicator;
import com.owon.uppersoft.dso.source.comm.InfiniteDaemon;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.vds.core.comm.IRuntime;
import com.owon.uppersoft.vds.core.comm.JobQueueDispatcher;
import com.owon.uppersoft.vds.core.comm.effect.JobUnitDealer;
import com.owon.uppersoft.vds.util.Pref;

public abstract class ControlApps
implements IStopable {
    protected JobQueueDispatcher df;
    public AbsInterCommunicator interComm;
    private InfiniteDaemon daemon;
    protected ControlManager cm;
    private OperateBlocker ob;
    private IRuntime ir;
    private boolean isDMDataGotAlready = false;
    private boolean isDMprepared = false;

    public ControlApps(DataHouse dataHouse, MainWindow mainWindow) {
        this.cm = dataHouse.controlManager;
        this.ir = this.cm.getIRuntime();
        this.ob = new OperateBlocker();
        this.df = new JobQueueDispatcher(this.cm.sourceManager, this.cm.pcs);
        SubmitorFactory.setSourceManager(this.df, this.cm);
        this.interComm = this.createInterCommunicator(dataHouse, mainWindow);
        this.daemon = this.createInfiniteDaemon(dataHouse, mainWindow, this.df, this.interComm);
        this.reload();
        this.daemon.start();
    }

    protected abstract InfiniteDaemon createInfiniteDaemon(DataHouse var1, MainWindow var2, JobQueueDispatcher var3, AbsInterCommunicator var4);

    protected abstract AbsInterCommunicator createInterCommunicator(DataHouse var1, MainWindow var2);

    protected abstract void reload();

    @Override
    public OperateBlocker getOperateBlocker() {
        return this.ob;
    }

    public JobQueueDispatcher getJobQueueDispatcher() {
        return this.df;
    }

    public JobUnitDealer getJobUnitDealer() {
        return this.df;
    }

    public InfiniteDaemon getDaemon() {
        return this.daemon;
    }

    public ControlManager getControlManager() {
        return this.cm;
    }

    public void onExit() {
        this.releaseConnect();
    }

    public void onPersist(Pref pref) {
        this.daemon.onExit(pref);
    }

    @Override
    public void releaseConnect() {
        System.out.println("releaseConnect");
        InfiniteDaemon infiniteDaemon = this.getDaemon();
        infiniteDaemon.addMission(infiniteDaemon.m_dislink);
    }

    @Override
    public void stopkeep() {
        if (!this.ir.isKeepGet()) {
            return;
        }
        this.ir.setKeepGet(false);
        this.cm.reduceFrame();
        this.isDMprepared = true;
    }

    @Override
    public void stopkeepNForbidDM() {
        if (!this.ir.isKeepGet()) {
            return;
        }
        this.ir.setKeepGet(false);
        this.isDMprepared = false;
    }

    @Override
    public void setDMDataGotAlready(boolean bl) {
        this.isDMDataGotAlready = bl;
    }

    @Override
    public boolean isDMDataGotAlready() {
        return this.isDMDataGotAlready;
    }

    public boolean isDMAvailable() {
        return this.isDMprepared;
    }

    @Override
    public void resumeKeep() {
        this.ir.setKeepGet(true);
    }

    @Override
    public void keepload() {
        this.isDMprepared = false;
        this.isDMDataGotAlready = false;
        if (this.ir.isKeepGet()) {
            return;
        }
        InfiniteDaemon infiniteDaemon = this.getDaemon();
        infiniteDaemon.addMission(infiniteDaemon.m_startGet);
    }
}

