/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function.ref;

import com.owon.uppersoft.dso.function.ReferenceWaveControl;
import com.owon.uppersoft.dso.function.ref.IReferenceWaveForm;
import com.owon.uppersoft.dso.global.Platform;
import java.io.File;

public class ReferenceFile {
    private static final String REFERENCE = "reference-wave-%s.bin";
    public static final int RefFile_Normal = 0;
    public static final int RefFile_Math = 1;
    public ReferenceWaveControl rwc;
    public int id;
    public String name;
    public IReferenceWaveForm rwf;

    public ReferenceFile(ReferenceWaveControl referenceWaveControl, int n, String string) {
        this.rwc = referenceWaveControl;
        this.id = n;
        this.name = string;
    }

    public boolean setWaveForm(IReferenceWaveForm iReferenceWaveForm) {
        if (iReferenceWaveForm == null) {
            return false;
        }
        this.rwf = iReferenceWaveForm;
        iReferenceWaveForm.resetRTIntBuf(this.rwc.cm.paintContext.getHcenter(), this.rwc.cm.paintContext.isScreenMode_3());
        iReferenceWaveForm.setObjIndex(this.id);
        return true;
    }

    public boolean loadWaveForm() {
        return this.setWaveForm(this.rwc.cm.loadRefWF(this.getFile()));
    }

    public Character getLetter() {
        return Character.valueOf((char)(this.id + 97));
    }

    public File getFile() {
        return new File(Platform.DATA_DIR, String.format(REFERENCE, this.getLetter()));
    }

    public String toString() {
        return this.getComplexName();
    }

    public void setName(String string) {
        this.name = string;
        this.rwc.invalidate();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public boolean isVisible() {
        return this.rwc.isReferenceVisible(this);
    }

    public void setVisible(boolean bl) {
        this.rwc.setReferenceVisible(this, bl);
    }

    public String getComplexName() {
        if (this.name == null || "".equals(this.name)) {
            return "(" + this.getLetter() + ")";
        }
        return "(" + this.getLetter() + ") " + this.name;
    }
}

