/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function.record;

import com.owon.uppersoft.dso.function.PlayerControl;
import com.owon.uppersoft.dso.function.SoftwareControl;
import com.owon.uppersoft.dso.function.record.OfflineChannelsInfo;
import com.owon.uppersoft.dso.function.record.OpenPropertyChangeEvent;
import com.owon.uppersoft.dso.function.record.Timeline;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.ChannelInverseTranslator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.data.CByteArrayInputStream;
import com.owon.uppersoft.vds.core.data.OfflineInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelDataInfo;
import com.owon.uppersoft.vds.core.wf.rt.LoadMedia;
import com.owon.uppersoft.vds.data.Point;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public class RecordFileIO {
    private static final int recordVer = 4;
    private static ChannelInverseTranslator cit = new ChannelInverseTranslator();

    public static long writeHeader(RandomAccessFile randomAccessFile, ControlManager controlManager) {
        try {
            SoftwareControl softwareControl = controlManager.getSoftwareControl();
            byte[] byArray = softwareControl.getMachineHeader().getBytes("ASCII");
            randomAccessFile.write(byArray);
            randomAccessFile.writeInt(controlManager.getMachineTypeForSave());
            randomAccessFile.writeInt(4);
            randomAccessFile.writeByte(3);
            randomAccessFile.writeByte(0);
            randomAccessFile.writeByte(0);
            randomAccessFile.writeByte(0);
            long l = randomAccessFile.getFilePointer();
            randomAccessFile.writeInt(0);
            randomAccessFile.writeInt(0);
            randomAccessFile.writeInt(0);
            return l;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return -1L;
    }

    public static void writeFrame(RandomAccessFile randomAccessFile, ControlManager controlManager, WaveFormManager waveFormManager, LoadMedia loadMedia, int n) {
        long l = 0L;
        try {
            l = randomAccessFile.getFilePointer();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            randomAccessFile.writeInt(0);
            TimeControl timeControl = controlManager.getTimeControl();
            randomAccessFile.writeInt(timeControl.getTimebaseIdx());
            randomAccessFile.writeInt(timeControl.getHorizontalTriggerPosition());
            randomAccessFile.writeBoolean(controlManager.isPeakDetectWork());
            randomAccessFile.writeInt(controlManager.getDeepMemoryControl().getDeepDataLen());
            Iterator<? extends ChannelDataInfo> iterator = loadMedia.iterator_ChannelDataInfo();
            while (iterator.hasNext()) {
                ChannelDataInfo channelDataInfo = iterator.next();
                WaveForm waveForm = waveFormManager.getWaveForm(channelDataInfo.chl);
                ChannelInfo channelInfo = waveForm.wfi.ci;
                randomAccessFile.write(channelInfo.getNumber());
                long l2 = randomAccessFile.getFilePointer();
                randomAccessFile.writeInt(0);
                randomAccessFile.writeInt(cit.getInverseType_Record(channelInfo.isInverse()));
                int n2 = channelDataInfo.initPos;
                int n3 = channelDataInfo.screendatalen;
                int n4 = channelDataInfo.datalen;
                randomAccessFile.writeInt(0);
                randomAccessFile.writeInt(n3);
                randomAccessFile.writeInt(n3);
                randomAccessFile.writeInt(channelDataInfo.slowMove);
                randomAccessFile.writeInt(channelInfo.getPos0());
                randomAccessFile.writeInt(channelInfo.getVoltbaseIndex());
                randomAccessFile.writeInt(channelInfo.getProbeMultiIdx());
                randomAccessFile.writeFloat(channelInfo.getFreq());
                randomAccessFile.writeFloat(1.0f / channelInfo.getFreq());
                ByteBuffer byteBuffer = waveForm.getNextFrameADCBuffer(n);
                byte[] byArray = null;
                if (byteBuffer == null || (byArray = byteBuffer.array()) == null) {
                    randomAccessFile.seek(l);
                    return;
                }
                int n5 = n3 - byteBuffer.remaining();
                byte[] byArray2 = new byte[n5];
                randomAccessFile.write(byArray2);
                randomAccessFile.write(byArray, byteBuffer.position(), byteBuffer.remaining());
                long l3 = randomAccessFile.getFilePointer();
                randomAccessFile.seek(l2);
                randomAccessFile.writeInt((int)(l3 - l2 - 4L));
                randomAccessFile.seek(l3);
            }
            long l4 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l);
            randomAccessFile.writeInt((int)(l4 - l - 4L));
            randomAccessFile.seek(l4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static int readHeader(CByteArrayInputStream cByteArrayInputStream, PlayerControl playerControl, OfflineChannelsInfo offlineChannelsInfo) {
        int n;
        int n2;
        ControlManager controlManager = Platform.getControlManager();
        int n3 = 10;
        byte[] byArray = new byte[n3];
        cByteArrayInputStream.get(byArray, 0, n3);
        String string = "";
        try {
            string = new String(byArray, 0, n3, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (!string.startsWith("SPBVDS")) {
            return -1;
        }
        offlineChannelsInfo.machine_type = n2 = cByteArrayInputStream.nextInt();
        if (!controlManager.isSuitableMachineType(n2) && (n = controlManager.reloadManager.prepareReloadPlayFile(n2)) < 0) {
            return -1;
        }
        offlineChannelsInfo.record_version = n = cByteArrayInputStream.nextInt();
        if (!offlineChannelsInfo.setMore_Record(cByteArrayInputStream)) {
            return -1;
        }
        int n4 = cByteArrayInputStream.nextInt();
        playerControl.filesize = n4;
        playerControl.setTimegap(cByteArrayInputStream.nextInt());
        playerControl.end = playerControl.counter = cByteArrayInputStream.nextInt();
        int n5 = cByteArrayInputStream.pointer();
        return n5;
    }

    public static void readTimeline(Timeline timeline, CByteArrayInputStream cByteArrayInputStream, PlayerControl playerControl) {
        int n = playerControl.counter;
        if (n == 0) {
            return;
        }
        List<Point> list = timeline.timepoints;
        int n2 = 0;
        int n3 = cByteArrayInputStream.pointer();
        int n4 = cByteArrayInputStream.nextInt();
        cByteArrayInputStream.skip(n4);
        OpenPropertyChangeEvent openPropertyChangeEvent = new OpenPropertyChangeEvent(playerControl, "TimeLineCheck", 0, 0);
        openPropertyChangeEvent.newInt = ++n2;
        playerControl.propertyChange(openPropertyChangeEvent);
        Point point = new Point(n4, 1);
        list.add(point);
        while (n2 < n) {
            n3 = cByteArrayInputStream.pointer();
            n4 = cByteArrayInputStream.nextInt();
            cByteArrayInputStream.skip(n4);
            openPropertyChangeEvent.newInt = ++n2;
            playerControl.propertyChange(openPropertyChangeEvent);
            if (n4 != point.x) {
                point.x += 4;
                point = new Point(n4, 1);
                list.add(point);
                continue;
            }
            ++point.y;
        }
        point.x += 4;
    }

    public static void readFrame(OfflineChannelsInfo offlineChannelsInfo, CByteArrayInputStream cByteArrayInputStream) {
        int n = cByteArrayInputStream.nextInt();
        int n2 = cByteArrayInputStream.pointer();
        offlineChannelsInfo.timebase = cByteArrayInputStream.nextInt();
        offlineChannelsInfo.horTrgPos = cByteArrayInputStream.nextInt();
        offlineChannelsInfo.setPKDetect_Record(cByteArrayInputStream);
        offlineChannelsInfo.setDMDetect_Record(cByteArrayInputStream);
        offlineChannelsInfo.reset('T');
        ChannelDataInfo channelDataInfo = null;
        while (cByteArrayInputStream.pointer() - n2 < n) {
            float f;
            float f2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            byte by = cByteArrayInputStream.nextByte();
            channelDataInfo = offlineChannelsInfo.getInstance();
            channelDataInfo.chl = by;
            int n10 = cByteArrayInputStream.nextInt();
            int n11 = cByteArrayInputStream.pointer();
            channelDataInfo.setInverseType_Record(cByteArrayInputStream, offlineChannelsInfo.record_version);
            channelDataInfo.initPos = n9 = cByteArrayInputStream.nextInt();
            channelDataInfo.screendatalen = n8 = cByteArrayInputStream.nextInt();
            channelDataInfo.datalen = n7 = cByteArrayInputStream.nextInt();
            channelDataInfo.slowMove = n6 = cByteArrayInputStream.nextInt();
            OfflineInfo offlineInfo = channelDataInfo.oi;
            offlineInfo.pos0 = n5 = cByteArrayInputStream.nextInt();
            offlineInfo.vbIdx = n4 = cByteArrayInputStream.nextInt();
            offlineInfo.probeMultiIdx = n3 = cByteArrayInputStream.nextInt();
            offlineInfo.frequency = f2 = cByteArrayInputStream.nextFloat();
            channelDataInfo.setFreq(offlineInfo.frequency);
            offlineInfo.cycle = f = cByteArrayInputStream.nextFloat();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n7);
            byte[] byArray = byteBuffer.array();
            cByteArrayInputStream.get(byArray, byteBuffer.position(), n7);
            channelDataInfo.setUniqueAdcbuf(byteBuffer);
            offlineChannelsInfo.addChannelDataInfo(channelDataInfo);
            offlineChannelsInfo.screendatalen = n8;
            n11 = n10 - (cByteArrayInputStream.pointer() - n11);
            cByteArrayInputStream.skip(n11);
        }
        offlineChannelsInfo.setDataComplete(1);
        if (channelDataInfo != null) {
            offlineChannelsInfo.slowMove = channelDataInfo.slowMove;
        }
    }
}

