/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function.perspective;

import com.owon.uppersoft.dso.function.DisplayControl;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.util.ui.LineUtil;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.IView;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.paint.Background;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.util.format.SFormatter;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.util.ResourceBundle;

public class XYView
implements IView,
Localizable {
    private WaveFormManager wfm;
    private Background bg;
    private DisplayControl dc;
    private String xychlLack;
    private byte[] array1;
    private byte[] array2;
    private int p1;
    private int l1;
    private int p2;
    private int l2;
    private int wc;
    private int hc;
    private boolean is3in1;

    public XYView(WaveFormManager waveFormManager, DisplayControl displayControl) {
        this.wfm = waveFormManager;
        this.dc = displayControl;
        this.bg = new Background();
        this.bg.setXunitlen(5);
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.xychlLack = resourceBundle.getString("Label.XYModeChannelLack");
    }

    @Override
    public void adjustView(ScreenContext screenContext, Rectangle rectangle) {
        this.is3in1 = screenContext.isScreenMode_3();
        this.bg.adjustView(rectangle, this.is3in1);
        this.wc = rectangle.x + (rectangle.width >> 1);
        this.hc = rectangle.y + (rectangle.height >> 1);
        int n = this.is3in1 ? 5 : 10;
        this.bg.setXunitlen(n);
        this.bg.setYunitlen(n);
    }

    public boolean isOn() {
        return this.dc.isXYModeOn();
    }

    @Override
    public void paintView(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        graphics2D.scale(DataHouse.xRate, DataHouse.yRate);
        this.bg.paintView(graphics2D, screenContext);
        if (!this.dc.isXYModeOn()) {
            return;
        }
        String string = this.wfm.getClosedChannelName(this.dc.wfx, this.dc.wfy);
        if (string.length() != 0) {
            string = SFormatter.UIformat(this.xychlLack, string);
            LineUtil.paintPrompt(graphics2D, this.wc, this.hc, this.dc.xycolor, string);
            return;
        }
        WaveForm waveForm = this.wfm.getCHX();
        WaveForm waveForm2 = this.wfm.getCHY();
        ByteBuffer byteBuffer = waveForm.getADC_Buffer();
        ByteBuffer byteBuffer2 = waveForm2.getADC_Buffer();
        if (byteBuffer == null || byteBuffer2 == null) {
            return;
        }
        this.array1 = byteBuffer.array();
        this.p1 = byteBuffer.position();
        this.l1 = byteBuffer.limit();
        this.array2 = byteBuffer2.array();
        this.p2 = byteBuffer2.position();
        this.l2 = byteBuffer2.limit();
        if (this.l1 - this.p1 != this.l2 - this.p2) {
            return;
        }
        graphics2D.setClip(rectangle);
        graphics2D.setColor(this.dc.xycolor);
        if (this.is3in1) {
            while (this.p1 < this.l1) {
                int n = this.wc + this.array1[this.p1];
                int n2 = this.hc - this.array2[this.p2];
                graphics2D.drawLine(n, n2, n, n2);
                ++this.p1;
                ++this.p2;
            }
        } else {
            graphics2D.setStroke(new BasicStroke(2.0f));
            while (this.p1 < this.l1) {
                int n = this.wc + (this.array1[this.p1] << 1);
                int n3 = this.hc - (this.array2[this.p2] << 1);
                graphics2D.drawLine(n, n3, n, n3);
                ++this.p1;
                ++this.p2;
            }
        }
    }
}

