/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function.perspective;

import com.owon.uppersoft.dso.function.Markable;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WFTimeScopeControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.ref.IRefSource;
import com.owon.uppersoft.dso.util.ui.LineUtil;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.IView;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.core.aspect.help.WF;
import com.owon.uppersoft.vds.core.control.MathControl;
import com.owon.uppersoft.vds.core.measure.MeasureADC;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class CompositeWaveForm
implements IView,
IRefSource,
Markable {
    public static final int CompositeWaveFormIndex = Integer.MAX_VALUE;
    public boolean linkline = true;
    private MathControl mc;
    private WaveFormManager wfm;
    private VoltageProvider vp;
    private ControlManager cm;
    private MeasureADC madc;
    private IntBuffer pixbuf;
    private IntBuffer adcbuf;
    public boolean onShowPos0;
    private int yloc;
    final int Max = 125;
    final int Min = -125;

    public static void main(String[] stringArray) {
        Fraction fraction = new Fraction(0.22, 11.0);
        System.out.println(fraction.scale);
        System.out.println(fraction.getScaledValue(100));
    }

    public CompositeWaveForm(WaveFormManager waveFormManager, MathControl mathControl, VoltageProvider voltageProvider, ControlManager controlManager) {
        this.wfm = waveFormManager;
        this.mc = mathControl;
        this.vp = voltageProvider;
        this.cm = controlManager;
        this.madc = new MeasureADC();
    }

    public IntBuffer getADC_Buffer() {
        return this.adcbuf;
    }

    public boolean isADCBeyondMax() {
        return this.wfm.getM1().isADCBeyondMax() || this.wfm.getM2().isADCBeyondMax();
    }

    public boolean isADCBeyondMin() {
        return this.wfm.getM1().isADCBeyondMin() || this.wfm.getM2().isADCBeyondMin();
    }

    public MeasureADC getMeasureADC() {
        return this.madc;
    }

    public void receiveNewData(ScreenContext screenContext, int n) {
        if (this.mc.isInclude(n)) {
            this.receiveNewData(screenContext);
        }
    }

    public String toString() {
        return "M";
    }

    @Override
    public int getPos0() {
        return this.getYloc();
    }

    @Override
    public int getNumber() {
        return this.cm.getAllChannelsNumber();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public double getVoltValue() {
        int n = this.mc.getMathvbidx();
        return this.mc.dbMathVoltage[n];
    }

    @Override
    public String getValueLabel(double d) {
        return this.mc.getLabel_mV(d);
    }

    @Override
    public int getProbeMultiIdx() {
        return 0;
    }

    @Override
    public int getVoltbaseIndex() {
        return this.mc.getMathvbidx();
    }

    @Override
    public int getWaveType() {
        return 1;
    }

    @Override
    public boolean isOn() {
        return this.mc.mathon;
    }

    public Color getColor() {
        return this.mc.color;
    }

    public void paintItem(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle, ControlManager controlManager, boolean bl) {
        if (!this.isOn()) {
            return;
        }
        graphics2D.setColor(this.mc.color);
        int n = this.getPos0onChart(screenContext);
        int n2 = rectangle.y;
        int n3 = rectangle.y + rectangle.height;
        LineUtil.paintChannelLabel(n, n2, n3, graphics2D, "M", 1, bl);
        if (this.onShowPos0) {
            LineUtil.paintOnShowPos0(graphics2D, screenContext, Platform.getDataHouse().divUnits, this.getYloc(), n, rectangle);
        }
    }

    public void receiveNewData(ScreenContext screenContext) {
        if (!this.mc.mathon) {
            this.pixbuf = null;
            this.adcbuf = null;
            return;
        }
        this.resetIntBuf(screenContext);
    }

    Fraction getMultiply_0(WF wF, int n, int n2) {
        Fraction fraction = new Fraction(1, 1);
        int n3 = wF.getProbeMultiIdx();
        int[] nArray = this.vp.getVoltages(n3);
        int n4 = this.cm.getMachineInfo().ProbeMulties[n3];
        int n5 = this.cm.getMachineInfo().ProbeMulties[this.mc.probeIndex];
        if (n == n2) {
            fraction.b = 1;
            fraction.a = 1;
        } else {
            int n6 = nArray[n2];
            int n7 = nArray[n];
            while (n6 % 10 == 0 && n7 % 10 == 0) {
                n6 /= 10;
                n7 /= 10;
            }
            fraction.b = n6;
            fraction.a = n7;
        }
        fraction.b *= n5;
        fraction.a *= n4;
        return fraction;
    }

    Fraction getMultiply_1(WF wF, int n, int n2) {
        int n3 = wF.getProbeMultiIdx();
        int[] nArray = this.vp.getVoltages(n3);
        double[] dArray = this.mc.dbMathVoltage;
        int n4 = nArray[n];
        double d = dArray[n2];
        Fraction fraction = new Fraction((double)n4, d);
        return fraction;
    }

    public void setYlocIncrement(int n, boolean bl, int n2) {
        this.yloc = n;
        this.resetIntBuf(bl, n2);
    }

    public void resetYloc() {
        this.yloc = 0;
    }

    public int getYloc() {
        return this.yloc;
    }

    public int getPos0onChart(ScreenContext screenContext) {
        return this.getPos0onChart(screenContext.isScreenMode_3(), screenContext.getHcenter());
    }

    public int getPos0onChart(boolean bl, int n) {
        if (bl) {
            return n - this.yloc;
        }
        return n - (this.yloc << 1);
    }

    private void complexCompute(WF wF, WF wF2, boolean bl, int n) {
        int n2;
        int n3;
        int n4 = this.mc.getMathvbidx();
        int n5 = wF.getVoltbaseIndex();
        int n6 = wF2.getVoltbaseIndex();
        Fraction fraction = this.getMultiply_1(wF, n5, n4);
        Fraction fraction2 = this.getMultiply_1(wF2, n6, n4);
        int[] nArray = this.pixbuf.array();
        int[] nArray2 = this.adcbuf.array();
        ByteBuffer byteBuffer = wF.getADC_Buffer();
        ByteBuffer byteBuffer2 = wF2.getADC_Buffer();
        if (byteBuffer == null || byteBuffer2 == null) {
            return;
        }
        byte[] byArray = byteBuffer.array();
        byte[] byArray2 = byteBuffer2.array();
        int n7 = byteBuffer.position();
        int n8 = byteBuffer.limit();
        int n9 = byteBuffer2.position();
        int n10 = this.getPos0onChart(bl, n);
        if (this.cm.isRuntime()) {
            n3 = wF.getPos0ForADC();
            n2 = wF2.getPos0ForADC();
        } else {
            n3 = wF.getFirstLoadPos0();
            n2 = wF2.getFirstLoadPos0();
        }
        boolean bl2 = bl;
        int n11 = n8 - n7;
        int n12 = 0;
        switch (this.wfm.getMathOperation()) {
            case 0: {
                if (bl2) {
                    while (n7 < n8) {
                        double d = fraction.getScaledValue(byArray[n7++] - n3) + fraction2.getScaledValue(byArray2[n9++] - n2);
                        d = this.restrict_max_min_yb(d);
                        nArray2[n12] = (int)d;
                        nArray[n12] = n10 - (int)d;
                        ++n12;
                    }
                } else {
                    while (n7 < n8) {
                        double d = fraction.getScaledValue(byArray[n7++] - n3) + fraction2.getScaledValue(byArray2[n9++] - n2);
                        d = this.restrict_max_min_yb(d);
                        nArray2[n12] = (int)d;
                        nArray[n12] = n10 - ((int)d << 1);
                        ++n12;
                    }
                }
                break;
            }
            case 1: {
                if (bl2) {
                    while (n7 < n8) {
                        double d = fraction.getScaledValue(byArray[n7++] - n3) - fraction2.getScaledValue(byArray2[n9++] - n2);
                        d = this.restrict_max_min_yb(d);
                        nArray2[n12] = (int)d;
                        nArray[n12] = n10 - (int)d;
                        ++n12;
                    }
                } else {
                    while (n7 < n8) {
                        double d = fraction.getScaledValue(byArray[n7++] - n3) - fraction2.getScaledValue(byArray2[n9++] - n2);
                        d = this.restrict_max_min_yb(d);
                        nArray2[n12] = (int)d;
                        nArray[n12] = n10 - ((int)d << 1);
                        ++n12;
                    }
                }
                break;
            }
            case 2: {
                if (bl2) {
                    while (n7 < n8) {
                        double d = fraction.getScaledValue(byArray[n7++] - n3) * fraction2.getScaledValue(byArray2[n9++] - n2);
                        d = this.restrict_max_min_yb(d);
                        nArray2[n12] = (int)d;
                        nArray[n12] = n10 - (int)d;
                        ++n12;
                    }
                } else {
                    while (n7 < n8) {
                        double d = fraction.getScaledValue(byArray[n7++] - n3) * fraction2.getScaledValue(byArray2[n9++] - n2);
                        d = this.restrict_max_min_yb(d);
                        nArray2[n12] = (int)d;
                        nArray[n12] = n10 - ((int)d << 1);
                        ++n12;
                    }
                }
                break;
            }
            case 3: {
                if (bl2) {
                    while (n7 < n8) {
                        double d;
                        if ((d = fraction2.getScaledValue(byArray2[n9++] - n2)) == 0.0) {
                            nArray2[n12] = 0;
                            nArray[n12] = n10;
                        } else {
                            double d2 = fraction.getScaledValue(byArray[n7] - n3) / d;
                            d2 = this.restrict_max_min_yb(d2);
                            nArray2[n12] = (int)d2;
                            nArray[n12] = n10 - (int)d2;
                        }
                        ++n7;
                        ++n12;
                    }
                } else {
                    while (n7 < n8) {
                        double d;
                        if ((d = fraction2.getScaledValue(byArray2[n9++] - n2)) == 0.0) {
                            nArray2[n12] = 0;
                            nArray[n12] = n10;
                        } else {
                            double d3 = fraction.getScaledValue(byArray[n7] - n3) / d;
                            d3 = this.restrict_max_min_yb(d3);
                            nArray2[n12] = (int)d3;
                            nArray[n12] = n10 - ((int)d3 << 1);
                        }
                        ++n7;
                        ++n12;
                    }
                }
                break;
            }
        }
        this.pixbuf.position(0);
        this.pixbuf.limit(n11);
        this.adcbuf.position(0);
        this.adcbuf.limit(n11);
    }

    private double restrict_max_min_yb(double d) {
        double d2 = (double)this.yloc + d;
        d2 = this.restrict_max_min(d2);
        return d2 - (double)this.yloc;
    }

    private double restrict_max_min(double d) {
        if (d < -125.0) {
            d = -125.0;
        } else if (d > 125.0) {
            d = 125.0;
        }
        return d;
    }

    @Override
    public IntBuffer save2RefIntBuffer() {
        int[] nArray = this.adcbuf.array();
        int n = this.adcbuf.limit();
        int n2 = this.adcbuf.position();
        IntBuffer intBuffer = IntBuffer.allocate(n - n2);
        int[] nArray2 = intBuffer.array();
        int n3 = 0;
        int n4 = n2;
        while (n4 < n) {
            nArray2[n3] = this.yloc + nArray[n4];
            ++n4;
            ++n3;
        }
        intBuffer.limit(n3);
        intBuffer.position(0);
        return intBuffer;
    }

    public void resetIntBuf(ScreenContext screenContext) {
        this.resetIntBuf(screenContext.isScreenMode_3(), screenContext.getHcenter());
    }

    public void prepare() {
        if (this.pixbuf == null) {
            this.pixbuf = IntBuffer.allocate(5000);
        }
        if (this.adcbuf == null) {
            this.adcbuf = IntBuffer.allocate(5000);
        }
    }

    public void resetIntBuf(boolean bl, int n) {
        this.prepare();
        WaveForm waveForm = this.wfm.getM1();
        WaveForm waveForm2 = this.wfm.getM2();
        int n2 = waveForm.getVoltbaseIndex();
        int n3 = waveForm2.getVoltbaseIndex();
        this.mc.updateMathVbIdx(waveForm, waveForm2);
        this.complexCompute(waveForm, waveForm2, bl, n);
    }

    @Override
    public void adjustView(ScreenContext screenContext, Rectangle rectangle) {
        if (!this.mc.mathon) {
            return;
        }
        if (!screenContext.allowLazyRepaint()) {
            this.resetIntBuf(screenContext);
        }
    }

    @Override
    public void paintView(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        if (!this.wfm.isM1M2Support() || !this.mc.mathon) {
            return;
        }
        if (this.pixbuf == null) {
            return;
        }
        graphics2D.setColor(this.mc.color);
        int n = rectangle.x;
        boolean bl = this.wfm.getDataHouse().isLineLink();
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(rectangle);
        WFTimeScopeControl wFTimeScopeControl = this.wfm.getWFTimeScopeControl();
        boolean bl2 = wFTimeScopeControl.isPK_Detect();
        int n2 = wFTimeScopeControl.getDrawMode();
        n = wFTimeScopeControl.computeXoffset(n, n2);
        screenContext.getIPaintOne().paintONE(graphics2D, n2, n, bl, rectangle.y, rectangle.height, bl2, wFTimeScopeControl, this.pixbuf, wFTimeScopeControl.getPK_detect_type());
        graphics2D.setClip(shape);
    }

    static class Fraction {
        public int a;
        public int b;
        public double scale = 1.0;

        public Fraction() {
            this(-1, -1);
        }

        public Fraction(int n, int n2) {
            this.a = n;
            this.b = n2;
        }

        public Fraction(double d, double d2) {
            this.scale = d / d2;
        }

        public void set(int n, int n2) {
            this.a = n;
            this.b = n2;
        }

        public String toString() {
            return this.a + "/" + this.b;
        }

        public double getScaledValue(int n) {
            double d = (double)n * this.scale;
            return d;
        }
    }
}

