/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function.measure;

import com.owon.uppersoft.dso.function.measure.MeasureManager;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.pane.dock.widget.TitleBar;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.measure.MeasureElem;
import com.owon.uppersoft.vds.core.measure.MeasureT;
import com.owon.uppersoft.vds.core.measure.VR;
import com.owon.uppersoft.vds.ui.layout.OneColumnLayout;
import com.owon.uppersoft.vds.ui.layout.OneRowLayout;
import com.owon.uppersoft.vds.ui.paint.LineDrawTool;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import com.owon.uppersoft.vds.ui.widget.custom.LButton;
import com.owon.uppersoft.vds.ui.window.ComponentMover;
import com.owon.uppersoft.vds.ui.window.WindowUtil;
import com.owon.uppersoft.vds.util.LocalizeCenter;
import com.owon.uppersoft.vds.util.format.SFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MeasureSnapshot
implements Localizable {
    private static final int arcOut = 15;
    private static final int arcIn = 14;
    private static MeasureSnapshot instance;
    private MainWindow mw;
    private JDialog frame;
    private CLabel lab;
    private static final String MsgKeyPrefix = "AutoMeasure.";
    private static final String LabStr = "CH";
    private final int MeaTHorEndIdx = 7;
    private JLabel[] chLabels;
    private JLabel[] othLabels;
    private String[] chPageItems;
    private VR[] vrs;
    private LinkedList<MeasureElem> OthMTlinked;
    private int SnapshotCH;
    private ControlManager cm;

    public static void closeMeasureSnapshot() {
        if (instance != null) {
            instance.close();
            instance = null;
        }
    }

    public static void handleSnapshot(LocalizeCenter localizeCenter, int n, CComboBox cComboBox, ControlManager controlManager) {
        MeasureSnapshot.closeMeasureSnapshot();
        if (n > 0) {
            instance = new MeasureSnapshot(controlManager, cComboBox, n);
            localizeCenter.addLocalizable(instance);
        }
    }

    public JDialog getSnapshotFrame() {
        return this.frame;
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public CLabel getShowCurLab() {
        return this.lab;
    }

    public MeasureSnapshot(ControlManager controlManager, CComboBox cComboBox, int n) {
        this.cm = controlManager;
        this.SnapshotCH = n;
        this.mw = Platform.getMainWindow();
        this.preUpdateMeasure();
        this.initialize(controlManager, cComboBox);
        new ComponentMover(this.frame, this.frame);
        this.frame.setUndecorated(true);
        this.frame.setResizable(false);
        this.localize(I18nProvider.bundle());
        this.frame.setVisible(true);
    }

    private void preUpdateMeasure() {
        int n;
        WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
        this.vrs = waveFormManager.isMath(n = this.SnapshotCH - 1) ? waveFormManager.getCompositeWaveForm().getMeasureADC().vrs : waveFormManager.getWaveForm((int)n).getMeasureADC().vrs;
        this.OthMTlinked = this.cm.measMod.othMTlinked;
        MeasureManager measureManager = this.cm.getMeasureManager();
        boolean bl = measureManager.ison();
        measureManager.setMeasureOn(true);
        this.cm.measure(waveFormManager);
        measureManager.setMeasureOn(bl);
    }

    private void initialize(ControlManager controlManager, final CComboBox cComboBox) {
        ResourceBundle resourceBundle = I18nProvider.bundle();
        JFrame jFrame = this.mw.getFrame();
        this.frame = new JDialog(jFrame);
        this.frame.setFocusableWindowState(false);
        this.frame.setTitle(resourceBundle.getString("M.Measure.SnapshotTitle"));
        this.frame.setType(Window.Type.UTILITY);
        this.mw.getFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                MeasureSnapshot.this.close();
            }
        });
        JPanel jPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Define.def.CO_DockBorder);
                graphics2D.setStroke(Define.def.Stroke2);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawRoundRect(1, 1, n - 3, n2 - 3, 15, 15);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        };
        jPanel.setLayout(new BorderLayout(0, 0));
        this.frame.setContentPane(jPanel);
        this.frame.setUndecorated(true);
        this.frame.setDefaultCloseOperation(2);
        JPanel jPanel2 = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(TitleBar.GradientTexturePaint);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.fillRoundRect(2, 2, n - 4, n2 + 14, 14, 14);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        };
        jPanel2.setLayout(new OneRowLayout(new Insets(5, 15, 5, 10), 0));
        new ComponentMover(this.frame, jPanel2);
        this.lab = new CLabel();
        this.lab.setPreferredSize(new Dimension(491, 30));
        jPanel2.add(this.lab);
        ImageIcon imageIcon = SwingResourceManager.getIcon(MeasureSnapshot.class, "/com/owon/uppersoft/dso/image/close.png");
        LButton lButton = new LButton();
        lButton.setIcon(imageIcon);
        lButton.setPressedIcon(LineDrawTool.getRolloverIcon(imageIcon));
        lButton.setPreferredSize(new Dimension(24, 24));
        lButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureSnapshot.this.close();
                cComboBox.setSelectedIndex(0);
            }
        });
        jPanel2.add(lButton);
        JPanel jPanel3 = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Define.def.style.CO_DockContainer);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.fillRoundRect(2, -14, n - 4, n2 + 14 - 2, 14, 14);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        };
        jPanel3.setLayout(new OneColumnLayout(new Insets(20, 30, 20, 10), 10));
        this.chLabels = new JLabel[MeasureT.VALUES.length];
        this.chPageItems = new String[MeasureT.VALUES.length];
        Dimension dimension = new Dimension(250, 30);
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.setLayout(new FlowLayout(0, 0, 0));
        jPanel4.setPreferredSize(new Dimension(500, 120));
        JPanel jPanel5 = new JPanel();
        jPanel5.setOpaque(false);
        jPanel5.setLayout(new FlowLayout(0, 0, 0));
        jPanel5.setPreferredSize(new Dimension(500, 150));
        int n = 0;
        for (MeasureT measureT : MeasureT.VALUES) {
            String string = measureT.toString();
            this.chPageItems[n] = MsgKeyPrefix + string;
            this.chLabels[n] = new JLabel();
            this.chLabels[n].setPreferredSize(dimension);
            this.chLabels[n].setBackground(Color.GRAY);
            this.chLabels[n].setForeground(Color.WHITE);
            if (n <= 7) {
                jPanel4.add(this.chLabels[n]);
            } else {
                jPanel5.add(this.chLabels[n]);
            }
            ++n;
        }
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel5);
        if (controlManager.getSupportChannelsNumber() >= 2) {
            JPanel jPanel6 = new JPanel();
            jPanel6.setOpaque(false);
            jPanel6.setPreferredSize(new Dimension(420, 60));
            jPanel6.setLayout(new FlowLayout(0, 0, 0));
            int n2 = controlManager.measMod.getOthLinkedCount();
            this.othLabels = new JLabel[n2];
            for (int i = 0; i < n2; ++i) {
                this.othLabels[i] = new JLabel();
                this.othLabels[i].setPreferredSize(dimension);
                this.othLabels[i].setBackground(Color.GRAY);
                this.othLabels[i].setForeground(Color.WHITE);
                jPanel6.add(this.othLabels[i]);
            }
            jPanel3.add(jPanel6);
        }
        this.lab.setText(LabStr + this.SnapshotCH);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        this.frame.setSize(540, 430);
        this.frame.setLocationRelativeTo(jFrame);
        WindowUtil.cutCorners(this.frame, 15);
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        if (this.frame == null) {
            return;
        }
        if (this.SnapshotCH - 1 >= this.cm.getSupportChannelsNumber()) {
            this.lab.setText(resourceBundle.getString("M.Math.Name"));
        } else {
            this.lab.setText(LabStr + this.SnapshotCH);
        }
        this.frame.setTitle(resourceBundle.getString("M.Measure.SnapshotTitle"));
        Font font = Define.def.snapshotfont_en;
        if (this.cm.isChineseLocale()) {
            font = Define.def.snapshotfont;
        }
        for (int i = 0; i < this.chLabels.length; ++i) {
            String string = resourceBundle.getString(this.chPageItems[i]);
            string = SFormatter.getRestrictSubString(string, 12);
            this.chLabels[i].setText(string + " = " + this.vrs[i].vu);
            this.chLabels[i].setFont(font);
        }
        LinkedList<MeasureElem> linkedList = this.cm.measMod.othMTlinked;
        if (this.othLabels != null) {
            for (int i = 0; i < this.othLabels.length; ++i) {
                String string = resourceBundle.getString(((MeasureElem)linkedList.get((int)i)).label);
                string = SFormatter.getRestrictSubString(string, 14);
                this.othLabels[i].setText(string + " = " + this.OthMTlinked.get((int)i).vu);
                this.othLabels[i].setFont(font);
            }
        }
    }

    public void close() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
            instance = null;
        }
    }
}

