/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function.measure;

import com.owon.uppersoft.dso.function.measure.MeasureWFSupport;
import com.owon.uppersoft.dso.function.measure.TimePerPointProvider;
import com.owon.uppersoft.dso.function.perspective.CompositeWaveForm;
import com.owon.uppersoft.dso.model.trigger.TriggerInfoForChannel;
import com.owon.uppersoft.dso.wf.ON_WF_Iterator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.IView;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.core.aspect.help.IWF;
import com.owon.uppersoft.vds.core.measure.MeasureADC;
import com.owon.uppersoft.vds.core.measure.MeasureElem;
import com.owon.uppersoft.vds.core.measure.MeasureModel;
import com.owon.uppersoft.vds.core.measure.MeasureT;
import com.owon.uppersoft.vds.core.measure.MeasureUtil;
import com.owon.uppersoft.vds.core.measure.VR;
import com.owon.uppersoft.vds.core.measure.VerticalValueMeasure;
import java.beans.PropertyChangeSupport;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.LinkedList;

public class MeasureManager {
    public static final String RefreshMeasureResult = "RefreshMeasureResult";
    private boolean on = false;
    private PropertyChangeSupport pcs;
    private MeasureModel model;

    public MeasureManager(PropertyChangeSupport propertyChangeSupport, MeasureModel measureModel) {
        this.pcs = propertyChangeSupport;
        this.model = measureModel;
        this.setMeasureOn(measureModel.enforcePermit());
    }

    public void fire_RefreshMeasureResult() {
        this.pcs.firePropertyChange(RefreshMeasureResult, null, null);
    }

    protected int precust(ON_WF_Iterator oN_WF_Iterator) {
        int n = 0;
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            VR[] vRArray = waveForm.getMeasureADC().vrs;
            vRArray[MeasureT.AVERage.idx].on = true;
            if (waveForm.getADC_Buffer() == null) {
                System.err.println("wf.getADC_Buffer() is null");
                return -1;
            }
            n = waveForm.getADC_Buffer().remaining();
        }
        return n;
    }

    public void setMeasureOn_enforce() {
        boolean bl = this.model.enforcePermit();
        this.setMeasureOn(bl);
        this.pcs.firePropertyChange("refresh_MeasurePane_Selected", null, null);
    }

    public void setMeasureOn(boolean bl) {
        if (bl != this.on) {
            this.on = bl;
        }
        this.fire_RefreshMeasureResult();
    }

    public boolean ison() {
        return this.on;
    }

    public void measure(MeasureWFSupport measureWFSupport, TriggerInfoForChannel triggerInfoForChannel, double d, boolean bl, VoltageProvider voltageProvider, MeasureModel measureModel, int n, TimePerPointProvider timePerPointProvider) {
        MeasureElem measureElem;
        IWF iWF;
        IWF iWF2;
        IView iView;
        if (!this.on) {
            return;
        }
        ON_WF_Iterator oN_WF_Iterator = measureWFSupport.on_wf_Iterator();
        int n2 = this.precust(oN_WF_Iterator);
        if (n2 < 0) {
            return;
        }
        double d2 = timePerPointProvider.getTimePerPoint(n2);
        oN_WF_Iterator.reset();
        while (oN_WF_Iterator.hasNext()) {
            iView = oN_WF_Iterator.next();
            if (!iView.isOn() || iView.getADC_Buffer() == null) continue;
            int n3 = iView.getChannelNumber();
            this.prepareArray((IWF)((Object)iView));
            this.doWaveFormMeasure((IWF)((Object)iView), triggerInfoForChannel.isChannelVideoTrg(n3), d, d2, voltageProvider);
        }
        iView = measureWFSupport.getCompositeWaveForm();
        if (((CompositeWaveForm)iView).isOn()) {
            this.prepareArray((CompositeWaveForm)iView);
            this.doWaveFormMeasure((CompositeWaveForm)iView, d, d2, voltageProvider);
        }
        int[] nArray = new int[]{-1, -1};
        int[] nArray2 = new int[]{-1, -1};
        LinkedList<MeasureElem> linkedList = measureModel.othMTlinked;
        Iterator iterator = linkedList.iterator();
        if (n >= 2) {
            iWF2 = measureWFSupport.getWaveForm(0);
            iWF = measureWFSupport.getWaveForm(1);
            if (iWF2.isOn() && iWF.isOn()) {
                nArray = this.doDelayMeasure(iWF2, iWF);
                measureElem = (MeasureElem)iterator.next();
                this.setDelayValue(measureElem, nArray[0], d2, bl);
                measureElem = (MeasureElem)iterator.next();
                this.setDelayValue(measureElem, nArray[1], d2, bl);
            }
        }
        if (n >= 4) {
            iWF2 = measureWFSupport.getWaveForm(2);
            iWF = measureWFSupport.getWaveForm(3);
            if (iWF2.isOn() && iWF.isOn()) {
                nArray2 = this.doDelayMeasure(iWF2, iWF);
                measureElem = (MeasureElem)iterator.next();
                this.setDelayValue(measureElem, nArray2[0], d2, bl);
                measureElem = (MeasureElem)iterator.next();
                this.setDelayValue(measureElem, nArray2[1], d2, bl);
            }
        }
        this.fire_RefreshMeasureResult();
    }

    private void setDelayValue(MeasureElem measureElem, int n, double d, boolean bl) {
        if (n < 0) {
            measureElem.setDelayValue(-1.0);
        } else if (bl) {
            measureElem.setDelayValue(-1.0);
        } else {
            measureElem.setDelayValue((double)n * d);
        }
    }

    public int[] doDelayMeasure(IWF iWF, IWF iWF2) {
        MeasureADC measureADC = iWF.getMeasureADC();
        MeasureADC measureADC2 = iWF2.getMeasureADC();
        int n = -1;
        int n2 = -1;
        ByteBuffer byteBuffer = iWF2.getADC_Buffer();
        if (byteBuffer == null) {
            int[] nArray = new int[]{n, n2};
            return nArray;
        }
        VerticalValueMeasure verticalValueMeasure = measureADC2.vvc;
        int n3 = measureADC2.l;
        int[] nArray = measureADC2.array;
        double d = verticalValueMeasure.Vamp / 10 + verticalValueMeasure.Vbase;
        double d2 = verticalValueMeasure.Vamp * 9 / 10 + verticalValueMeasure.Vbase;
        if (iWF.isOn() && iWF2.isOn()) {
            if (-1.0f != measureADC.raiseTime && -1.0f != measureADC2.raiseTime) {
                n = MeasureUtil.get_delayPOS_PD_searchEdge(measureADC.raiseStart, 1, d, d2, nArray, n3);
            } else {
                n2 = -1;
                n = -1;
            }
            if (-1.0f != measureADC.fallTime && -1.0f != measureADC2.fallTime) {
                n2 = MeasureUtil.get_delayPOS_ND_searchEdge(measureADC.fallStart, 0, d, d2, nArray, n3);
            } else {
                n2 = -1;
                n = -1;
            }
        } else {
            n2 = -1;
            n = -1;
        }
        int[] nArray2 = new int[]{n, n2};
        return nArray2;
    }

    private void prepareArray(IWF iWF) {
        int n;
        ByteBuffer byteBuffer = iWF.getADC_Buffer();
        MeasureADC measureADC = iWF.getMeasureADC();
        byte[] byArray = byteBuffer.array();
        int n2 = iWF.getFirstLoadPos0();
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        int[] nArray = measureADC.array;
        measureADC.p = n = 0;
        int n5 = n3;
        while (n5 < n4) {
            nArray[n] = byArray[n5] - n2;
            ++n5;
            ++n;
        }
        measureADC.l = n;
    }

    private void prepareArray(CompositeWaveForm compositeWaveForm) {
        IntBuffer intBuffer = compositeWaveForm.getADC_Buffer();
        MeasureADC measureADC = compositeWaveForm.getMeasureADC();
        measureADC.array = intBuffer.array();
        measureADC.p = intBuffer.position();
        measureADC.l = intBuffer.limit();
    }

    protected void doWaveFormMeasure(IWF iWF, boolean bl, double d, double d2, VoltageProvider voltageProvider) {
        MeasureADC measureADC = iWF.getMeasureADC();
        VR[] vRArray = measureADC.vrs;
        measureADC.doVerticalMeasure(iWF, bl, d, voltageProvider);
        this.doHorizontalMeasure(measureADC, vRArray, bl, d, d2);
    }

    protected void doWaveFormMeasure(CompositeWaveForm compositeWaveForm, double d, double d2, VoltageProvider voltageProvider) {
        MeasureADC measureADC = compositeWaveForm.getMeasureADC();
        VR[] vRArray = measureADC.vrs;
        measureADC.doVerticalMeasure(compositeWaveForm, d, voltageProvider);
        this.doHorizontalMeasure(measureADC, vRArray, false, d, d2);
    }

    protected void doHorizontalMeasure(MeasureADC measureADC, VR[] vRArray, boolean bl, double d, double d2) {
        float f;
        float f2;
        VerticalValueMeasure verticalValueMeasure = measureADC.vvc;
        int n = measureADC.l;
        int n2 = measureADC.p;
        int[] nArray = measureADC.array;
        int n3 = verticalValueMeasure.Vbase;
        int n4 = verticalValueMeasure.Vamp;
        int n5 = n - n2;
        double d3 = verticalValueMeasure.Vavg;
        int n6 = verticalValueMeasure.Vmax + verticalValueMeasure.Vmin >> 1;
        int n7 = Math.abs((double)verticalValueMeasure.Vmax - d3) >= Math.abs((double)verticalValueMeasure.Vmin - d3) ? verticalValueMeasure.VmaxPos % 4 : verticalValueMeasure.VminPos % 4;
        float f3 = this.computePeroid(n7, n6, n5, nArray, n);
        this.getRiseFallTime(measureADC);
        float f4 = (float)n4 / 2.0f + (float)n3;
        float f5 = f4 - 5.0f;
        float f6 = f4 + 5.0f;
        for (int i = n2; i < n; ++i) {
            int n8 = nArray[i];
            if (f5 > (float)n8) {
                this.getFirstPwidth(i, f4, f6, f5, measureADC, n2, n, nArray);
                break;
            }
            measureADC.pWidth = -1.0f;
            if (f6 < (float)n8) {
                this.getFirstNwidth(i, f4, f6, f5, measureADC, n2, n, nArray);
                break;
            }
            measureADC.nWidth = -1.0f;
        }
        if (measureADC.pWidth == -1.0f || measureADC.nWidth == -1.0f) {
            f2 = -1.0f;
            f = -1.0f;
        } else {
            f = measureADC.pWidth / (measureADC.pWidth + measureADC.nWidth);
            f2 = measureADC.nWidth / (measureADC.pWidth + measureADC.nWidth);
        }
        f5 = n4 / 10 + n3;
        f6 = n4 * 9 / 10 + n3;
        boolean bl2 = false;
        VR.setHorizontalValue(vRArray, MeasureT.PERiod, (double)f3 * d2, bl2, bl, d);
        VR.setHorizontalValue(vRArray, MeasureT.FREQuency, 1.0 / vRArray[MeasureT.PERiod.idx].v, bl2, bl, d);
        VR.setRise_FallTimeValue(vRArray, MeasureT.RTime, (double)measureADC.raiseTime * d2, bl2, measureADC.raiseFlag, bl);
        VR.setRise_FallTimeValue(vRArray, MeasureT.FTime, (double)measureADC.fallTime * d2, bl2, measureADC.fallFlag, bl);
        VR.setHorizontalValue(vRArray, MeasureT.PWIDth, (double)measureADC.pWidth * d2, bl2, bl, d);
        VR.setHorizontalValue(vRArray, MeasureT.NWIDth, (double)measureADC.nWidth * d2, bl2, bl, d);
        VR.setHorizontalValue(vRArray, MeasureT.PDUTy, f, bl2, bl, d);
        VR.setHorizontalValue(vRArray, MeasureT.NDUTy, f2, bl2, bl, d);
    }

    protected void hV(IWF iWF) {
        MeasureADC measureADC = iWF.getMeasureADC();
        VerticalValueMeasure verticalValueMeasure = measureADC.vvc;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        verticalValueMeasure.Vmax -= n;
        verticalValueMeasure.Vmin -= n;
        n2 += n * n * n3 - 2 * n4 * n;
        n4 -= n3 * n;
        verticalValueMeasure.Vtop -= n;
        verticalValueMeasure.Vbase -= n;
        float f = (float)verticalValueMeasure.Vamp / 10.0f + (float)verticalValueMeasure.Vbase + (float)n;
        float f2 = (float)verticalValueMeasure.Vamp * 9.0f / 10.0f + (float)verticalValueMeasure.Vbase + (float)n;
        float f3 = verticalValueMeasure.Vamp / 2 + verticalValueMeasure.Vbase + n;
    }

    protected void getFirstNwidth(int n, double d, double d2, double d3, MeasureADC measureADC, int n2, int n3, int[] nArray) {
        int n4 = n2;
        int n5 = 0;
        block7: for (int i = n; i < n3; ++i) {
            int n6 = nArray[i];
            switch (n5) {
                case 0: {
                    if (!(d >= (double)n6)) continue block7;
                    n4 = i;
                    ++n5;
                    continue block7;
                }
                case 1: {
                    if (!(d3 >= (double)n6)) continue block7;
                    ++n5;
                    continue block7;
                }
                case 2: {
                    if (!(d <= (double)n6)) continue block7;
                    measureADC.nWidth = i - n4;
                    if (i <= n4) {
                        measureADC.nWidth = -1.0f;
                    }
                    n4 = i;
                    ++n5;
                    continue block7;
                }
                case 3: {
                    if (!(d2 <= (double)n6)) continue block7;
                    ++n5;
                    continue block7;
                }
                case 4: {
                    if (!(d >= (double)n6)) continue block7;
                    measureADC.pWidth = i - n4;
                    if (i <= n4) {
                        measureADC.pWidth = -1.0f;
                    }
                    return;
                }
            }
        }
    }

    protected void getFirstPwidth(int n, double d, double d2, double d3, MeasureADC measureADC, int n2, int n3, int[] nArray) {
        int n4 = n2;
        int n5 = 0;
        block7: for (int i = n; i < n3; ++i) {
            int n6 = nArray[i];
            switch (n5) {
                case 0: {
                    if (!(d <= (double)n6)) continue block7;
                    n4 = i;
                    ++n5;
                    continue block7;
                }
                case 1: {
                    if (!(d2 <= (double)n6)) continue block7;
                    ++n5;
                    continue block7;
                }
                case 2: {
                    if (!(d >= (double)n6)) continue block7;
                    measureADC.pWidth = i - n4;
                    if (i <= n4) {
                        measureADC.pWidth = -1.0f;
                    }
                    n4 = i;
                    ++n5;
                    continue block7;
                }
                case 3: {
                    if (!(d3 >= (double)n6)) continue block7;
                    ++n5;
                    continue block7;
                }
                case 4: {
                    if (!(d <= (double)n6)) continue block7;
                    measureADC.nWidth = i - n4;
                    if (i <= n4) {
                        measureADC.nWidth = -1.0f;
                    }
                    return;
                }
            }
        }
    }

    protected float computePeroid(int n, int n2, int n3, int[] nArray, int n4) {
        int n5 = n2 - 7;
        int n6 = n2 + 7;
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (int i = n; i < n4; i += 2) {
            if (nArray[i] > n5 && nArray[i] >= n6) {
                if (n7 == 1) {
                    if (n8 == 1) {
                        ++n10;
                        n11 = n9;
                    }
                    if (n8 == -1) {
                        n8 = 1;
                        n9 = 0;
                    }
                }
                n7 = 0;
            }
            if (nArray[i] <= n5 && nArray[i] < n6) {
                if (n7 == 0) {
                    if (n8 == 0) {
                        ++n10;
                        n11 = n9;
                    }
                    if (n8 == -1) {
                        n8 = 0;
                        n9 = 0;
                    }
                }
                n7 = 1;
            }
            n9 += 2;
        }
        if (n10 != 0 && n10 <= 512) {
            float f = (float)n11 / (float)n10;
            return f;
        }
        return -1.0f;
    }

    void getRiseFallTime(MeasureADC measureADC) {
        int n;
        int n2;
        int n3 = measureADC.l;
        int n4 = measureADC.p;
        int[] nArray = measureADC.array;
        VerticalValueMeasure verticalValueMeasure = measureADC.vvc;
        int n5 = verticalValueMeasure.Vbase;
        int n6 = verticalValueMeasure.Vamp;
        float f = 0.0f;
        float f2 = 0.0f;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        float f3 = (float)n6 / 10.0f + (float)n5;
        float f4 = (float)n6 * 9.0f / 10.0f + (float)n5;
        int n11 = 0;
        int n12 = -1;
        for (n2 = n4; n2 < n3; ++n2) {
            n = nArray[n2];
            if (f3 > (float)n) {
                n12 = 1;
                break;
            }
            if (!(f4 < (float)n)) continue;
            n12 = 0;
            break;
        }
        if (n12 == 1) {
            while (n2 < n3) {
                n = nArray[n2];
                if (f3 > (float)n) {
                    n11 = n2;
                }
                if (f4 <= (float)n) {
                    f = n2 - n11;
                    n7 = n11;
                    break;
                }
                ++n2;
            }
            while (n2 < n3) {
                n = nArray[n2];
                if (f4 <= (float)n) {
                    n11 = n2;
                }
                if (f3 > (float)n) {
                    f2 = n2 - n11;
                    n8 = n11;
                    break;
                }
                ++n2;
            }
        }
        if (n12 == 0) {
            while (n2 < n3) {
                n = nArray[n2];
                if (f4 < (float)n) {
                    n11 = n2;
                }
                if (f3 >= (float)n) {
                    f2 = n2 - n11;
                    n8 = n11;
                    break;
                }
                ++n2;
            }
            while (n2 < n3) {
                n = nArray[n2];
                if (f3 > (float)n) {
                    n11 = n2;
                }
                if (f4 <= (float)n) {
                    f = n2 - n11;
                    n7 = n11;
                    break;
                }
                ++n2;
            }
        }
        if (n2 > n3) {
            f2 = -1.0f;
            f = -1.0f;
        }
        n9 = f >= 0.0f && f <= 4.0f ? 1 : 0;
        n10 = f2 >= 0.0f && f2 <= 4.0f ? 1 : 0;
        measureADC.raiseTime = f;
        measureADC.fallTime = f2;
        measureADC.raiseStart = n7;
        measureADC.fallStart = n8;
        measureADC.raiseFlag = n9;
        measureADC.fallFlag = n10;
    }
}

