/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.function.PWDValidator;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.vds.core.aspect.IBoard;
import com.owon.uppersoft.vds.core.update.UpdateDetection;

public class SoftwareControl
implements IBoard {
    public static final int BrightnessRemaining = 40;
    public static final int BrightnessLimit = 215;
    private String machine_header = "";
    public String machine_name = "";
    private String m_series = "";
    private String m_version = "";
    private ControlManager cm;
    private PWDValidator pwd = new PWDValidator();
    public static int firmware;

    public SoftwareControl(ControlManager controlManager) {
        this.cm = controlManager;
        this.setMachineHeader(controlManager.getAllChannelsNumber() > 2 ? "SPBVDSxxx4" : "SPBVDSxxx2");
    }

    public void validatPWDInput(int n) {
        boolean bl = this.pwd.input(n);
        if (bl) {
            this.cm.pcs.firePropertyChange("ADMIN_ROOT_PASSWORD_NOTIFY", null, (Object)this.isPWDOpen());
        }
    }

    public void quickPass() {
        this.validatPWDInput(97);
        this.validatPWDInput(99);
        this.validatPWDInput(101);
        this.validatPWDInput(98);
        this.validatPWDInput(100);
    }

    public boolean isPWDOpen() {
        return this.pwd.isOpen();
    }

    @Override
    public void setBoardVersion(String string) {
        String string2;
        this.m_version = string2 = string == null ? "" : string.toUpperCase();
        firmware = 1;
        if (this.machine_name.startsWith("VDS1022")) {
            if (string2.startsWith("V2.7.0")) {
                firmware = 3;
            } else if (string2.startsWith("V2.4.623") || string2.startsWith("V2.6.0")) {
                firmware = 2;
            } else if (string2.startsWith("V2.") || string2.startsWith("V1.")) {
                firmware = 1;
            } else if (string2.startsWith("V")) {
                firmware = Integer.parseInt(string2.substring(1, string2.indexOf(".")));
            }
        }
    }

    @Override
    public String getBoardVersion() {
        return this.m_version;
    }

    public boolean isVDS2062Bandlimit() {
        try {
            String string = this.m_version.substring(1).trim();
            return SoftwareControl.compareVersion(string, "3.0") >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isVDS2064Bandlimit() {
        try {
            String string = this.m_version.substring(1).trim();
            return SoftwareControl.compareVersion(string, "1.0.3") > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static int compareVersion(String string, String string2) {
        return UpdateDetection.compareVersion(string, string2);
    }

    @Override
    public void setBoardSeries(String string) {
        this.m_series = string;
    }

    @Override
    public String getBoardSeries() {
        return this.m_series;
    }

    public void setMachineHeader(String string) {
        this.machine_header = string;
    }

    public String getMachineHeader() {
        return this.machine_header;
    }
}

