/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.vds.util.Pref;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;

public class ReloadManager {
    public static final int NoUse = 0;
    public static final int Record_Reload = 1;
    public static final int DM_Reload = 2;
    public int ReloadStatus = 0;
    public String reloadPath;
    private ControlManager cm;

    public ReloadManager(ControlManager controlManager) {
        this.cm = controlManager;
    }

    public boolean isReloadDM() {
        return this.ReloadStatus == 2;
    }

    public boolean isReload() {
        return this.ReloadStatus != 0;
    }

    public void setReloadStatus(int n) {
        this.ReloadStatus = n;
    }

    public void releaseReloadFlag() {
        this.ReloadStatus = 0;
    }

    public int prepareReloadPlayFile(int n) {
        this.setReloadStatus(1);
        this.restartWhenMismatching(n);
        return 1;
    }

    public void prepareReloadDM(int n, String string) {
        this.setReloadStatus(2);
        this.reloadPath = string;
        this.restartWhenMismatching(n);
    }

    public void reload() {
        switch (this.ReloadStatus) {
            case 0: {
                break;
            }
            case 2: {
                File file = new File(this.reloadPath);
                if (file == null) break;
                this.cm.binIn.openfile(Platform.getDataHouse(), file);
                break;
            }
            case 1: {
                this.reloadPlayFile();
            }
        }
    }

    public void restartInLinking(String string) {
        int n = this.cm.getPrinciple().getMachineID(string);
        this.restartWhenMismatching(n);
    }

    public void restartWhenMismatching(final int n) {
        String string = I18nProvider.bundle().getString("Label.Mismatch");
        int n2 = JOptionPane.showConfirmDialog(Platform.getMainWindow().getFrame(), string, null, 0, 3);
        if (n2 == 0) {
            new Thread(){

                @Override
                public void run() {
                    ReloadManager.this.cm.getCoreControl().setProductParam(ReloadManager.this.cm.getMachineTypeName(n));
                    ((ReloadManager)ReloadManager.this).cm.sourceManager.disconnectSource();
                    Platform.getDataHouse().releaseDeepMemoryStorage();
                    Platform.getMainWindow().getFrame().dispose();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    try {
                        Runtime.getRuntime().exec(ReloadManager.this.cm.getConfig().getStaticPref().getLauncher());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    System.exit(0);
                }
            }.start();
        }
    }

    public void load(Pref pref) {
        this.reloadPath = pref.getProperty("reloadPath", "");
        this.ReloadStatus = pref.loadInt("reloadStatus");
    }

    public void persist(Pref pref) {
        pref.setProperty("reloadPath", this.reloadPath);
        pref.persistInt("reloadStatus", this.ReloadStatus);
    }

    public void reloadPlayFile() {
        this.cm.getDockControl().dockDialogQuickOpenHide("M.Record.Name");
        this.cm.pcs.firePropertyChange("switchPlayPane", null, null);
    }
}

