/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.function.ref.IReferenceWaveForm;
import com.owon.uppersoft.dso.function.ref.ReferenceFile;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.ref.IRefSource;
import com.owon.uppersoft.vds.core.aspect.control.ISupportChannelsNumber;
import com.owon.uppersoft.vds.core.aspect.control.TimeConfProvider;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.core.control.MathControl;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.util.Pref;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class ReferenceWaveControl {
    private static final int SAVE_LIMIT = 16;
    public ControlManager cm;
    private ISupportChannelsNumber scn;
    private int sourceId;
    private int indexAdd;
    public boolean showInfo;
    public int showCount;
    public Color color;
    private Integer nextId = 0;
    private boolean valid = false;
    private LinkedHashMap<Integer, ReferenceFile> rfFiles = new LinkedHashMap();
    private LinkedHashSet<ReferenceFile> rfFilesVisible = new LinkedHashSet();
    private LinkedHashMap<Integer, String> cacheLabels = new LinkedHashMap();

    public ReferenceWaveControl(ControlManager controlManager, Pref pref, ISupportChannelsNumber iSupportChannelsNumber) {
        this.cm = controlManager;
        this.scn = iSupportChannelsNumber;
        this.load(pref);
    }

    public Collection<ReferenceFile> getReferences() {
        return this.rfFiles.values();
    }

    public int getSourceIdx() {
        return this.sourceId;
    }

    public void setSourceIdx(int n) {
        this.sourceId = n;
    }

    public ReferenceFile saveWave(int n, String string) {
        while (this.rfFiles.containsKey(this.nextId)) {
            this.nextId = (this.nextId + 1) % 26;
        }
        return this.saveWave(this.nextId, n, string);
    }

    public ReferenceFile saveWave(int n, int n2, String string) {
        WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
        boolean bl = n2 + 1 > this.cm.getSupportChannelsNumber();
        IRefSource iRefSource = null;
        iRefSource = !bl ? waveFormManager.getWaveForm(n2) : waveFormManager.getCompositeWaveForm();
        IReferenceWaveForm iReferenceWaveForm = this.cm.createReferenceWaveForm(iRefSource, waveFormManager);
        if (iReferenceWaveForm == null) {
            return null;
        }
        ReferenceFile referenceFile = this.rfFiles.get(n);
        if (referenceFile == null) {
            referenceFile = this.addReference(n, string);
        } else {
            referenceFile.setName(string);
        }
        referenceFile.setWaveForm(iReferenceWaveForm);
        iReferenceWaveForm.persistRefFile(this.cm, referenceFile.getFile(), Platform.getControlApps().getDaemon().getChannelsTransportInfo().screendatalen);
        this.invalidate();
        return referenceFile;
    }

    private ReferenceFile addReference(int n, String string) {
        ReferenceFile referenceFile = new ReferenceFile(this, n, string);
        this.rfFiles.put(n, referenceFile);
        if (this.rfFiles.size() > 16) {
            this.removeReference(this.rfFiles.values().iterator().next());
        }
        return referenceFile;
    }

    public void removeReference(ReferenceFile referenceFile) {
        this.rfFiles.remove(referenceFile.id);
        this.rfFilesVisible.remove(referenceFile);
        this.cacheLabels.remove(referenceFile.id);
        referenceFile.getFile().delete();
        this.invalidate();
    }

    public boolean removeLastVisibleReference() {
        ReferenceFile referenceFile = null;
        Iterator iterator = this.rfFilesVisible.iterator();
        while (iterator.hasNext()) {
            ReferenceFile referenceFile2;
            referenceFile = referenceFile2 = (ReferenceFile)iterator.next();
        }
        if (referenceFile == null) {
            return false;
        }
        this.removeReference(referenceFile);
        return true;
    }

    public void hideAll() {
        this.rfFilesVisible.clear();
    }

    public void removeAll() {
        this.nextId = 0;
        this.rfFiles.clear();
        this.rfFilesVisible.clear();
        this.cacheLabels.clear();
        this.invalidate();
    }

    public void setReferenceVisible(ReferenceFile referenceFile, boolean bl) {
        if (bl) {
            this.rfFilesVisible.add(referenceFile);
        } else {
            this.rfFilesVisible.remove(referenceFile);
        }
        while (this.rfFilesVisible.size() > this.showCount) {
            this.rfFilesVisible.remove(this.rfFilesVisible.iterator().next());
        }
    }

    public boolean isReferenceVisible(ReferenceFile referenceFile) {
        return this.rfFilesVisible.contains(referenceFile);
    }

    public void invalidate() {
        this.valid = false;
    }

    private void validate() {
        if (this.valid) {
            return;
        }
        CoreControl coreControl = this.cm.getCoreControl();
        MathControl mathControl = this.cm.mathControl;
        TimeConfProvider timeConfProvider = coreControl.getTimeConfProvider();
        VoltageProvider voltageProvider = coreControl.getVoltageProvider();
        for (ReferenceFile referenceFile : this.rfFiles.values()) {
            if (referenceFile.rwf == null && !referenceFile.loadWaveForm()) continue;
            String string = referenceFile.getComplexName();
            String string2 = timeConfProvider.getTimebaseLabel(referenceFile.rwf.getTbIdx());
            String string3 = referenceFile.rwf.getIntVoltageLabel_mV(voltageProvider, mathControl);
            this.cacheLabels.put(referenceFile.id, string + "  :   " + string3 + "   " + string2);
        }
        this.valid = true;
    }

    public void adjustReferenceView(ScreenContext screenContext, Rectangle rectangle) {
        this.validate();
        for (ReferenceFile referenceFile : this.rfFilesVisible) {
            referenceFile.rwf.adjustView(screenContext, rectangle);
        }
    }

    public void paitReferenceWaves(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        this.validate();
        graphics2D.setColor(this.color);
        for (ReferenceFile referenceFile : this.rfFilesVisible) {
            referenceFile.rwf.paintView(graphics2D, screenContext, rectangle);
        }
        if (this.showInfo) {
            this.paintRFLabel(graphics2D, screenContext);
        }
    }

    private void paintRFLabel(Graphics2D graphics2D, ScreenContext screenContext) {
        if (this.rfFilesVisible.size() == 0) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(this.color);
        int n = 120;
        int n2 = 37;
        int n3 = 110;
        int n4 = 100;
        int n5 = 10;
        for (ReferenceFile referenceFile : this.rfFilesVisible) {
            String string = this.cacheLabels.get(referenceFile.id);
            int n6 = fontMetrics.stringWidth(string);
            n3 = n6 > n3 ? n6 : n3;
            graphics2D.drawString(string, n + 5, n2);
            n2 += 20;
        }
        graphics2D.drawRoundRect(n, 20, n3 + 10, n2 - 37, n5, n5);
    }

    public void paitReferenceItems(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        this.validate();
        graphics2D.setColor(this.color);
        for (ReferenceFile referenceFile : this.rfFilesVisible) {
            referenceFile.rwf.paintItem(graphics2D, screenContext, rectangle, false);
        }
    }

    public void load(Pref pref) {
        this.removeAll();
        this.setSourceIdx(pref.loadInt("ReferenceSourceIdx"));
        if (this.getSourceIdx() >= this.scn.getSupportChannelsNumber()) {
            this.setSourceIdx(this.scn.getSupportChannelsNumber() - 1);
        }
        LinkedList<Integer> linkedList = pref.loadIntegerList("ReferenceObjsIds", ",");
        List<String> list = pref.loadStringList("ReferenceObjsNames", ",");
        Iterator<String> iterator = list.iterator();
        for (Integer n : linkedList) {
            String string = iterator.hasNext() ? iterator.next() : "";
            this.addReference(n, string);
        }
        this.showCount = pref.loadInt("ReferenceShowCount", 4);
        this.showInfo = pref.loadBoolean("ReferenceShowInfo", true);
        this.color = pref.loadColor("Reference.rgb", Color.PINK);
    }

    public void factoryload(Pref pref) {
        this.load(pref);
        this.invalidate();
    }

    public void persist(Pref pref) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (ReferenceFile referenceFile : this.rfFiles.values()) {
            linkedList.add(referenceFile.getId());
            linkedList2.add(referenceFile.getName());
        }
        pref.persistInt("ReferenceShowCount", this.showCount);
        pref.persistBoolean("ReferenceshowInfo", this.showInfo);
        pref.persistIntegerList("ReferenceObjsIds", linkedList, ",");
        pref.persistStringList("ReferenceObjsNames", linkedList2, ",");
        pref.persistInt("ReferenceSourceIdx", this.getSourceIdx());
        pref.persistColor("Reference.rgb", this.color);
    }
}

