/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.function.record.OpenPropertyChangeEvent;
import com.owon.uppersoft.dso.function.record.RecordFileIO;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.vds.core.wf.rt.LoadMedia;
import com.owon.uppersoft.vds.util.Pref;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RecordControl {
    public static final String DEFAULT_RECORD = "recorded-wave.cap";
    private boolean recording = false;
    private File path;
    private ControlManager cm;
    private RandomAccessFile raf;
    private int timegap = 10;
    private long sizePos;
    private int counter;
    private int maxframe;
    public int intervalTime;
    public int endFrame;
    public String recordPath;
    private PropertyChangeListener pcl;
    private boolean keepRecord;
    private boolean lastRecord;
    private OpenPropertyChangeEvent pce;

    public boolean isRecording() {
        return this.recording;
    }

    public void setTimegap(int n) {
        this.timegap = n;
    }

    public void setMaxframe(int n) {
        this.maxframe = n;
    }

    public int getMaxframe() {
        return this.maxframe;
    }

    public RecordControl(ControlManager controlManager, Pref pref) {
        this.cm = controlManager;
        this.load(pref);
        this.keepRecord = false;
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcl = propertyChangeListener;
    }

    public void setPath(File file) {
        try {
            this.path = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public File getPath() {
        return this.path;
    }

    public String getFilePath() {
        return this.path.getPath();
    }

    public int getCounter() {
        return this.counter;
    }

    private boolean filePathValid() {
        boolean bl;
        if (this.path.exists() && this.path.canWrite()) {
            bl = true;
        } else {
            try {
                bl = this.path.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl = false;
            }
        }
        return bl;
    }

    public boolean switchRecording(Runnable runnable) {
        if (!this.cm.isRuntime()) {
            Platform.getControlApps().interComm.statusRun(true, false);
            this.cm.getWaveFormInfoControl().releaseWF();
            this.cm.pcs.firePropertyChange("REPAINT_CHARTSCREEN", null, null);
        }
        if (!this.recording) {
            if (this.filePathValid()) {
                this.recording = true;
                this.pce = new OpenPropertyChangeEvent(this, "RecordFrameIndex", 0, 0);
                try {
                    this.raf = new RandomAccessFile(this.path, "rw");
                    this.sizePos = RecordFileIO.writeHeader(this.raf, this.cm);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                this.keepRecord = true;
                this.lastRecord = false;
                this.counter = 0;
                return true;
            }
            runnable.run();
            return false;
        }
        this.forceStop();
        return false;
    }

    public void forceStop() {
        if (!this.recording) {
            return;
        }
        this.lastRecord = true;
        this.sealTail();
    }

    public int writeOnce(RandomAccessFile randomAccessFile, ControlManager controlManager, WaveFormManager waveFormManager, LoadMedia loadMedia, RecordControl recordControl) {
        int n;
        int n2 = recordControl.getCounter();
        int n3 = recordControl.getMaxframe();
        int n4 = loadMedia.getFrameCount();
        for (n = 0; n < n4; ++n) {
            RecordFileIO.writeFrame(randomAccessFile, controlManager, waveFormManager, loadMedia, n);
            if (++n2 < n3) continue;
            break;
        }
        return n;
    }

    public void recordOnce(WaveFormManager waveFormManager, LoadMedia loadMedia) {
        if (!this.keepRecord) {
            return;
        }
        if (this.raf == null) {
            return;
        }
        if (!this.checkAppendable()) {
            this.lastRecord = true;
        }
        if (this.lastRecord) {
            this.sealTail();
            return;
        }
        int n = this.writeOnce(this.raf, this.cm, waveFormManager, loadMedia, this);
        this.counter += n;
        if (this.counter >= this.maxframe && this.maxframe > 0) {
            this.lastRecord = true;
        }
        this.pce.newInt = this.counter;
        this.pcl.propertyChange(this.pce);
        try {
            Thread.sleep(this.timegap);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void sealTail() {
        if (!this.keepRecord) {
            return;
        }
        if (this.raf == null) {
            return;
        }
        try {
            int n = (int)this.raf.getFilePointer();
            this.raf.seek(this.sizePos);
            this.raf.writeInt(n);
            this.raf.writeInt(this.timegap);
            this.raf.writeInt(this.counter);
            this.raf.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.keepRecord = false;
        this.recording = false;
        this.pce.newInt = -1;
        this.pcl.propertyChange(this.pce);
    }

    private boolean checkAppendable() {
        long l = 0L;
        try {
            l = this.raf.getFilePointer();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return (l /= 1000000L) < 4000L;
    }

    public void persist(Pref pref) {
        this.recordPath = this.getFilePath();
        pref.setProperty("RecordPath", this.recordPath);
        pref.persistInt("RecordCounter", this.counter);
        pref.persistInt("RecordIntervalTime", this.intervalTime);
        pref.persistInt("RecordEndFrame", this.endFrame);
    }

    public void load(Pref pref) {
        this.recordPath = pref.getProperty("RecordPath", "");
        if (this.recordPath.length() == 0) {
            this.recordPath = new File(Platform.DATA_DIR, DEFAULT_RECORD).getPath();
        }
        this.counter = pref.loadInt("RecordCounter");
        this.intervalTime = pref.loadInt("RecordIntervalTime");
        this.endFrame = pref.loadInt("RecordEndFrame");
        if (this.endFrame <= 0) {
            this.endFrame = 1;
        }
        this.setPath(new File(this.recordPath));
    }
}

