/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.function.record.OfflineChannelsInfo;
import com.owon.uppersoft.dso.function.record.OpenPropertyChangeEvent;
import com.owon.uppersoft.dso.function.record.RecordFileIO;
import com.owon.uppersoft.dso.function.record.Timeline;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.vds.core.data.CByteArrayInputStream;
import com.owon.uppersoft.vds.data.Point;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class PlayerControl
implements Runnable,
PropertyChangeListener {
    private final int DotsOneCH = 5000;
    private final int NO_USE = -1;
    private final int VIDEO_PLAY = 1;
    private final int VIDEO_PAUSE = 2;
    private int playing = -1;
    private int timegap;
    public int counter;
    private int current;
    public int sta;
    public int end;
    public boolean cyc;
    private ControlManager cm;
    private OfflineChannelsInfo ci;
    private File path;
    public final String EmptyPath = "";
    public long filesize;
    private PropertyChangeListener pcl;
    private int frame0Pos;
    private Timeline tl;
    private Thread playtrd;
    private CByteArrayInputStream ba;
    private DataHouse dh;
    private int bp;
    private int len;
    private int num;
    private int savedcur = 0;
    private boolean reset = false;

    public PlayerControl(ControlManager controlManager, Properties properties) {
        this.cm = controlManager;
        this.load(properties);
        this.ci = new OfflineChannelsInfo();
        this.resetCurrent();
    }

    public OfflineChannelsInfo getPlayChannelsInfo() {
        return this.ci;
    }

    private boolean isCurrentReset() {
        return this.current == 0;
    }

    private void resetCurrent() {
        this.current = 0;
    }

    public void setTimegap(int n) {
        this.timegap = n;
    }

    public void setStartEndFrame(int n, int n2) {
        this.current = n > n2 ? (this.sta = n2 - 1) : (this.sta = n - 1);
        this.end = n2 > this.counter ? this.counter : n2;
    }

    public void persist(Properties properties) {
        properties.setProperty("PlayPath", this.getFilePath());
    }

    public void load(Properties properties) {
        String string = properties.getProperty("PlayPath", "");
        if (string.length() == 0) {
            string = new File(Platform.DATA_DIR, "recorded-wave.cap").getPath();
        }
        this.setPath(new File(string), true);
        if (this.ba != null) {
            this.ba.dispose();
        }
        this.ba = null;
        this.filesize = -1L;
        this.current = 0;
    }

    public boolean isPlaying() {
        return this.playing == 1;
    }

    public void setPlay(int n) {
        this.playing = n;
    }

    public boolean confirmGoOnPlaying() {
        if (this.isPlaying()) {
            this.pausePlaying();
        }
        return false;
    }

    public boolean confirmStopRunningforPlaying() {
        Platform.getControlApps().interComm.statusStop(false);
        int n = 0;
        do {
            try {
                Thread.sleep(50L);
                ++n;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } while (!Platform.getControlApps().getDaemon().isAfterStop() && n < 60);
        return true;
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcl = propertyChangeListener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.pcl.propertyChange(propertyChangeEvent);
    }

    public void setPath(File file, boolean bl) {
        this.filesize = -1L;
        if (bl) {
            try {
                this.path = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            this.path = file;
        }
    }

    public boolean loadAsync() {
        this.resetSavedCurrent();
        return this.setPathNCheck(this.path, true);
    }

    public boolean setPathNCheck(File file, boolean bl) {
        this.cm.reloadManager.releaseReloadFlag();
        this.setPath(file, true);
        if (!file.isFile()) {
            return false;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                PlayerControl.this.initPlayTimeLine();
            }
        };
        if (bl) {
            thread.start();
        } else {
            thread.run();
        }
        return true;
    }

    public String getFilePath() {
        return this.path.getPath();
    }

    public Boolean isFilePathEmpty() {
        return this.path.getPath() == "";
    }

    private void initPlayTimeLine() {
        this.tl = new Timeline();
        if (this.ba != null) {
            this.ba.dispose();
        }
        this.ba = new CByteArrayInputStream(this.path);
        this.frame0Pos = RecordFileIO.readHeader(this.ba, this, this.ci);
        if (this.frame0Pos <= -1) {
            this.filesize = -1L;
            return;
        }
        if (this.filesize <= 0L) {
            return;
        }
        this.dh = Platform.getDataHouse();
        this.resetCurrent();
        OpenPropertyChangeEvent openPropertyChangeEvent = new OpenPropertyChangeEvent(this, "ReadHeader", 0, 0);
        openPropertyChangeEvent.newInt = this.counter;
        this.propertyChange(openPropertyChangeEvent);
        RecordFileIO.readTimeline(this.tl, this.ba, this);
    }

    public void promptInvalidLoad() {
        ResourceBundle resourceBundle = I18nProvider.bundle();
        FadeIOShell fadeIOShell = new FadeIOShell();
        fadeIOShell.prompt(resourceBundle.getString("M.Record.LoadInvalid"), Platform.getMainWindow().getFrame());
    }

    public void startPlaying() {
        if (!this.isPlaying()) {
            this.setPlay(1);
            if (this.isCurrentReset()) {
                this.ba.reset(this.frame0Pos);
            }
            this.threadStart();
        }
    }

    private void threadStart() {
        this.playtrd = new Thread(this);
        this.playtrd.start();
    }

    public void pausePlaying() {
        this.setPlay(2);
        try {
            this.playtrd.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.playtrd = null;
        OpenPropertyChangeEvent openPropertyChangeEvent = new OpenPropertyChangeEvent(this, "PlayProgress", null, null);
        openPropertyChangeEvent.newInt = -1;
        this.pcl.propertyChange(openPropertyChangeEvent);
    }

    public boolean fileInvalid() {
        return this.filesize <= 0L;
    }

    public boolean switchPlaying() {
        if (!this.isPlaying()) {
            this.setPlay(1);
            if (this.isCurrentReset()) {
                this.ba.reset(this.frame0Pos);
            }
            this.threadStart();
        } else {
            this.pausePlaying();
        }
        return true;
    }

    public CByteArrayInputStream getCByteArrayInputStream() {
        return this.ba;
    }

    public void setCurrentNStreamPointer(int n) {
        Point point;
        this.current = n;
        List<Point> list = this.tl.timepoints;
        Iterator<Point> iterator = list.iterator();
        if (iterator.hasNext()) {
            point = iterator.next();
            this.len = point.x;
            this.num = point.y;
        }
        this.bp = this.frame0Pos;
        for (int i = 0; i < n; ++i) {
            this.bp += this.len;
            --this.num;
            if (this.num != 0 || !iterator.hasNext()) continue;
            point = iterator.next();
            this.len = point.x;
            this.num = point.y;
        }
        this.ba.reset(this.bp);
    }

    public void updateCurrentScreen() {
        RecordFileIO.readFrame(this.ci, this.ba);
        this.ci.loadFinish();
        this.dh.receiveOfflineVideoData(this.ci);
    }

    @Override
    public void run() {
        Platform.getDataHouse().getWaveFormManager().resetVbmulti();
        OpenPropertyChangeEvent openPropertyChangeEvent = new OpenPropertyChangeEvent(this, "PlayProgress", null, null);
        while (!this.cm.isExit() && this.isPlaying()) {
            this.setCurrentNStreamPointer(this.current);
            openPropertyChangeEvent.newInt = this.current + 1;
            this.pcl.propertyChange(openPropertyChangeEvent);
            ++this.current;
            if (this.current >= this.end) {
                if (this.cyc) {
                    this.setCurrentNStreamPointer(this.sta);
                } else {
                    this.sleep(60);
                    this.setPlay(-1);
                    openPropertyChangeEvent.newInt = -1;
                    this.pcl.propertyChange(openPropertyChangeEvent);
                    this.current = this.sta;
                    break;
                }
            }
            this.sleep(this.timegap);
        }
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void saveCurrent() {
        this.savedcur = this.current;
    }

    public void loadSavedCurrent() {
        if (!this.reset) {
            this.current = this.savedcur;
        }
        this.reset = false;
    }

    public void resetSavedCurrent() {
        this.savedcur = 0;
        this.reset = true;
    }

    public int getSavedCurrent() {
        return this.savedcur;
    }
}

