/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.function.PersistenceFader;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.vds.core.aspect.Paintable;
import com.owon.uppersoft.vds.core.aspect.help.AreaImageHelper;
import com.owon.uppersoft.vds.core.aspect.help.IPersistentDisplay;
import com.owon.uppersoft.vds.core.aspect.help.ImageHandler;
import com.owon.uppersoft.vds.core.comm.IRuntime;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.data.Point;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class PersistentDisplay
implements IPersistentDisplay {
    public static final String PERSISTENCE_RESET = "PERSISTENCE_RESET";
    private IRuntime rt;
    private AreaImageHelper gd;
    private Paintable pt;
    private boolean useCanvasBuffer = false;
    private BufferedImage persistbi;
    private BufferedImage tempbi;
    private Thread pThread;
    private PersistenceFader pf;

    public PersistentDisplay(IRuntime iRuntime, AreaImageHelper areaImageHelper, int n, Paintable paintable) {
        this.rt = iRuntime;
        this.gd = areaImageHelper;
        this.pt = paintable;
        this.pf = new PersistenceFader(this);
    }

    public void adjustView(ScreenContext screenContext, Rectangle rectangle) {
        if (this.useCanvasBuffer) {
            this.tryCreateFadeBufferedImage();
            if (this.pf.isOnInfinite()) {
                this.resetPersistBufferImage();
            }
        }
    }

    public void paintView(Graphics2D graphics2D, Point point) {
        if (this.rt.isAllChannelShutDown()) {
            return;
        }
        graphics2D.drawImage(this.persistbi, 0, 0, point.x, point.y, 0, 0, point.x, point.y, null);
    }

    public void bufferWaveForms(ScreenContext screenContext, WaveFormManager waveFormManager, MainWindow mainWindow) {
        if (this.pf.isPhosphor()) {
            this.bufferPhosphorWaveForms(screenContext, waveFormManager, mainWindow);
        } else {
            this.bufferPersistWaveforms(screenContext, waveFormManager, mainWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferPersistWaveforms(ScreenContext screenContext, WaveFormManager waveFormManager, MainWindow mainWindow) {
        if (this.persistbi == null) {
            return;
        }
        BufferedImage bufferedImage = this.persistbi;
        synchronized (bufferedImage) {
            Graphics2D graphics2D = (Graphics2D)this.persistbi.getGraphics();
            waveFormManager.paintView(graphics2D, screenContext, mainWindow.getChartScreen().getChart().getLocInfo());
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferPhosphorWaveForms(ScreenContext screenContext, WaveFormManager waveFormManager, MainWindow mainWindow) {
        if (this.tempbi == null) {
            return;
        }
        BufferedImage bufferedImage = this.tempbi;
        synchronized (bufferedImage) {
            Graphics2D graphics2D = (Graphics2D)this.tempbi.getGraphics();
            this.gd.resetARGBBufferImage(this.tempbi);
            waveFormManager.paintView(graphics2D, screenContext, mainWindow.getChartScreen().getChart().getLocInfo());
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncDealPersistImage(ImageHandler imageHandler) {
        BufferedImage bufferedImage = this.persistbi;
        synchronized (bufferedImage) {
            imageHandler.handle(this.persistbi, this.tempbi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetPersistBufferImage() {
        if (this.useCanvasBuffer) {
            BufferedImage bufferedImage = this.persistbi;
            synchronized (bufferedImage) {
                this.gd.resetARGBBufferImage(this.persistbi);
            }
        }
    }

    @Override
    public void re_paint() {
        this.pt.re_paint();
    }

    @Override
    public boolean isRuntime() {
        return this.rt.isRuntime();
    }

    @Override
    public boolean isExit() {
        return this.rt.isExit();
    }

    public boolean isUseCanvasBuffer() {
        return this.useCanvasBuffer;
    }

    public void resetPersistence() {
        if (this.pThread != null && this.pThread.isAlive()) {
            this.pf.setCover();
        }
    }

    public void setUseCanvasBuffer(boolean bl) {
        this.useCanvasBuffer = bl;
        if (bl) {
            this.tryCreateFadeBufferedImage();
        } else {
            this.persistbi = null;
            this.tempbi = null;
        }
    }

    private void tryCreateFadeBufferedImage() {
        Point point = this.gd.getDrawSize();
        if (this.persistbi == null || this.persistbi.getHeight() < point.y || this.persistbi.getWidth() < point.x) {
            this.persistbi = this.gd.createARGBScreenBufferedImage();
        }
        this.tryCreateTempBufImgForPhosphor();
    }

    private void tryCreateTempBufImgForPhosphor() {
        Point point = this.gd.getDrawSize();
        if (this.tempbi == null || this.tempbi.getHeight() < point.y || this.tempbi.getWidth() < point.x) {
            this.tempbi = this.gd.createARGBScreenBufferedImage();
        }
    }

    public void fadeThdOn_Off_UI(int n) {
        if (n == 0) {
            if (this.persistbi != null) {
                this.destroyFadeThread();
            }
            this.setUseCanvasBuffer(false);
        } else {
            this.setUseCanvasBuffer(true);
            this.createFadeThread(n);
        }
    }

    private void createFadeThread(int n) {
        if (this.pThread == null) {
            this.pf.setFadeTime(n);
            this.pThread = new Thread(this.pf);
            this.pThread.start();
        } else {
            this.pf.setFadeTime(n);
        }
    }

    public void destroyFadeThread() {
        this.pf.setOff();
        if (this.pThread != null && this.pThread.isAlive()) {
            try {
                this.pThread.join();
                this.pThread = null;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

