/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.function.perspective.CompositeWaveForm;
import com.owon.uppersoft.dso.global.ControlApps;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.util.DBG;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.help.AreaImageHelper;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.function.rule.PFRuleControl;
import com.owon.uppersoft.vds.function.rule.RuleDetail;
import com.owon.uppersoft.vds.util.Pref;
import com.owon.uppersoft.vds.util.format.SFormatter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PFRuleManager {
    public static final int max_rule_num = 8;
    private List<RuleDetail> rule_list;
    private PFRuleControl pfrc;
    private int output_rule = 1;
    private int[] pf_counts = new int[2];
    private boolean stop_on_output = false;
    private boolean ring;
    private boolean show_msg;
    private boolean checking = false;
    private ControlApps ca;

    public PFRuleManager(Pref pref, int n) {
        this.rule_list = new ArrayList<RuleDetail>(8);
        this.load(pref, n);
    }

    public List<RuleDetail> getRuleList() {
        return this.rule_list;
    }

    public RuleDetail load(Pref pref, int n) {
        RuleDetail ruleDetail;
        List<String> list = pref.loadStringList("Rule.rules", ";", 8);
        if (!this.rule_list.isEmpty()) {
            this.rule_list.clear();
        }
        for (String string : list) {
            ruleDetail = RuleDetail.getInstance(string, n);
            if (ruleDetail == null) continue;
            this.rule_list.add(ruleDetail);
        }
        this.setShowMsg(pref.loadBoolean("Rule.msg"));
        this.setRing(pref.loadBoolean("Rule.ring"));
        this.setStopOnOutput(pref.loadBoolean("Rule.stopOnOutput"));
        this.setOutputRule(pref.loadInt("Rule.outputRule"));
        ruleDetail = RuleDetail.getInstanceWithAdjust(pref.getProperty("Rule.current"), n);
        this.pfrc = new PFRuleControl(ruleDetail);
        return ruleDetail;
    }

    public void persist(Pref pref) {
        pref.setProperty("Rule.current", this.pfrc.getRuleDetail().toPersist());
        pref.persistBoolean("Rule.msg", this.show_msg);
        pref.persistBoolean("Rule.ring", this.ring);
        pref.persistBoolean("Rule.stopOnOutput", this.stop_on_output);
        pref.persistInt("Rule.outputRule", this.output_rule);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (RuleDetail ruleDetail : this.rule_list) {
            if (ruleDetail == null) continue;
            linkedList.add(ruleDetail.toPersist());
        }
        pref.persistStringList("Rule.rules", linkedList, ";");
    }

    public PFRuleControl getPFRuleControl() {
        return this.pfrc;
    }

    public void receiveData(WaveFormManager waveFormManager, int n) {
        if (!this.pfrc.isRuleEnable()) {
            return;
        }
        this.pfrc.resetRusult();
        int n2 = this.pfrc.getRuleChannel();
        PFRuleControl.ComplexBuffer complexBuffer = new PFRuleControl.ComplexBuffer();
        boolean bl = true;
        if (waveFormManager.isMath(n2)) {
            CompositeWaveForm compositeWaveForm = waveFormManager.getCompositeWaveForm();
            if (compositeWaveForm == null || !compositeWaveForm.isOn()) {
                bl = false;
            }
            complexBuffer.ib = compositeWaveForm.getADC_Buffer();
            complexBuffer.isByteArray = false;
        } else {
            WaveForm waveForm = waveFormManager.getWaveForm(n2);
            if (waveForm == null || !waveForm.isOn()) {
                bl = false;
            }
            complexBuffer.bb = waveForm.getADC_Buffer();
            complexBuffer.isByteArray = true;
        }
        if (bl) {
            this.pfrc.receiveData(complexBuffer, this.checking, n);
        }
        this.handleCheckResult(this.pfrc.getResult());
    }

    public void setOutputRule(int n) {
        boolean bl;
        boolean bl2 = bl = n == 1 || n == 0;
        if (!bl) {
            return;
        }
        this.output_rule = n;
    }

    public int getOutputRule() {
        return this.output_rule;
    }

    public void resetPFCounts() {
        this.pf_counts[0] = 0;
        this.pf_counts[1] = 0;
    }

    public void paintRulePoints(Graphics2D graphics2D, boolean bl, Rectangle rectangle, AreaImageHelper areaImageHelper) {
        this.pfrc.paintRulePoints(graphics2D, bl, rectangle, areaImageHelper);
    }

    public void adjustView() {
        this.pfrc.adjustView();
    }

    public void paintPFLabel(Graphics2D graphics2D, ScreenContext screenContext) {
        if (this.show_msg && this.pfrc.isRuleEnable()) {
            int n = this.pf_counts[1];
            int n2 = this.pf_counts[0];
            int n3 = n + n2;
            int n4 = 20;
            int n5 = 20;
            int n6 = 20;
            int n7 = 85;
            int n8 = 65;
            int n9 = 10;
            graphics2D.setColor(graphics2D.getBackground());
            graphics2D.fillRoundRect(n4, n5, n7, n8, n9, n9);
            graphics2D.setColor(Color.RED);
            graphics2D.drawRoundRect(n4, n5, n7, n8, n9, n9);
            n5 = 35;
            graphics2D.drawString(SFormatter.UIformat("pass: %d", n), n4 += 5, n5);
            graphics2D.drawString(SFormatter.UIformat("fail: %d", n2), n4, n5 += n6);
            graphics2D.drawString(SFormatter.UIformat("total: %d", n3), n4, n5 += n6);
        }
    }

    private void logResult(int n) {
        if (n == 1) {
            DBG.outprintln("output: PASS");
        } else {
            DBG.errprintln("output: FAIL");
        }
    }

    private void handleCheckResult(int n) {
        if (n != 1 && n != 0) {
            return;
        }
        int n2 = n;
        this.pf_counts[n2] = this.pf_counts[n2] + 1;
        if (n == this.output_rule) {
            if (this.ring) {
                Toolkit.getDefaultToolkit().beep();
            }
            if (this.stop_on_output) {
                Platform.getControlApps().interComm.statusStop(false);
            }
        }
        this.ca.interComm.sync_pf(n);
    }

    public void setShowMsg(boolean bl) {
        this.show_msg = bl;
    }

    public boolean isShowMsg() {
        return this.show_msg;
    }

    public void setRing(boolean bl) {
        this.ring = bl;
    }

    public boolean isRing() {
        return this.ring;
    }

    public void setStopOnOutput(boolean bl) {
        this.stop_on_output = bl;
    }

    public boolean isStopOnOutput() {
        return this.stop_on_output;
    }

    public boolean isChecking() {
        return this.checking;
    }

    public void runCheck() {
        this.checking = true;
        this.resetPFCounts();
        this.ca = Platform.getControlApps();
    }

    public void stopCheck() {
        this.checking = false;
    }
}

