/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.function.Markable;
import com.owon.uppersoft.dso.function.perspective.CompositeWaveForm;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.view.ViewChart;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.control.HorizontalUnit;
import com.owon.uppersoft.vds.core.paint.PaintContext;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.util.Pref;
import com.owon.uppersoft.vds.util.format.UnitConversionUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class MarkCursorControl {
    public boolean ison;
    private final int r_y1in1;
    private final int r_y3in1;
    private int x1pix;
    private int x2pix;
    private int x3pix;
    private int[] tby1pix;
    private int[] tby2pix;
    private boolean onTimeMeasure;
    private boolean onVoltMeasure;
    private boolean onx1;
    private boolean onx2;
    private boolean onx3;
    private boolean ony1;
    private boolean ony2;
    private String labelX;
    private String labelY1;
    private String labelY2;
    private ViewChart vc;
    private WaveFormInfoControl wfic;
    private ScreenContext pc;
    private HorizontalUnit tc;
    private PropertyChangeSupport pcs;
    public Color color;
    private final int detectGap = 7;

    public MarkCursorControl(Pref pref, int n, HorizontalUnit horizontalUnit, PropertyChangeSupport propertyChangeSupport, WaveFormInfoControl waveFormInfoControl) {
        this.r_y1in1 = PaintContext.ScreenMode1_ChartInsets.top;
        this.r_y3in1 = PaintContext.ScreenMode3_ChartInsets.top;
        this.tby1pix = new int[4];
        this.tby2pix = new int[4];
        this.detectGap = 7;
        this.ony2 = false;
        this.ony1 = false;
        this.onx3 = false;
        this.onx2 = false;
        this.onx1 = false;
        this.tc = horizontalUnit;
        this.wfic = waveFormInfoControl;
        this.pcs = propertyChangeSupport;
        this.load(pref, n);
        propertyChangeSupport.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("onTimebaseUpdated")) {
                    MarkCursorControl.this.computeXValues();
                } else if (string.equals("SelectWF") || string.equals("ChannelOption") || string.equals("PROBECHANGE") || string.equals("UPDATE_CHLVOLT") || string.equals("APPLY_CHANNELS")) {
                    MarkCursorControl.this.computeYValues();
                }
            }
        });
    }

    public void acceptImporter(ViewChart viewChart, DataHouse dataHouse) {
        this.vc = viewChart;
        this.pc = viewChart.getScreenContext();
    }

    public boolean is3in1() {
        return this.pc.isScreenMode_3();
    }

    private Rectangle getLocInfo() {
        return this.vc.getLocInfo();
    }

    public void persist(Pref pref) {
        pref.persistInt("MarkCursor.x1", this.x1pix);
        pref.persistInt("MarkCursor.x2", this.x2pix);
        pref.persistInt("MarkCursor.x3", this.x3pix);
        pref.persistInt("MarkCursor.CH1.y1", this.tby1pix[0]);
        pref.persistInt("MarkCursor.CH1.y2", this.tby2pix[0]);
        pref.persistInt("MarkCursor.CH2.y1", this.tby1pix[1]);
        pref.persistInt("MarkCursor.CH2.y2", this.tby2pix[1]);
        pref.persistInt("MarkCursor.Math.y1", this.tby1pix[2]);
        pref.persistInt("MarkCursor.Math.y2", this.tby2pix[2]);
        pref.persistBoolean("MarkCursor.onTimebase", this.onTimeMeasure);
        pref.persistBoolean("MarkCursor.onVoltbase", this.onVoltMeasure);
        pref.persistColor("MarkCursor.rgb", this.color);
    }

    public void load(Pref pref, int n) {
        this.x1pix = pref.loadInt("MarkCursor.x1", 362);
        this.x2pix = pref.loadInt("MarkCursor.x2", 662);
        this.x3pix = pref.loadInt("MarkCursor.x3", 437);
        this.tby1pix[0] = pref.loadInt("MarkCursor.CH1.y1");
        this.tby2pix[0] = pref.loadInt("MarkCursor.CH1.y2");
        this.tby1pix[1] = pref.loadInt("MarkCursor.CH2.y1");
        this.tby2pix[1] = pref.loadInt("MarkCursor.CH2.y2");
        this.tby1pix[2] = pref.loadInt("MarkCursor.Math.y1");
        this.tby2pix[2] = pref.loadInt("MarkCursor.Math.y2");
        this.onTimeMeasure = pref.loadBoolean("MarkCursor.onTimebase");
        this.onVoltMeasure = pref.loadBoolean("MarkCursor.onVoltbase");
        this.ison = this.onTimeMeasure || this.onVoltMeasure;
        this.color = pref.loadColor("MarkCursor.rgb", Color.PINK);
        this.labelY2 = null;
        this.labelY1 = null;
        this.labelX = null;
    }

    public boolean checkButton(int n, int n2, Rectangle rectangle) {
        return n > rectangle.x && n2 < rectangle.y + rectangle.height && n < rectangle.x + 28 && n2 > rectangle.y + rectangle.height - 28;
    }

    public int checkMark(boolean bl, int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getSelectedwfIdx();
        if (!bl) {
            n4 = this.tby1pix[n5];
            n3 = this.tby2pix[n5];
        } else {
            n4 = this.tby1pix[n5] >> 1;
            n3 = this.tby2pix[n5] >> 1;
        }
        int n6 = this.x1pix;
        int n7 = this.x2pix;
        int n8 = this.x3pix;
        int n9 = 0;
        if (this.onTimeMeasure) {
            this.onx3 = n > n8 - 7 && n < n8 + 7;
            this.onx2 = !this.onx3 && n > n7 - 7 && n < n7 + 7;
            boolean bl2 = this.onx1 = !this.onx2 && n > n6 - 7 && n < n6 + 7;
            if (this.onx1 || this.onx2 || this.onx3) {
                n9 = 11;
            }
        }
        if (this.onVoltMeasure) {
            this.ony2 = n2 > n3 - 7 && n2 < n3 + 7;
            boolean bl3 = this.ony1 = !this.ony2 && n2 > n4 - 7 && n2 < n4 + 7;
            if (this.ony1 || this.ony2) {
                n9 = 8;
            }
        }
        return n9;
    }

    public void toogle() {
        this.onTimeMeasure ^= true;
        this.update();
    }

    public boolean getOnTimebaseM() {
        return this.onTimeMeasure;
    }

    public void setOnTimebaseM(Boolean bl) {
        this.onTimeMeasure = bl;
        this.ison = this.onTimeMeasure || this.onVoltMeasure;
        this.pcs.firePropertyChange("update_markbulletin", null, null);
    }

    public boolean getOnVoltbaseM() {
        return this.onVoltMeasure;
    }

    public void setOnVoltbaseM(Boolean bl) {
        this.onVoltMeasure = bl;
        this.ison = this.onTimeMeasure || this.onVoltMeasure;
        this.pcs.firePropertyChange("update_markbulletin", null, null);
    }

    private void update() {
        this.ison = this.onTimeMeasure || this.onVoltMeasure;
        this.pcs.firePropertyChange("update_markbulletin", null, null);
        this.pcs.firePropertyChange("UPDATE_CURSOR", null, null);
        Platform.getMainWindow().getChartScreen().re_paint();
    }

    public void computeXValues() {
        if (!this.onTimeMeasure) {
            return;
        }
        int n = this.tc.getHorizontalTriggerPosition();
        double d = this.tc.getPixelTime_mS();
        Rectangle rectangle = this.getLocInfo();
        int n2 = (rectangle.width >> 1) + rectangle.x - n;
        double d2 = (double)(Math.min(this.x1pix, this.x2pix) - n2) * d;
        double d3 = (double)(Math.max(this.x1pix, this.x2pix) - n2) * d;
        double d4 = (double)(this.x3pix - n2) * d;
        double d5 = d3 - d2;
        double d6 = d4 - d2;
        double d7 = d3 - d4;
        String string = UnitConversionUtil.getSimplifiedTimebaseLabel_mS(d2);
        String string2 = UnitConversionUtil.getSimplifiedTimebaseLabel_mS(d3);
        String string3 = UnitConversionUtil.getSimplifiedTimebaseLabel_mS(d4);
        String string4 = UnitConversionUtil.getSimplifiedTimebaseLabel_mS(d5);
        String string5 = UnitConversionUtil.getSimplifiedTimebaseLabel_mS(d6);
        String string6 = UnitConversionUtil.getSimplifiedFrequencyLabel_Hz(1000.0 / d5);
        String string7 = (double)Math.round(d6 / d5 * 1000.0) / 10.0 + "%";
        double d8 = 3600.0 * d6 / d5 % 3600.0;
        String string8 = (double)Math.round(d8) / 10.0 + "\u00b0";
        this.labelX = "[ " + string + "  " + string2 + " ]   \u0394 " + string4 + "   " + string6 + "     " + string7 + "     " + string8;
        this.pcs.firePropertyChange("update_markbulletin", null, null);
    }

    public void computeValues() {
        this.computeXValues();
        this.computeYValues();
    }

    public void computeYValues() {
        double d;
        double d2;
        if (!this.onVoltMeasure) {
            return;
        }
        Markable markable = Platform.getDataHouse().getWaveFormManager().getCompositeWaveForm();
        if (!markable.isOn()) {
            markable = this.wfic.getSelectedWF().wfi.ci;
        }
        int n = markable.getPos0();
        double d3 = markable.getVoltValue();
        int n2 = markable.getNumber();
        int n3 = this.tby1pix[n2];
        int n4 = this.tby2pix[n2];
        Rectangle rectangle = this.getLocInfo();
        int n5 = rectangle.height >> 1;
        if (!this.pc.isScreenMode_3()) {
            int n6 = n5 - 2 * n + rectangle.y;
            d2 = n6 - n3;
            d = n6 - n4;
        } else {
            int n7 = n5 - n + rectangle.y;
            d2 = n7 - ((n3 - this.r_y1in1 >> 1) + this.r_y3in1) << 1;
            d = n7 - ((n4 - this.r_y1in1 >> 1) + this.r_y3in1) << 1;
        }
        d2 = d2 / 50.0 * d3;
        d = d / 50.0 * d3;
        double d4 = Math.abs(d - d2);
        this.labelY1 = markable.getValueLabel(d2);
        this.labelY2 = markable.getValueLabel(d) + "   \u0394 " + markable.getValueLabel(d4);
        this.pcs.firePropertyChange("update_markbulletin", null, null);
    }

    private void drawXLines(Graphics2D graphics2D, Rectangle rectangle) {
        int n = this.x1pix;
        int n2 = this.x2pix;
        int n3 = this.x3pix;
        int n4 = rectangle.x - 2;
        MarkCursorControl.drawVerticalDashedLine(graphics2D, n, n4, n4 + rectangle.height);
        MarkCursorControl.drawVerticalDashedLine(graphics2D, n2, n4, n4 + rectangle.height);
        MarkCursorControl.drawVerticalDashedLine(graphics2D, n3, n4 + (int)((double)rectangle.height * 0.05), n4 + (int)((double)rectangle.height * 0.95));
        if (this.labelX == null) {
            this.computeXValues();
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = fontMetrics.getAscent() - 2;
        int n6 = rectangle.y + rectangle.height - 2;
        int n7 = (int)((double)rectangle.width * 0.21);
        int n8 = fontMetrics.stringWidth(this.labelX) + 6;
        Color color = graphics2D.getColor();
        graphics2D.setColor(graphics2D.getBackground());
        graphics2D.fillRoundRect(n7, n6 - n5, n8, n5, 1, 1);
        graphics2D.setColor(color);
        graphics2D.drawString(this.labelX, n7 + 2, n6 - 2);
    }

    private void drawYLines(Graphics2D graphics2D, Rectangle rectangle, int n) {
        int n2 = this.tby1pix[n];
        int n3 = this.tby2pix[n];
        int n4 = n2;
        int n5 = n3;
        if (this.pc.isScreenMode_3()) {
            n4 = (n2 - this.r_y1in1 >> 1) + this.r_y3in1;
            n5 = (n3 - this.r_y1in1 >> 1) + this.r_y3in1;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Color color = graphics2D.getColor();
        if (this.labelY1 == null) {
            this.computeYValues();
        }
        MarkCursorControl.drawHorizontalDashedLine(graphics2D, n4, rectangle.x, rectangle.x + rectangle.width);
        MarkCursorControl.drawString(graphics2D, this.labelY1, rectangle.x + 25, n4, rectangle, n4 <= n5);
        if (Math.abs(n4 - n5) > 5) {
            MarkCursorControl.drawHorizontalDashedLine(graphics2D, n5, rectangle.x, rectangle.x + rectangle.width);
            MarkCursorControl.drawString(graphics2D, this.labelY2, rectangle.x + 25, n5, rectangle, n4 > n5);
        }
    }

    public static void drawString(Graphics2D graphics2D, String string, int n, int n2, Rectangle rectangle, boolean bl) {
        Color color = graphics2D.getColor();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string) + 6;
        int n4 = fontMetrics.getAscent();
        n2 = bl ? n2 - n4 - 1 : n2 + 1;
        n2 = Math.min(Math.max(n2, rectangle.y + 1), rectangle.y + rectangle.height - n4 - 2);
        graphics2D.setColor(graphics2D.getBackground());
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setColor(color);
        graphics2D.drawString(string, n + 3, n2 + n4 - 2);
    }

    public static void drawXString(Graphics2D graphics2D, String string, int n, int n2, Rectangle rectangle) {
        Color color = graphics2D.getColor();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string) + 6;
        int n4 = fontMetrics.getAscent();
        if ((n += 2) + n3 > rectangle.x + rectangle.width) {
            n = rectangle.x + rectangle.width - n3 - 2;
        }
        graphics2D.setColor(graphics2D.getBackground());
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setColor(color);
        graphics2D.drawString(string, n, n2 + n4 - 2);
    }

    public static void drawHorizontalDashedLine(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4;
        for (n4 = n2 + 4; n4 < n3; n4 += 8) {
            graphics2D.drawLine(n4 - 4, n, n4, n);
        }
        graphics2D.drawLine(Math.min(n4 - 4, n3), n, n3, n);
    }

    public static void drawVerticalDashedLine(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4;
        for (n4 = n2 + 4; n4 < n3; n4 += 8) {
            graphics2D.drawLine(n, n4 - 4, n, n4);
        }
        graphics2D.drawLine(n, Math.min(n4 - 4, n3), n, n3);
    }

    public void drawMarkCursor(Graphics2D graphics2D, Rectangle rectangle) {
        int n = rectangle.x + 8;
        int n2 = rectangle.y + rectangle.height - 8;
        graphics2D.setColor(this.color);
        graphics2D.drawString("\u2223\u2223", n, n2);
        if (!this.ison || !this.onTimeMeasure && !this.onVoltMeasure) {
            return;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.onTimeMeasure) {
            this.drawXLines(graphics2D, rectangle);
        }
        if (this.onVoltMeasure) {
            CompositeWaveForm compositeWaveForm = Platform.getDataHouse().getWaveFormManager().getCompositeWaveForm();
            if (compositeWaveForm.isOn()) {
                graphics2D.setColor(compositeWaveForm.getColor());
                this.drawYLines(graphics2D, rectangle, compositeWaveForm.getNumber());
            } else {
                WaveForm waveForm = this.wfic.getSelectedWF();
                if (waveForm.isOn()) {
                    graphics2D.setColor(waveForm.getColor());
                    this.drawYLines(graphics2D, rectangle, waveForm.getChannelNumber());
                }
            }
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public int limitXEdge(Rectangle rectangle, int n) {
        if (n < rectangle.x) {
            n = rectangle.x;
        } else if (n > rectangle.x + rectangle.width) {
            n = rectangle.x + rectangle.width;
        }
        return n;
    }

    public int limitYEdge(Rectangle rectangle, int n) {
        int n2 = rectangle.y;
        int n3 = rectangle.y + rectangle.height;
        if (this.pc.isScreenMode_3()) {
            n3 = rectangle.y + (rectangle.height << 1);
        }
        if (n < n2) {
            n = n2;
        } else if (n >= n3) {
            n = n3 - 1;
        }
        return n;
    }

    private int getSelectedwfIdx() {
        if (Platform.getControlManager().mathControl.mathon) {
            return this.wfic.getLowMachineChannels();
        }
        return this.wfic.getSelectedwfIdx();
    }

    public void dragMarkCursor(int n, int n2) {
        int n3 = this.getSelectedwfIdx();
        Rectangle rectangle = this.getLocInfo();
        if (this.onTimeMeasure) {
            n = this.limitXEdge(rectangle, n);
            if (this.onx1) {
                this.x1pix = n;
            } else if (this.onx2) {
                this.x2pix = n;
            } else if (this.onx3) {
                this.x3pix = n;
            }
            this.computeXValues();
        }
        if (this.onVoltMeasure) {
            if (this.pc.isScreenMode_3()) {
                n2 = rectangle.y + (n2 - rectangle.y << 1);
            }
            n2 = this.limitYEdge(rectangle, n2);
            if (this.ony1) {
                this.tby1pix[n3] = n2;
            }
            if (this.ony2) {
                this.tby2pix[n3] = n2;
            }
            this.computeYValues();
        }
    }

    public void closeMarkCursor() {
        this.onTimeMeasure = false;
        this.onVoltMeasure = false;
        this.update();
    }
}

