/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.mode.control.FFTControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.util.ui.LineUtil;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.IView;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.aspect.control.LocationLabelProvider;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.core.fft.FFTBin;
import com.owon.uppersoft.vds.core.fft.FFTUtil;
import com.owon.uppersoft.vds.core.fft.WndType;
import com.owon.uppersoft.vds.core.paint.Background;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.data.LocRectangle;
import com.owon.uppersoft.vds.util.format.SFormatter;
import com.owon.uppersoft.vds.util.format.UnitConversionUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class FFTView
implements IView,
LocationLabelProvider,
Localizable {
    public static WndType[] wndTypes = WndType.values();
    public static final boolean FFTNew = true;
    public static final boolean oldFFTversion = false;
    public static final int fftlen = 4096;
    private final int PIXELS_PER_DIV = 25;
    private final int PIXELS_PER_HORIZDIV = 50;
    private int[] data = new int[4096];
    private boolean use;
    private ControlManager cm;
    private WaveFormManager wfm;
    private Background bg;
    private FFTControl mc;
    private int len;
    public static final int xbases = 20;
    public static final int ftxbases = 20;
    public int dBbaseidx;
    public int vrmsbaseidx;
    public String fftchlLack;
    private int xb;
    private int xoff;
    private int yoff;
    private double xgap;
    private int lastScaleIdx;
    private int hc;
    private int wc;
    private Rectangle rec;
    public double yScaleRate = 1.0;
    private int vrmsIdx;
    private double voltPerDiv;
    private boolean is3in1;
    private int height = 250;
    private int width = 1000;
    private double[] rfreqs = new double[3];
    private LocRectangle lr = new LocRectangle();

    public FFTView(WaveFormManager waveFormManager, ControlManager controlManager) {
        this.cm = controlManager;
        this.wfm = waveFormManager;
        this.mc = controlManager.getFFTControl();
        this.bg = new Background();
        this.bg.hideAxis();
        this.vrmsIdx = -1;
        this.vrmsbaseidx = -1;
        this.dBbaseidx = 0;
        this.xoff = 0;
        this.yoff = 75;
        this.setXGap();
        this.lastScaleIdx = this.mc.fftscale;
    }

    private void setXGap() {
        int n = this.width;
        this.xgap = (double)n / 2048.0 * (double)FFTControl.SCALES_VALUE[this.lastScaleIdx];
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.fftchlLack = resourceBundle.getString("M.Math.FFT.chloffWarn");
    }

    public boolean isOn() {
        return this.mc.isFFTon();
    }

    public void updateFFT() {
        if (this.cm.isKeepGet()) {
            return;
        }
        this.receiveNewData();
        Platform.getMainWindow().updateShow();
        this.lastScaleIdx = this.mc.fftscale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveNewData() {
        int[] nArray = this.data;
        synchronized (this.data) {
            this.doReceiveNewData();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void doReceiveNewData() {
        int n;
        int n2;
        this.use = false;
        if (!this.isOn()) {
            return;
        }
        WaveForm waveForm = this.wfm.getWaveForm(this.mc.getFFTchl());
        ByteBuffer byteBuffer = waveForm.getFFT_Buffer();
        if (byteBuffer == null) {
            return;
        }
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        this.len = n4 - n3;
        if (this.len <= 0) {
            return;
        }
        int n5 = waveForm.getPos0ForADC();
        if (this.len < 4096) {
            FFTUtil.plugValues(byArray, this.data, n3, n4, 4096, n5);
        } else {
            n2 = 2048;
            int n6 = n4 + n3 >> 1;
            int n7 = n6 - n2;
            n = n6 + n2;
            int n8 = n7;
            int n9 = 0;
            while (n8 < n) {
                this.data[n9] = byArray[n8] - n5;
                ++n8;
                ++n9;
            }
        }
        n2 = FFTUtil.rfft_abs(this.data, wndTypes[this.mc.getFFTwnd()]);
        if (this.mc.fftvaluetype == 0) {
            double d = 1.0 / (double)n2 / Math.sqrt(2.0);
            for (n = 0; n < n2; ++n) {
                this.data[n] = (int)((double)this.data[n] * d);
            }
        } else {
            double d = this.voltPerDiv / 1000.0 / 25.0;
            double d2 = 1.0 / (double)n2 / Math.sqrt(2.0) * d;
            for (int i = 0; i < n2; ++i) {
                this.data[i] = (int)(25.0 * Math.log10((double)this.data[i] * d2));
            }
        }
        this.use = true;
    }

    private List<FFTBin> find_peaks(int[] nArray, int n) {
        int n2 = n / 2;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = nArray[0];
        double d = this.mc.getFFTSampleRateBD().doubleValue();
        ArrayList<FFTBin> arrayList = new ArrayList<FFTBin>();
        for (int i = 1; i < n - 1; ++i) {
            n7 = nArray[i];
            n6 = (n8 + n7 >> 1) - n8;
            n8 += n6;
            if (n7 > n4) {
                n4 = n7;
                n5 = i;
                continue;
            }
            if (n6 > n2) {
                n3 = -n2;
                n2 = Integer.MAX_VALUE;
                n4 = n7;
                n5 = i;
                continue;
            }
            if (n6 >= n3) continue;
            int n9 = nArray[n5 - 1];
            int n10 = nArray[n5];
            int n11 = nArray[n5 + 1];
            double d2 = (double)n5 + 0.5 * (double)(n9 - n11) / (double)(n9 - 2 * n10 + n11);
            double d3 = (double)n10 - 0.25 * (double)(n9 - n11) * (d2 - (double)n5);
            int n12 = (int)Math.round(d2 / (double)nArray.length / 2.0 * d);
            int n13 = (int)Math.round(d3);
            arrayList.add(new FFTBin(n12, n13));
            n2 = -n3;
            n3 = Integer.MIN_VALUE;
            n4 = Integer.MAX_VALUE;
        }
        return arrayList;
    }

    private BigDecimal getBDHzPerDiv() {
        BigDecimal bigDecimal = BigDecimal.valueOf(this.len);
        BigDecimal bigDecimal2 = this.cm.getTimeControl().getBDTimebase().multiply(BigDecimal.valueOf(20L));
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2);
        BigDecimal bigDecimal4 = bigDecimal3.divide(BigDecimal.valueOf(2L)).divide(BigDecimal.valueOf(20L));
        return bigDecimal4;
    }

    private double getHzPerDiv() {
        return this.getBDHzPerDiv().doubleValue() / (double)FFTControl.SCALES_VALUE[this.cm.getFFTControl().fftscale];
    }

    private double getHzPerPix() {
        return this.getHzPerDiv() / (double)this.getPixPerHorizdiv();
    }

    private int getPixPerHorizdiv() {
        return this.width / 20;
    }

    private double getVoltBetweenPix() {
        return this.voltPerDiv * 10.0 / (double)this.height;
    }

    private double getdBperPix() {
        return (double)FFTControl.dBValuePerDiv[this.dBbaseidx] * 10.0 / (double)this.height;
    }

    public void setVrmsIdx(int n) {
        this.vrmsIdx = n;
        this.updateYScaleRate();
    }

    public void reset() {
        this.xoff = 0;
        this.yoff = (this.mc.fftvaluetype == 0 ? 4 : -3) * this.height / 10;
    }

    public void updateYScaleRate() {
        if (!this.isOn()) {
            this.reset();
            return;
        }
        boolean bl = this.cm.isRuntime();
        VoltageProvider voltageProvider = this.cm.getCoreControl().getVoltageProvider();
        WaveForm waveForm = this.wfm.getWaveForm(this.mc.getFFTchl());
        int n = waveForm.wfi.ci.getProbeMultiIdx();
        int n2 = bl ? waveForm.getVoltbaseIndex() : waveForm.basevbidx;
        switch (this.mc.fftvaluetype) {
            case 0: {
                if (this.vrmsIdx < 0) {
                    this.vrmsIdx = n2 > 0 ? n2 - 1 : n2;
                }
                this.yScaleRate = this.cm.getMachineInfo().getVoltagesRatio(n2, this.vrmsIdx);
                this.voltPerDiv = voltageProvider.getVoltage(n, this.vrmsIdx);
                break;
            }
            case 1: {
                this.yScaleRate = (double)FFTControl.dBValuePerDiv[0] / (double)FFTControl.dBValuePerDiv[this.dBbaseidx];
                this.voltPerDiv = voltageProvider.getVoltage(n, n2);
            }
        }
    }

    @Override
    public void adjustView(ScreenContext screenContext, Rectangle rectangle) {
        this.is3in1 = screenContext.isScreenMode_3();
        this.rec = rectangle;
        this.bg.adjustView(rectangle, this.is3in1);
        this.xb = rectangle.x;
        this.wc = this.xb + (rectangle.width >> 1);
        this.hc = rectangle.y + (rectangle.height >> 1);
        this.setXGap();
        this.scale();
        this.resetXoff();
        this.cm.fftctr.resetCursor(rectangle);
        this.bg.setXunitlen(10);
        this.bg.setYunitlen(this.is3in1 ? 5 : 10);
        this.yoff = (int)Math.round((double)this.yoff * ((double)rectangle.height / (double)this.height));
        this.height = rectangle.height;
        this.width = rectangle.width;
    }

    public void increX(int n) {
        this.xoff += n;
    }

    public void scale() {
        int n = this.mc.fftscale;
        if (n < 0 || n >= FFTControl.scale.length) {
            return;
        }
        int n2 = this.xoff;
        double d = (double)FFTControl.SCALES_VALUE[n] / (double)FFTControl.SCALES_VALUE[this.lastScaleIdx];
        this.xgap *= d;
        int n3 = this.width >> 1;
        int n4 = n3 - n2;
        n4 = (int)((double)n4 * d);
        int n5 = n3 - n4;
        if (n == 0) {
            this.xoff = 0;
        } else if (this.xoff != 0) {
            this.xoff = n5;
        }
        this.lastScaleIdx = n;
    }

    public void increY(int n) {
        this.yoff += n;
    }

    public String getXLabel(int n) {
        String string = UnitConversionUtil.getSimplifiedFrequencyLabel_Hz((double)n * this.getHzPerPix());
        return string;
    }

    public String getVrmsLabel(int n) {
        return UnitConversionUtil.getSimplifiedVoltLabel_mV((double)n * this.getVoltBetweenPix());
    }

    public String getdBLabel(int n) {
        return SFormatter.UIformat("%.1f", (double)n * this.getdBperPix()) + " dB";
    }

    public int getMarkX0Location() {
        return this.xb + this.xoff;
    }

    public int getMarkY0Location() {
        return this.hc + this.yoff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintView(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        graphics2D.scale(DataHouse.xRate, DataHouse.yRate);
        Font font = graphics2D.getFont();
        double d = (DataHouse.yRate < 1.0 ? 1.0 : DataHouse.yRate) * 1.2;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d / DataHouse.xRate, d / DataHouse.yRate);
        graphics2D.setFont(font.deriveFont(affineTransform));
        this.bg.paintView(graphics2D, screenContext);
        WaveForm waveForm = this.wfm.getWaveForm(this.mc.getFFTchl());
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        boolean bl = this.isOn();
        if (!bl) {
            return;
        }
        bl = waveForm.isOn();
        if (!bl) {
            String string = SFormatter.UIformat(this.fftchlLack, waveForm.wfi.ci.getName());
            LineUtil.paintPrompt(graphics2D, this.wc, this.hc, Color.RED, string);
            return;
        }
        if (!this.use) {
            return;
        }
        int n5 = n + n3;
        int n6 = n2 + n4;
        this.lr.set(n, n5, n2, n6);
        int n7 = this.getMarkY0Location();
        int n8 = rectangle.y;
        int n9 = rectangle.y + rectangle.height;
        graphics2D.setColor(this.mc.color);
        LineUtil.paintChannelLabel(n7, n8, n9, graphics2D, "F", 1, false);
        graphics2D.setClip(rectangle);
        int n10 = this.getMarkX0Location();
        int[] nArray = this.data;
        synchronized (this.data) {
            this.paint_500(graphics2D, n10, n7);
            // ** MonitorExit[var20_20] (shouldn't be in output)
            this.cm.fftctr.drawFFTCursor(graphics2D, this.rec);
            this.drawFFTInfoBoard(graphics2D, this.rec);
            return;
        }
    }

    protected void drawFFTInfoBoard(Graphics2D graphics2D, Rectangle rectangle) {
        int n = 115;
        int n2 = 32;
        int n3 = rectangle.width - n;
        int n4 = rectangle.y + rectangle.height;
        int n5 = n2 >> 1;
        Color color = graphics2D.getColor();
        graphics2D.setColor(graphics2D.getBackground());
        graphics2D.fillRoundRect(n3 - n, n4 - n5 - 1, n << 1, n2 >> 1, 15, 15);
        WaveForm waveForm = this.wfm.getWaveForm(this.mc.getFFTchl());
        graphics2D.setColor(this.mc.color);
        this.drawFFTTimeBases(graphics2D, n3 += 5, n4 -= 4);
        this.drawVoltBase(graphics2D, n3 - n, n4);
        graphics2D.setColor(color);
    }

    protected void drawHorizPosition(Graphics2D graphics2D, int n, int n2) {
        int n3 = this.getPixPerHorizdiv() * 10 - this.xoff;
        double d = this.getHzPerPix() * (double)n3;
        String string = UnitConversionUtil.getSimplifiedFrequencyLabel_Hz(d);
        graphics2D.drawString("T: " + string, n, n2);
    }

    protected void drawMarkpos0(Graphics2D graphics2D, int n, int n2) {
        int n3 = -this.yoff;
        double d = (double)n3 / 25.0;
        graphics2D.drawString("M: " + d + " Divs", n, n2);
    }

    protected void drawFrequencies(Graphics2D graphics2D, int n, int n2) {
    }

    protected void drawFFTTimeBases(Graphics2D graphics2D, int n, int n2) {
        double d = this.getHzPerDiv();
        String string = UnitConversionUtil.getSimplifiedFrequencyLabel_Hz(d);
        graphics2D.drawString("H: " + string + "/Div", n, n2);
    }

    protected void drawVoltBase(Graphics2D graphics2D, int n, int n2) {
        switch (this.mc.fftvaluetype) {
            case 0: {
                String string = this.mc.VOLTAGEs[this.vrmsIdx].toString();
                graphics2D.drawString("V: " + string + "/Div", n, n2);
                break;
            }
            case 1: {
                String string = this.mc.dBPerDiv[this.dBbaseidx];
                graphics2D.drawString("V: " + string + "/Div", n, n2);
            }
        }
    }

    private void paint_500(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(this.mc.color);
        int n3 = 0;
        double d = this.yScaleRate * (double)this.height / 250.0;
        int n4 = n;
        int n5 = (int)((double)n2 - (double)this.data[n3++] * d);
        double d2 = (double)n + this.xgap + 0.5;
        ++n3;
        int n6 = 2048;
        while (n3 < n6) {
            int n7 = (int)(d2 += this.xgap);
            int n8 = (int)((double)n2 - (double)this.data[n3++] * d);
            graphics2D.drawLine(n4, n5, n7, n8);
            n4 = n7;
            n5 = n8;
        }
    }

    @Override
    public String getYDeltaLocationLabel(int n) {
        switch (this.mc.fftvaluetype) {
            case 0: {
                return this.getVrmsLabel(n);
            }
            case 1: {
                return this.getdBLabel(n);
            }
        }
        return "";
    }

    @Override
    public String getYLocationLabel(int n) {
        int n2 = this.getMarkY0Location();
        return this.getXLabel(n2 - n);
    }

    @Override
    public String getXDeltaLocationLabel(int n) {
        return this.getXLabel(n);
    }

    @Override
    public String getXLocationLabel(int n) {
        int n2 = this.getMarkX0Location();
        return this.getXDeltaLocationLabel(n - n2);
    }

    private void resetXoff() {
        this.xoff = 0;
    }

    private int get_T_x0(Rectangle rectangle) {
        int n = rectangle.x + rectangle.width >> 1;
        return n + 3;
    }
}

