/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.function.FFTView;
import com.owon.uppersoft.dso.function.MarkCursorControl;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.vds.util.Pref;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class FFTCursorControl {
    public int x1;
    public int x2;
    public int y1;
    public int y2;
    private boolean onFrebaseMark;
    private boolean onVoltbaseMark;
    public boolean onFFTx1 = false;
    public boolean onFFTx2 = false;
    public boolean onFFTy1 = false;
    public boolean onFFTy2 = false;
    private String[] xvalues = new String[3];
    private String[] yvalues = new String[3];
    private ControlManager cm;
    private MarkCursorControl mcctr;
    private Rectangle rect;
    public Color color;
    private String labelX;
    private String labelY1;
    private String labelY2;

    public FFTCursorControl(ControlManager controlManager, Pref pref) {
        this.cm = controlManager;
        this.mcctr = controlManager.mcctr;
        this.load(pref);
    }

    public boolean getOnFrebaseMark() {
        return this.onFrebaseMark;
    }

    public boolean getOnVoltbaseMark() {
        return this.onVoltbaseMark;
    }

    public void setOnFrebaseMark(boolean bl) {
        this.onFrebaseMark = bl;
    }

    public void setOnVoltbaseMark(boolean bl) {
        this.onVoltbaseMark = bl;
    }

    public void opendock() {
        this.cm.getDockControl().dockDialogQuickOpenHide("M.Mark.Name");
    }

    public void toogle() {
        if (this.onFrebaseMark || this.onVoltbaseMark) {
            this.onFrebaseMark = false;
            this.onVoltbaseMark = false;
        } else {
            this.onFrebaseMark = true;
            this.onVoltbaseMark = true;
        }
        Platform.getMainWindow().getChartScreen().re_paint();
    }

    public void drawFFTCursor(Graphics2D graphics2D, Rectangle rectangle) {
        boolean bl;
        if (rectangle.height != this.rect.height || rectangle.y != this.rect.y) {
            double d = (double)rectangle.width / (double)this.rect.width;
            double d2 = (double)rectangle.height / (double)this.rect.height;
            this.x1 = (int)((double)rectangle.x + (double)(this.x1 - this.rect.x) * d + 0.5);
            this.y1 = (int)((double)rectangle.y + (double)(this.y1 - this.rect.y) * d2 + 0.5);
            this.rect = new Rectangle(rectangle);
        }
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.color);
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = 16;
        int n4 = rectangle.x + 9;
        int n5 = rectangle.x + 90;
        int n6 = rectangle.x + 180;
        int n7 = rectangle.x + 8;
        int n8 = rectangle.y + rectangle.height - 8;
        graphics2D.drawString("\u2223\u2223", n7, n8);
        boolean bl2 = bl = this.onFrebaseMark || this.onVoltbaseMark;
        if (this.onVoltbaseMark) {
            this.y1 = this.limitYEdge(this.y1);
            this.computeYValues();
            MarkCursorControl.drawHorizontalDashedLine(graphics2D, this.y1, rectangle.x, rectangle.x + rectangle.width);
            MarkCursorControl.drawString(graphics2D, this.labelY1, rectangle.x + 25, this.y1, rectangle, true);
        }
        if (this.onFrebaseMark) {
            this.x1 = this.limitXEdge(this.x1);
            this.computeXValues();
            MarkCursorControl.drawVerticalDashedLine(graphics2D, this.x1, rectangle.y, rectangle.y + rectangle.height);
            MarkCursorControl.drawXString(graphics2D, this.labelX, this.x1, rectangle.y, rectangle);
        }
        graphics2D.setColor(color);
    }

    public boolean checkButton(double d, double d2, Rectangle rectangle) {
        return d > (double)rectangle.x && d2 < (double)(rectangle.y + rectangle.height) && d < (double)(rectangle.x + 28) && d2 > (double)(rectangle.y + rectangle.height - 28);
    }

    public int checkOver(double d, double d2, Rectangle rectangle) {
        int n = 0;
        if (this.onFrebaseMark) {
            if (d > (double)(this.x1 - 5) && d < (double)(this.x1 + 5)) {
                this.onFFTx1 = true;
                n = 11;
            } else {
                this.onFFTx1 = false;
            }
        }
        if (this.onVoltbaseMark) {
            if (d2 > (double)(this.y1 - 5) && d2 < (double)(this.y1 + 5)) {
                this.onFFTy1 = true;
                n = 9;
            } else {
                this.onFFTy1 = false;
            }
        }
        if (this.checkButton(d, d2, rectangle)) {
            n = 12;
        }
        return n;
    }

    public boolean dragFFTCursor(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        n = (int)((double)n / DataHouse.xRate);
        n2 = (int)((double)n2 / DataHouse.yRate);
        if (this.onFFTx1) {
            this.x1 = this.limitXEdge(n);
            return true;
        }
        if (this.onFFTy1) {
            this.y1 = this.limitYEdge(n2);
            return true;
        }
        return false;
    }

    private void computeXValues() {
        FFTView fFTView = Platform.getDataHouse().getWaveFormManager().getFFTView();
        int n = fFTView.getMarkX0Location();
        this.labelX = fFTView.getXLabel(this.x1 - n);
    }

    private void computeYValues() {
        FFTView fFTView = Platform.getDataHouse().getWaveFormManager().getFFTView();
        int n = fFTView.getMarkY0Location();
        int n2 = this.y1;
        switch (this.cm.getFFTControl().fftvaluetype) {
            case 0: {
                this.labelY1 = fFTView.getVrmsLabel(n - n2);
                break;
            }
            case 1: {
                this.labelY1 = fFTView.getdBLabel(n - n2);
            }
        }
    }

    private String[] getXvalues() {
        FFTView fFTView = Platform.getDataHouse().getWaveFormManager().getFFTView();
        int n = fFTView.getMarkX0Location();
        this.x1 = this.limitXEdge(this.x1);
        this.xvalues[0] = fFTView.getXLabel(this.x1 - n);
        return this.xvalues;
    }

    private String[] getYvalues() {
        FFTView fFTView = Platform.getDataHouse().getWaveFormManager().getFFTView();
        int n = fFTView.getMarkY0Location();
        this.y1 = this.limitYEdge(this.y1);
        switch (this.cm.getFFTControl().fftvaluetype) {
            case 0: {
                this.yvalues[0] = fFTView.getVrmsLabel(n - this.y1);
                break;
            }
            case 1: {
                this.yvalues[0] = fFTView.getdBLabel(n - this.y1);
            }
        }
        return this.yvalues;
    }

    private int limitXEdge(int n) {
        Rectangle rectangle = this.rect;
        if (n <= rectangle.x) {
            n = rectangle.x + 1;
        } else if (n > rectangle.x + rectangle.width) {
            n = rectangle.x + rectangle.width - 1;
        }
        return n;
    }

    private int limitYEdge(int n) {
        Rectangle rectangle = this.rect;
        if (n <= rectangle.y) {
            n = rectangle.y + 1;
        } else if (n > rectangle.y + rectangle.height) {
            n = rectangle.y + rectangle.height - 1;
        }
        return n;
    }

    public void persist(Pref pref) {
        pref.persistInt("FFTCursor.x1", (this.x1 - this.rect.x) * 1000 / this.rect.width);
        pref.persistInt("FFTCursor.x2", (this.x2 - this.rect.x) * 1000 / this.rect.width);
        pref.persistInt("FFTCursor.y1", (this.y1 - this.rect.y) * 250 / this.rect.height);
        pref.persistInt("FFTCursor.y2", (this.y2 - this.rect.y) * 250 / this.rect.height);
        pref.persistBoolean("FFTCursor.onFrebaseMark", this.onFrebaseMark);
        pref.persistBoolean("FFTCursor.onVoltbaseMark", this.onVoltbaseMark);
        pref.persistColor("FFTCursor.rgb", this.color);
    }

    public void load(Pref pref) {
        this.rect = new Rectangle(0, 0, 1000, 250);
        this.x1 = pref.loadInt("FFTCursor.x1");
        this.x2 = pref.loadInt("FFTCursor.x2");
        this.y1 = pref.loadInt("FFTCursor.y1");
        this.y2 = pref.loadInt("FFTCursor.y2");
        this.onFrebaseMark = pref.loadBoolean("FFTCursor.onFrebaseMark");
        this.onVoltbaseMark = pref.loadBoolean("FFTCursor.onVoltbaseMark");
        this.color = pref.loadColor("FFTCursor.rgb", Color.PINK);
        this.labelY2 = null;
        this.labelY1 = null;
        this.labelX = null;
    }

    public void resetCursor(Rectangle rectangle) {
    }
}

