/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.data.DataOutput;
import com.owon.uppersoft.dso.global.ControlApps;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.source.comm.AbsInterCommunicator;
import com.owon.uppersoft.vds.core.wf.dm.DMInfo;
import com.owon.uppersoft.vds.ui.dialog.ProgressMonitorDialog;
import com.owon.uppersoft.vds.util.FileUtil;
import com.owon.uppersoft.vds.util.MyFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;

public class ExportWaveControl
implements PropertyChangeListener {
    private static final int TYPE_PNG = 0;
    private static final int TYPE_TXT = 1;
    private static final int TYPE_CSV = 2;
    private static final int TYPE_XLS = 3;
    private static final int TYPE_BIN = 4;
    public static MyFileFilter[] exportFilters = new MyFileFilter[]{MyFileFilter.PNGFilter, MyFileFilter.TxtFilter, MyFileFilter.CsvFilter, MyFileFilter.XlsFilter, MyFileFilter.BINFilter};
    private boolean authorizeExport = false;
    public ProgressMonitorDialog exportPMD;
    public Thread exprotThread;
    private int expTypidx;
    public File expOutFile;
    protected ControlManager cm;
    protected DataOutput dataOutput;
    private MyFileFilter exportFilter = MyFileFilter.PNGFilter;

    public boolean isAuthorizeExport() {
        return this.authorizeExport;
    }

    public void setAuthorizeExport(boolean bl) {
        this.authorizeExport = bl;
    }

    public ExportWaveControl(ControlManager controlManager) {
        this.cm = controlManager;
        this.dataOutput = new DataOutput();
        controlManager.pcs.addPropertyChangeListener(this);
    }

    public DataOutput getDataOutput() {
        return this.dataOutput;
    }

    public void loadDMfile(Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setPreferredSize(new Dimension(500, 500));
        jFileChooser.setCurrentDirectory(new File(this.cm.openfilePath));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(MyFileFilter.BINFilter);
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog(component);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        DataHouse dataHouse = Platform.getDataHouse();
        if (!this.cm.binIn.openfile(dataHouse, file)) {
            return;
        }
        this.cm.openfilePath = FileUtil.getFileCanonicalPath(jFileChooser.getCurrentDirectory());
    }

    public void exportDMfile(Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setPreferredSize(new Dimension(500, 500));
        jFileChooser.setCurrentDirectory(new File(this.cm.exportPath));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(0);
        for (MyFileFilter myFileFilter : exportFilters) {
            jFileChooser.addChoosableFileFilter(myFileFilter);
        }
        jFileChooser.setFileFilter(this.exportFilter);
        int n = jFileChooser.showSaveDialog(component);
        if (n != 0) {
            return;
        }
        this.exportFilter = (MyFileFilter)jFileChooser.getFileFilter();
        this.expTypidx = ExportWaveControl.indexOf(exportFilters, this.exportFilter);
        this.expOutFile = FileUtil.checkFileSuffix(jFileChooser, this.exportFilter.getEnds());
        this.cm.exportPath = FileUtil.getFileCanonicalPath(jFileChooser.getCurrentDirectory());
        if (this.expTypidx == 0) {
            this.dataOutput.exportWaveAsPicture(this.expOutFile, "png");
            return;
        }
        if (this.expTypidx == 4 && Platform.getDataHouse().isPlayRecord()) {
            Platform.getMainWindow().prompt(I18nProvider.bundle().getString("M.Utility.ExportWave.nonsupport"));
            return;
        }
        this.setAuthorizeExport(true);
        this.pauseNIntendtoExport();
    }

    private void pauseNIntendtoExport() {
        DataHouse dataHouse = Platform.getDataHouse();
        WaveFormManager waveFormManager = dataHouse.getWaveFormManager();
        ControlApps controlApps = dataHouse.getControlApps();
        AbsInterCommunicator absInterCommunicator = Platform.getControlApps().interComm;
        if (dataHouse.isPlayRecord()) {
            this.println("isPlayRecord()");
            absInterCommunicator.prepare2PersistDMData();
            DMInfo dMInfo = absInterCommunicator.createDatasaver().saveFileM(this.cm, AbsInterCommunicator.dmf, null, null);
            if (dMInfo != null) {
                int n = dataHouse.getStatus();
                dataHouse.receiveOfflineDMData(dMInfo);
                dataHouse.setStatus(n);
                this.lastExportWave(this.expOutFile, waveFormManager);
            }
            return;
        }
        if (dataHouse.isDMLoad()) {
            this.println("isDMLoad()");
            this.lastExportWave(this.expOutFile, waveFormManager);
            return;
        }
        if (this.cm.isRuntime()) {
            absInterCommunicator.statusStop(true);
        } else if (!controlApps.isDMDataGotAlready()) {
            absInterCommunicator.onExport_get();
        } else if (controlApps.isDMAvailable()) {
            this.lastExportWave(this.expOutFile, waveFormManager);
        }
    }

    public void lastExportWave(final File file, final WaveFormManager waveFormManager) {
        if (!this.isAuthorizeExport()) {
            return;
        }
        final File file2 = AbsInterCommunicator.dmf;
        final int n = this.getExpTypidx();
        this.exportPMD = new ProgressMonitorDialog(waveFormManager.getDataHouse().getMainWindow().getFrame(), I18nProvider.bundle().getString("Action.ExportWave"), "", "", 0, 100);
        if (n == 3) {
            this.exprotThread = new Thread(){

                @Override
                public void run() {
                    ExportWaveControl.this.dataOutput.exportXLS(file, ExportWaveControl.this.exportPMD, waveFormManager);
                    ExportWaveControl.this.setAuthorizeExport(false);
                }
            };
            this.exprotThread.start();
        } else {
            this.exprotThread = new Thread(){

                @Override
                public void run() {
                    switch (n) {
                        case 4: {
                            ExportWaveControl.this.dataOutput.exportWaveAsBin(file, ExportWaveControl.this.exportPMD, waveFormManager, file2);
                            break;
                        }
                        case 1: {
                            ExportWaveControl.this.dataOutput.exportText(file, ExportWaveControl.this.exportPMD, waveFormManager, ExportWaveControl.this.cm.getDeepMemoryControl().getDeepIdx());
                            break;
                        }
                        case 2: {
                            ExportWaveControl.this.dataOutput.exportCSV(file, ExportWaveControl.this.exportPMD, waveFormManager);
                            break;
                        }
                    }
                    ExportWaveControl.this.setAuthorizeExport(false);
                }
            };
            this.exprotThread.start();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equalsIgnoreCase("afterGotDMData")) {
            WaveFormManager waveFormManager = (WaveFormManager)propertyChangeEvent.getNewValue();
            this.lastExportWave(this.cm.ewc.expOutFile, waveFormManager);
            this.configln("lastExportWave");
        }
    }

    public int getExpTypidx() {
        return this.expTypidx;
    }

    public void setExpTypidx(int n) {
        this.expTypidx = n;
    }

    private void configln(String string) {
    }

    private void println(String string) {
    }

    private static int indexOf(Object[] objectArray, Object object) {
        int n = objectArray.length;
        while (--n >= 0 && objectArray[n] != object) {
        }
        return n;
    }
}

