/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.function;

import com.owon.uppersoft.dso.data.LObject;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.vds.core.paint.ColorProvider;
import com.owon.uppersoft.vds.data.RGB;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import com.owon.uppersoft.vds.util.Pref;
import java.awt.Color;

public class DisplayControl
implements ColorProvider {
    public static final Object[] Persistence = new Object[]{new LObject("M.Display.Persistence.Off"), "0.5s", "1s", "2s", "5s", new LObject("M.Display.Persistence.Infinite")};
    public static final Object[] Persistence_phosphor = new Object[]{new LObject("M.Display.Persistence.Off"), "0.5s", "1s", "2s", "5s", new LObject("M.Display.Persistence.Infinite"), new LObject("M.Display.Phosphor")};
    private boolean phosphorSwitch;
    private int persistenceIndex;
    public int marktypeIndex = 0;
    private RGB gridBrightness = new RGB();
    public boolean linelink;
    private boolean xyon;
    public Color xycolor;
    public int wfx = 0;
    public int wfy = 1;
    public int CompositDrawTimes = 3;
    public static final int MaxCompositDrawTimes = 10;
    private ControlManager cm;

    public DisplayControl(Pref pref, ControlManager controlManager) {
        this.cm = controlManager;
        this.load(pref);
        this.phosphorSwitch = controlManager.getMachine().isPhosphorOn();
    }

    public Object[] getPersistenceItems() {
        if (this.phosphorSwitch) {
            return Persistence_phosphor;
        }
        return Persistence;
    }

    public boolean isPhosphorOn() {
        return this.phosphorSwitch;
    }

    public boolean isXYModeOn() {
        return this.xyon;
    }

    public void setXYMode(boolean bl) {
        this.xyon = bl;
        if (!bl) {
            return;
        }
        if (this.cm.getDeepMemoryControl().restrictDeepMemory()) {
            Platform.getMainWindow().getToolPane().getDetailPane().updateDM_Sample();
            FadeIOShell fadeIOShell = new FadeIOShell();
            fadeIOShell.prompt(I18nProvider.bundle().getString("Info.XYModeForceDeepMemory"), Platform.getMainWindow().getFrame());
        }
    }

    public int getGridBrightness() {
        return this.gridBrightness.blue;
    }

    @Override
    public Color getGridColor() {
        return this.gridBrightness.getColor();
    }

    private void initGridBrightness(int n) {
        this.gridBrightness.blue = n = Math.min(n, 255);
        this.gridBrightness.green = n;
        this.gridBrightness.red = n;
    }

    public void changeGridBrightness(int n, MainWindow mainWindow) {
        this.initGridBrightness(n);
        mainWindow.updateGridColor();
    }

    public void loadFactorySet(Pref pref) {
        this.load(pref);
    }

    public void load(Pref pref) {
        this.initGridBrightness(pref.loadInt("GridBrightness"));
        this.linelink = pref.loadBoolean("LineLink");
        this.wfx = pref.loadInt("WaveFormX");
        this.wfy = pref.loadInt("WaveFormY");
        if (this.wfx >= this.cm.getSupportChannelsNumber()) {
            this.wfx = this.cm.getSupportChannelsNumber() - 1;
        }
        if (this.wfy >= this.cm.getSupportChannelsNumber()) {
            this.wfy = this.cm.getSupportChannelsNumber() - 1;
        }
        this.xyon = pref.loadBoolean("XYModeOn");
        this.xycolor = pref.loadColor("XYMode.rgb", Color.CYAN);
        this.CompositDrawTimes = pref.loadInt("CompositDrawTimes");
        if (this.CompositDrawTimes > 10) {
            this.CompositDrawTimes = 10;
        } else if (this.CompositDrawTimes < 1) {
            this.CompositDrawTimes = 1;
        }
        this.setPersistenceIndex(pref.loadInt("PersistenceIndex"));
    }

    public void persist(Pref pref) {
        pref.persistBoolean("XYModeOn", this.xyon);
        pref.persistColor("XYMode.rgb", this.xycolor);
        pref.persistInt("WaveFormX", this.wfx);
        pref.persistInt("WaveFormY", this.wfy);
        pref.persistInt("GridBrightness", this.getGridBrightness());
        pref.persistBoolean("LineLink", this.linelink);
        pref.persistInt("CompositDrawTimes", this.CompositDrawTimes);
        pref.persistInt("PersistenceIndex", this.getPersistenceIndex());
    }

    public int getPersistenceIndex() {
        int n = this.getPersistenceItems().length;
        if (this.persistenceIndex >= n) {
            return n - 1;
        }
        return this.persistenceIndex;
    }

    public int setPersistenceIndex(int n) {
        this.persistenceIndex = n;
        return n;
    }
}

