/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.data;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.help.IExportableWF;
import com.owon.uppersoft.vds.core.data.CByteArrayInputStream;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.util.format.SFormatter;

public class WFO
implements IExportableWF {
    private CByteArrayInputStream ba;
    private ControlManager cm;
    private WaveFormInfo wfi;
    private WaveForm wf;
    private int initPos0;
    private int DMFilePointer;
    private int trighori;
    private int datalen;
    private double adcperpix;
    private double timeperpts;

    public WFO(CByteArrayInputStream cByteArrayInputStream, ControlManager controlManager) {
        this.ba = cByteArrayInputStream;
        this.cm = controlManager;
    }

    public WFO setWF(WaveForm waveForm) {
        this.wf = waveForm;
        this.wfi = waveForm.wfi;
        this.datalen = this.wfi.getDataLen();
        this.adcperpix = this.getVoltBetweenPix();
        this.timeperpts = this.getTimePerPoints();
        this.trighori = this.cm.getTimeControl().getHorTrgIdx();
        this.initPos0 = waveForm.getFirstLoadPos0();
        this.DMFilePointer = this.wfi.getDMFilePointer();
        return this;
    }

    @Override
    public boolean isOn() {
        return this.wfi.ci.isOn();
    }

    @Override
    public int getDatalen() {
        return this.wfi.getDataLen();
    }

    @Override
    public String getChannelLabel() {
        return this.wf.toString();
    }

    @Override
    public double voltAt(int n) {
        if (this.ba == null) {
            return -1.0;
        }
        if (n >= this.datalen) {
            return 0.0;
        }
        double d = (double)(this.ba.byteAt(this.DMFilePointer + n) - this.initPos0) * this.adcperpix;
        return d;
    }

    @Override
    public double timeAt(int n) {
        if (n >= this.datalen) {
            return 0.0;
        }
        double d = (double)(this.trighori - n) * this.timeperpts;
        return d;
    }

    protected double getVoltBetweenPix() {
        double d = this.wfi.ci.getVoltValue() / 25.0;
        return d;
    }

    protected double getTimePerPoints() {
        double d = this.cm.getTimeControl().getBDTimebase().doubleValue();
        double d2 = d * 1000.0 * 20.0 / (double)this.datalen;
        return d2;
    }

    @Override
    public String getFreqLabel() {
        return this.cm.getFreqLabel(this.wfi.ci);
    }

    @Override
    public String getPeriod() {
        String string = this.cm.getFreqLabel(this.wfi.ci);
        String string2 = "";
        if ("?".equals(string)) {
            string2 = "?";
        } else if ("<2Hz".equals(string)) {
            string2 = "N/A";
        } else {
            int n = string.indexOf(" ");
            if (n != -1) {
                Double d = Double.parseDouble(string.substring(0, n));
                System.err.println("frequency:" + d);
                String string3 = string.substring(n + 1);
                if ("kHz".equals(string3)) {
                    d = d * 1000.0;
                } else if ("MHz".equals(string3)) {
                    d = d * 1000000.0;
                } else if ("GHz".equals(string3)) {
                    d = d * 1.0E9;
                }
                if (d != 0.0) {
                    Double d2;
                    Double d3 = d2 = Double.valueOf(1.0 / d);
                    if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                        string2 = "?";
                    } else {
                        string2 = SFormatter.UIformat("%.3f s", d3);
                        if (Math.abs(d3) < 1.0) {
                            d3 = d3 * 1000.0;
                            string2 = SFormatter.UIformat("%.3f ms", d3);
                        }
                        if (Math.abs(d3) < 1.0) {
                            d3 = d3 * 1000.0;
                            string2 = SFormatter.UIformat("%.3f us", d3);
                        }
                        if (Math.abs(d3) < 1.0) {
                            d3 = d3 * 1000.0;
                            string2 = SFormatter.UIformat("%.3f ns", d3);
                        }
                    }
                }
            } else {
                string2 = "?";
            }
        }
        return string2.replace(",", ".");
    }
}

