/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.data;

import com.owon.uppersoft.dso.data.WFO;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.view.ChartScreen;
import com.owon.uppersoft.dso.wf.ON_WF_Iterator;
import com.owon.uppersoft.vds.ui.dialog.ProgressMonitorDialog;
import com.owon.uppersoft.vds.util.FileUtil;
import com.owon.uppersoft.vds.util.StringPool;
import com.owon.uppersoft.vds.util.format.SimpleStringFormatter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class DataOutput {
    public static final int everyPageCount = 50000;
    public static final int sheetLimitperBook = 1;
    private final String freqlbl = "AutoMeasure.FREQuency";
    private final String timebl = "AutoMeasure.PERiod";

    public final void exportWaveAsPicture(File file, String string) {
        ChartScreen chartScreen = Platform.getMainWindow().getChartScreen();
        BufferedImage bufferedImage = chartScreen.getChartScreenBufferedImage();
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final File exportScreenShot(String string, String string2, ChartScreen chartScreen) {
        System.out.println("exportScreenShot");
        ControlManager controlManager = Platform.getDataHouse().controlManager;
        File file = new File(string);
        try {
            BufferedImage bufferedImage = chartScreen.getChartScreenBufferedImage();
            ImageIO.write((RenderedImage)bufferedImage, string2, file);
        }
        catch (Exception exception) {
            System.out.println("catch!!!!!!!!!!!!!!!!!!!!");
            return null;
        }
        return file;
    }

    public final void exportWaveAsBin(File file, ProgressMonitorDialog progressMonitorDialog, WaveFormManager waveFormManager, File file2) {
        progressMonitorDialog.toFront();
        progressMonitorDialog.setValue_Note(0);
        File file3 = file2;
        try {
            FileUtil.copyFile(file3, file);
            progressMonitorDialog.addProgressValue_Note(100);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        progressMonitorDialog.close();
    }

    public final void exportXLS(File file, ProgressMonitorDialog progressMonitorDialog, WaveFormManager waveFormManager) {
        progressMonitorDialog.setVisible(true);
        progressMonitorDialog.toFront();
        progressMonitorDialog.setValue_Note(0);
        WFO wFO = this.getWaveformOutput();
        String[] stringArray = this.getHeaders(waveFormManager, wFO);
        double[][] dArray = this.getValues(waveFormManager, wFO);
        try {
            int n;
            WritableWorkbook writableWorkbook = Workbook.createWorkbook(file);
            WritableSheet writableSheet = writableWorkbook.createSheet("export", 0);
            writableSheet.addCell(new Label(0, 0, "#"));
            for (n = 0; n < dArray.length; ++n) {
                writableSheet.addCell(new Number(0, 1 + n, (double)n));
            }
            for (n = 0; n < stringArray.length; ++n) {
                writableSheet.addCell(new Label(1 + n, 0, stringArray[n]));
                for (int i = 0; i < dArray.length; ++i) {
                    writableSheet.addCell(new Number(1 + n, 1 + i, dArray[i][n]));
                }
            }
            writableWorkbook.write();
            writableWorkbook.close();
            progressMonitorDialog.close();
            System.gc();
        }
        catch (RowsExceededException rowsExceededException) {
        }
        catch (WriteException writeException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void exportCSV(File file, ProgressMonitorDialog progressMonitorDialog, WaveFormManager waveFormManager) {
        progressMonitorDialog.setVisible(true);
        progressMonitorDialog.toFront();
        progressMonitorDialog.setValue_Note(0);
        WFO wFO = this.getWaveformOutput();
        String[] stringArray = this.getHeaders(waveFormManager, wFO);
        double[][] dArray = this.getValues(waveFormManager, wFO);
        try {
            int n;
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.append("#");
            for (n = 0; n < stringArray.length; ++n) {
                fileWriter.append(",");
                fileWriter.append(stringArray[n]);
            }
            fileWriter.append("\r\n");
            for (n = 0; n < dArray.length; ++n) {
                fileWriter.append(String.valueOf(n));
                fileWriter.append(",");
                fileWriter.append(String.format("%.7f", dArray[n][0]));
                for (int i = 1; i < dArray[n].length; ++i) {
                    fileWriter.append(",");
                    fileWriter.append(String.format("%.2f", dArray[n][i]));
                }
                fileWriter.append("\r\n");
            }
            fileWriter.flush();
            fileWriter.close();
            progressMonitorDialog.close();
            System.gc();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void exportText(File file, ProgressMonitorDialog progressMonitorDialog, WaveFormManager waveFormManager, int n) {
        progressMonitorDialog.setVisible(true);
        progressMonitorDialog.toFront();
        progressMonitorDialog.setValue_Note(0);
        WFO wFO = this.getWaveformOutput();
        String[] stringArray = this.getHeaders(waveFormManager, wFO);
        double[][] dArray = this.getValues(waveFormManager, wFO);
        SimpleStringFormatter simpleStringFormatter = new SimpleStringFormatter(n);
        try {
            int n2;
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.append(simpleStringFormatter.valueToStringOnRight("#"));
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                fileWriter.append(simpleStringFormatter.valueToStringOnRight(stringArray[n2]));
            }
            fileWriter.append(StringPool.LINE_SEPARATOR);
            for (n2 = 0; n2 < dArray.length; ++n2) {
                fileWriter.append(simpleStringFormatter.valueToStringOnRight(String.valueOf(n2)));
                fileWriter.append(simpleStringFormatter.valueToStringOnRight(String.format("%.7f", dArray[n2][0])));
                for (int i = 1; i < dArray[n2].length; ++i) {
                    fileWriter.append(simpleStringFormatter.valueToStringOnRight(String.format("%.2f", dArray[n2][i])));
                }
                fileWriter.append(StringPool.LINE_SEPARATOR);
            }
            fileWriter.flush();
            fileWriter.close();
            progressMonitorDialog.close();
            System.gc();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private WFO getWaveformOutput() {
        DataHouse dataHouse = Platform.getDataHouse();
        WFO wFO = new WFO(dataHouse.getDeepMemoryStorage(), dataHouse.controlManager);
        return wFO;
    }

    private String[] getHeaders(WaveFormManager waveFormManager, WFO wFO) {
        String string = I18nProvider.bundle().getString("Label.ExportTimeUnit");
        String string2 = I18nProvider.bundle().getString("Label.ExportUnit");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        ON_WF_Iterator oN_WF_Iterator = waveFormManager.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WFO wFO2 = wFO.setWF(oN_WF_Iterator.next());
            arrayList.add(String.format(string2, wFO2.getChannelLabel()));
        }
        return arrayList.toArray(new String[0]);
    }

    private double[][] getValues(WaveFormManager waveFormManager, WFO wFO) {
        int n = 0;
        int n2 = 1;
        Object object = waveFormManager.on_wf_Iterator();
        while (((ON_WF_Iterator)object).hasNext()) {
            WFO wFO2 = wFO.setWF(((ON_WF_Iterator)object).next());
            n = Math.max(wFO2.getDatalen(), n);
            ++n2;
        }
        object = new double[n][n2];
        int n3 = 1;
        ON_WF_Iterator oN_WF_Iterator = waveFormManager.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WFO wFO3 = wFO.setWF(oN_WF_Iterator.next());
            if (wFO3 == null) continue;
            for (int i = 0; i < wFO3.getDatalen(); ++i) {
                object[i][0] = wFO3.timeAt(i);
                object[i][n3] = wFO3.voltAt(i);
            }
            ++n3;
        }
        return object;
    }

    private void println(String string) {
    }
}

