/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.control;

import com.owon.uppersoft.dso.control.ChartScreenMouseGesture;
import com.owon.uppersoft.dso.control.TrgLevelCheckHandler;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.TrgCheckType;
import com.owon.uppersoft.dso.model.trigger.helper.TrgLevelCheckContext;
import com.owon.uppersoft.dso.model.trigger.helper.TriggerLevelDelegate;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.ViewChart;
import com.owon.uppersoft.dso.wf.ChartScreenSelectModel;
import com.owon.uppersoft.dso.wf.WaveForm;
import java.awt.Point;
import java.awt.Rectangle;

public class RightScreenGesture
implements TrgLevelCheckHandler {
    private TriggerLevelDelegate tld;
    private ChartScreenSelectModel ccsm;
    private TrgLevelCheckContext contxt;
    public static final int CheckAroundSpace = 6;
    private boolean checkResult;

    public RightScreenGesture(TriggerLevelDelegate triggerLevelDelegate, ChartScreenSelectModel chartScreenSelectModel) {
        this.tld = triggerLevelDelegate;
        this.ccsm = chartScreenSelectModel;
        this.contxt = new TrgLevelCheckContext();
    }

    public void mousePressed(ViewChart viewChart, WaveFormManager waveFormManager) {
        int n = this.ccsm.getOperateChannel();
        if (n >= 0) {
            this.ccsm.setScreenSelectWFidx(n);
            this.tld.changeTrgLabel(n, this.ccsm.getOperateThredshodType(), 0, waveFormManager, false);
            viewChart.re_paint();
        }
    }

    public void mouseExited(ViewChart viewChart) {
        if (this.ccsm.isDrawArrow()) {
            this.ccsm.setArrowDraw(false);
            viewChart.re_paint();
        }
        this.ccsm.setRight(false);
    }

    public void mouseReleased() {
        this.ccsm.resetNoneSelect();
    }

    public boolean checkRight(int n, int n2, Rectangle rectangle, ViewChart viewChart, DataHouse dataHouse, ChartScreenMouseGesture chartScreenMouseGesture, WaveFormManager waveFormManager) {
        int n3 = 120;
        int n4 = rectangle.x + rectangle.width + dataHouse.controlManager.paintContext.getChartInsets().right;
        int n5 = rectangle.y;
        int n6 = n5 + rectangle.height;
        boolean bl = n >= n4 - n3 && n <= n4;
        this.ccsm.setOnRightArea(bl);
        boolean bl2 = false;
        if (bl != this.ccsm.isDrawArrow()) {
            this.ccsm.setArrowDraw(bl);
            bl2 = true;
        }
        boolean bl3 = dataHouse.controlManager.getTriggerControl().isTrgEnable();
        boolean bl4 = bl && n2 >= n5 && n2 <= n6;
        boolean bl5 = bl4 = bl3 && bl4;
        if (!bl4) {
            if (bl2) {
                viewChart.re_paint();
            }
            chartScreenMouseGesture.cursor(0);
            return false;
        }
        this.contxt.setEnvironment(n5, n6, n2, viewChart.getScreenContext(), 6);
        this.ccsm.resetOperateChannelAndThredshodType();
        this.tld.checkAllAroundTrgLabel(this, waveFormManager);
        int n7 = this.ccsm.getOperateChannel();
        boolean bl6 = n7 >= 0;
        this.ccsm.setRight(bl6);
        chartScreenMouseGesture.cursor(bl6 ? 8 : 0);
        if (bl2) {
            viewChart.re_paint();
        }
        return bl6;
    }

    public void dragRight(int n, int n2, boolean bl, ViewChart viewChart, MainWindow mainWindow, WaveFormManager waveFormManager, Point point, boolean bl2, ControlManager controlManager) {
        if (controlManager.isTrgLevelDisable()) {
            return;
        }
        int n3 = this.ccsm.getOperateChannel();
        int n4 = point.y - n2;
        if (bl) {
            point.x = n;
            point.y = n2;
        } else {
            int n5 = n4 % 2;
            point.x = n;
            point.y = n2 + (n4 > 0 ? n5 : -n5);
            n4 >>= 1;
        }
        TrgCheckType trgCheckType = this.ccsm.getOperateThredshodType();
        if (n3 >= 0) {
            this.tld.changeTrgLabel(n3, trgCheckType, n4, waveFormManager, bl2);
        }
        viewChart.re_paint();
    }

    @Override
    public void setWaveForm(WaveForm waveForm) {
        this.contxt.setWaveForm(waveForm);
    }

    @Override
    public boolean checkAroundTrgAndHandle(int n, TrgCheckType trgCheckType, TrgCheckType trgCheckType2) {
        if (trgCheckType == TrgCheckType.NotOver) {
            this.checkResult = false;
            this.handleCheckedType(TrgCheckType.NotOver);
            return false;
        }
        this.checkResult = this.contxt.checkAroundTrgLabelInner(n);
        if (!this.checkResult) {
            this.checkResult = this.contxt.checkAroundTrgLabelOuter(n);
        }
        this.handleCheckedType(this.checkResult ? trgCheckType : trgCheckType2);
        return this.checkResult;
    }

    @Override
    public boolean checkAroundTrgAndHandleOnTrue(int n, TrgCheckType trgCheckType) {
        if (trgCheckType == TrgCheckType.NotOver) {
            this.checkResult = false;
            return false;
        }
        this.checkResult = this.contxt.checkAroundTrgLabelInner(n);
        if (!this.checkResult) {
            this.checkResult = this.contxt.checkAroundTrgLabelOuter(n);
        }
        if (this.checkResult) {
            this.handleCheckedType(trgCheckType);
        }
        return this.checkResult;
    }

    private void handleCheckedType(TrgCheckType trgCheckType) {
        this.ccsm.handleCheckedType(this.contxt.channel, trgCheckType);
    }
}

