/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.control;

import com.owon.uppersoft.dso.control.ChartScreenMouseGesture;
import com.owon.uppersoft.dso.function.MarkCursorControl;
import com.owon.uppersoft.dso.function.perspective.CompositeWaveForm;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.view.ChartScreen;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.ViewChart;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.ChartScreenSelectModel;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import java.awt.Point;
import java.awt.Rectangle;

public class LeftScreenGesture {
    private ChartScreenSelectModel ccsm;
    private int rollOverChannel;
    private boolean left;

    public LeftScreenGesture(ChartScreenSelectModel chartScreenSelectModel) {
        this.ccsm = chartScreenSelectModel;
    }

    public void mousePressed(ViewChart viewChart, WaveFormManager waveFormManager) {
        if (this.rollOverChannel >= 0) {
            this.ccsm.setScreenSelectWFidx(this.rollOverChannel);
            this.ccsm.setRight(false);
            viewChart.re_paint();
        }
    }

    public boolean checkLeft(int n, int n2, Rectangle rectangle, ViewChart viewChart, ChartScreenMouseGesture chartScreenMouseGesture, WaveFormManager waveFormManager, boolean bl) {
        this.rollOverChannel = -1;
        this.left = false;
        if (n < rectangle.x) {
            this.left = true;
            this.rollOverChannel = waveFormManager.isWaveFormRollOver(viewChart.getScreenContext(), rectangle, n2);
            if (this.rollOverChannel >= 0) {
                chartScreenMouseGesture.cursor(8);
            } else {
                chartScreenMouseGesture.cursor(0);
            }
        } else if (bl) {
            chartScreenMouseGesture.cursor(0);
        }
        return this.left;
    }

    public void dragLeft(int n, int n2, ScreenContext screenContext, ChartScreen chartScreen, MainWindow mainWindow, WaveFormManager waveFormManager, Point point, MarkCursorControl markCursorControl, boolean bl) {
        int n3 = this.ccsm.getScreenSelectWFidx();
        if (n3 < 0) {
            return;
        }
        boolean bl2 = screenContext.isScreenMode_3();
        int n4 = screenContext.getHcenter();
        int n5 = point.y - n2;
        if (n3 == Integer.MAX_VALUE) {
            CompositeWaveForm compositeWaveForm = waveFormManager.getCompositeWaveForm();
            compositeWaveForm.onShowPos0 = true;
            int n6 = this.compute(compositeWaveForm.getYloc(), n5, n, n2, point, bl2);
            compositeWaveForm.setYlocIncrement(n6, bl2, n4);
            chartScreen.rebuffer();
            markCursorControl.computeYValues();
        } else {
            WaveForm waveForm = waveFormManager.getWaveForm(n3);
            ChannelInfo channelInfo = waveForm.wfi.ci;
            int n7 = channelInfo.getPos0();
            waveForm.onShowPos0 = true;
            int n8 = this.compute(n7, n5, n, n2, point, bl2);
            waveFormManager.setZeroYLoc(waveForm, n8, bl);
            markCursorControl.computeYValues();
            mainWindow.getToolPane().getInfoPane().updatePos0(channelInfo.getNumber());
            mainWindow.update_Pos0();
        }
    }

    private int compute(int n, int n2, int n3, int n4, Point point, boolean bl) {
        int n5;
        if (bl) {
            n5 = n + n2;
            point.x = n3;
            point.y = n4;
        } else {
            n5 = n + (n2 >> 1);
            int n6 = n2 % 2;
            point.x = n3;
            point.y = n4 + (n2 > 0 ? n6 : -n6);
        }
        return n5;
    }

    public void mouseReleased(WaveFormManager waveFormManager) {
        int n = this.ccsm.getScreenSelectWFidx();
        int n2 = waveFormManager.getWaveFormInfoControl().getLowMachineChannels();
        if (n == Integer.MAX_VALUE) {
            waveFormManager.getCompositeWaveForm().onShowPos0 = false;
        } else if (n >= 0 && n < n2) {
            WaveForm waveForm = waveFormManager.getWaveForm(n);
            waveForm.onShowPos0 = false;
        }
        this.ccsm.resetNoneSelect();
    }
}

