/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.control;

import com.owon.uppersoft.dso.function.FFTCursorControl;
import com.owon.uppersoft.dso.function.FFTView;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.view.ViewChart;
import com.owon.uppersoft.vds.data.Point;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class FFTMouseAdapter
extends MouseAdapter {
    private final WaveFormManager wfm;
    private Point loc0 = new Point();
    private FFTCursorControl fftctr;
    private ViewChart v2;
    private boolean onLeft = false;

    public FFTMouseAdapter(WaveFormManager waveFormManager, FFTCursorControl fFTCursorControl, ViewChart viewChart) {
        this.wfm = waveFormManager;
        this.v2 = viewChart;
        this.fftctr = fFTCursorControl;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.v2.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.v2.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.loc0.x = mouseEvent.getX();
        this.loc0.y = mouseEvent.getY();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        double d = (double)mouseEvent.getX() / DataHouse.xRate;
        double d2 = (double)mouseEvent.getY() / DataHouse.yRate;
        Rectangle rectangle = this.v2.getLocInfo();
        boolean bl = this.onLeft = d <= (double)rectangle.x;
        if (this.onLeft) {
            n = 9;
        } else {
            n = this.fftctr.checkOver(d, d2, rectangle);
            if (n == 0) {
                n = 10;
            }
        }
        this.v2.setCursor(Cursor.getPredefinedCursor(n));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Rectangle rectangle;
        double d;
        double d2 = (double)mouseEvent.getX() / DataHouse.xRate;
        if (this.fftctr.checkButton((int)d2, (int)(d = (double)mouseEvent.getY() / DataHouse.yRate), rectangle = this.v2.getLocInfo())) {
            if (mouseEvent.getModifiers() == 16) {
                this.fftctr.toogle();
            } else {
                this.fftctr.opendock();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl = this.fftctr.dragFFTCursor(mouseEvent);
        if (!bl) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.loc0.x;
            int n4 = n2 - this.loc0.y;
            FFTView fFTView = this.wfm.getFFTView();
            if (this.onLeft) {
                fFTView.increY(n4);
            } else {
                fFTView.increX(n3);
            }
            this.loc0.x = n;
            this.loc0.y = n2;
        }
        this.v2.repaint();
    }
}

